/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerslice.components.labeleditor;

import edu.uthscsa.ric.mango.components.MangoPlaceholderTextField;
import edu.uthscsa.ric.mango.viewerslice.components.labeleditor.SeriesLabelEditorUser;
import edu.uthscsa.ric.volume.LabelManager;
import edu.uthscsa.ric.volume.SeriesDefaultLabels;
import edu.uthscsa.ric.volume.Volume;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicArrowButton;

public class SeriesLabelEditor
extends JPanel
implements ActionListener,
DocumentListener,
MouseListener {
    private JButton buttonBack;
    private JButton buttonForward;
    private LabelManager manager;
    private MangoPlaceholderTextField textField;
    private String[] model;
    private boolean skipNotify;
    private int index;
    private final SeriesLabelEditorUser user;
    private static final long serialVersionUID = 1L;
    public static final String ACTION_DONE = "ACTION_DONE";
    public static final int BUTTON_SIZE = 20;
    public static final int PADDING = 4;

    public SeriesLabelEditor(SeriesLabelEditorUser user) {
        this.user = user;
        this.createUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals(ACTION_DONE)) {
            this.user.seriesLabelEditingDone();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
        this.notifyChange();
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        this.notifyChange();
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (me.getSource() == this.buttonForward) {
            this.user.seriesLabelEditorIncremented();
            this.updateEditor();
        } else if (me.getSource() == this.buttonBack) {
            this.user.seriesLabelEditorDecremented();
            this.updateEditor();
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        this.notifyChange();
    }

    public final void updateEditor() {
        this.skipNotify = true;
        this.manager = this.user.getCurrentSeriesLabelManager();
        this.model = this.manager.getLabelModel();
        this.index = this.user.getCurrentTimepoint();
        this.textField.setText(this.model[this.index]);
        this.textField.setPlaceholderText(SeriesDefaultLabels.getDefaultLabel(this.index, (Volume)this.manager));
        this.user.requestFocus();
        this.skipNotify = false;
    }

    private final void createUI() {
        this.textField = new MangoPlaceholderTextField("");
        this.textField.getDocument().addDocumentListener(this);
        this.buttonForward = new BasicArrowButton(3);
        this.buttonForward.addMouseListener(this);
        this.buttonBack = new BasicArrowButton(7);
        this.buttonBack.addMouseListener(this);
        JPanel navigatePanel = new JPanel();
        navigatePanel.setLayout(new BoxLayout(navigatePanel, 0));
        navigatePanel.add(this.buttonBack);
        navigatePanel.add(this.buttonForward);
        JPanel navigateOuterPaner = new JPanel();
        navigateOuterPaner.setLayout(new BoxLayout(navigateOuterPaner, 1));
        navigateOuterPaner.add(Box.createVerticalGlue());
        navigateOuterPaner.add(navigatePanel);
        navigateOuterPaner.add(Box.createVerticalGlue());
        navigateOuterPaner.setPreferredSize(new Dimension(40, -1));
        navigateOuterPaner.setMinimumSize(new Dimension(40, 20));
        navigateOuterPaner.setMaximumSize(new Dimension(40, 20));
        JButton buttonDone = new JButton("Done");
        buttonDone.setActionCommand(ACTION_DONE);
        buttonDone.addActionListener(this);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        mainPanel.add(this.textField);
        mainPanel.add(Box.createHorizontalStrut(4));
        mainPanel.add(navigateOuterPaner);
        mainPanel.add(Box.createHorizontalStrut(4));
        mainPanel.add(buttonDone);
        mainPanel.add(Box.createHorizontalStrut(4));
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalGlue());
        this.add(mainPanel);
        this.add(Box.createVerticalStrut(4));
        this.add(Box.createVerticalGlue());
        this.updateEditor();
    }

    private void notifyChange() {
        if (!this.skipNotify) {
            this.model[this.index] = this.textField.getText();
            this.manager.labelChanged();
            this.user.setShowLabels(true);
        }
    }
}

