/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerprojection.menus;

import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPane;
import edu.uthscsa.ric.mango.dialogs.script.ScriptUtils;
import edu.uthscsa.ric.mango.dialogs.snapshot.Snapshot;
import edu.uthscsa.ric.mango.viewerprojection.ProjectionViewer;
import edu.uthscsa.ric.mango.viewerprojection.core.Projection;
import edu.uthscsa.ric.mango.viewerprojection.dialogs.cine.CineProjection;
import edu.uthscsa.ric.mango.viewerprojection.dialogs.modal.ProjectionDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;

public class ProjectionViewerMenuAction
extends AbstractAction {
    private final ProjectionViewer projView;
    private static final long serialVersionUID = 1L;
    public static final String PROJECTION_ANIMATE = "Animate";
    public static final String PROJECTION_VIDEO = "Create Video...";
    public static final String PROJECTION_SNAPSHOT = "Create Snapshot...";
    public static final String PROJECTION_OPTIONS = "Options...";
    public static final String WINDOW_MAXIMIZE = "Maximize";
    public static final String WINDOW_MINIMIZE = "Dock";
    public static final String WINDOW_STICKY = "Stick to Slice Viewer";
    public static final String WINDOW_ZOOM_IN = "Zoom In";
    public static final String WINDOW_ZOOM_OUT = "Zoom Out";

    public ProjectionViewerMenuAction(String command, ProjectionViewer projView) {
        super(command);
        this.projView = projView;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        if (actionCommand.equals(PROJECTION_OPTIONS)) {
            this.showOptionsDialog();
        } else if (actionCommand.equals(PROJECTION_ANIMATE)) {
            this.projView.getOptions().setAnimating(!this.projView.getOptions().isAnimating());
            if (this.projView.getOptions().isAnimating()) {
                this.projView.startAnimating();
            } else {
                this.projView.stopAnimating();
            }
        } else if (actionCommand.equals(WINDOW_MAXIMIZE)) {
            this.projView.selectWindowMenuOptionMaximize();
        } else if (actionCommand.equals(WINDOW_MINIMIZE)) {
            this.projView.selectWindowMenuOptionMinimize();
        } else if (actionCommand.equals(WINDOW_ZOOM_IN)) {
            this.projView.selectWindowMenuOptionZoomIn();
        } else if (actionCommand.equals(WINDOW_ZOOM_OUT)) {
            this.projView.selectWindowMenuOptionZoomOut();
        } else if (actionCommand.equals(WINDOW_STICKY)) {
            this.projView.setWindowMenuOptionStick(!this.projView.isSticky());
        } else if (actionCommand.equals(PROJECTION_VIDEO)) {
            new CineProjection(this.projView.getViewer(), this.projView);
        } else if (actionCommand.equals(PROJECTION_SNAPSHOT)) {
            new Snapshot(this.projView.getViewer(), this.projView);
        }
    }

    private void showOptionsDialog() {
        final ProjectionDialog dialog = new ProjectionDialog(this.projView, this.projView.getOptions());
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this.projView.getFrame(), (Object)dialog, "Projection Options", -1);
        final JOptionPane jop = jopf.getJOptionPane();
        JButton buttonOk = new JButton("OK");
        buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jop.setValue(0);
                jop.setVisible(false);
            }
        });
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                jop.setValue(2);
                jop.setVisible(false);
            }
        });
        JButton buttonDefault = new JButton("Default");
        buttonDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                dialog.setToDefault();
            }
        });
        Object[] options = new Object[]{buttonOk, buttonCancel, buttonDefault};
        jopf.setOptions(options);
        jopf.setInitialValue(buttonOk);
        Projection projOptions = new Projection(this.projView.getOptions());
        int selection = jopf.show();
        if (selection == 0) {
            Projection dialogOptions = dialog.getOptions();
            this.projView.recordAction("setOptions", new String[]{ScriptUtils.convertString(dialogOptions.getColorTable()), String.valueOf(dialogOptions.getMin()), String.valueOf(dialogOptions.getMax())}, true);
            projOptions = dialogOptions;
        }
        this.projView.getOptions().setOptions(projOptions);
        this.projView.updateColorTable(projOptions.getColorTable());
        this.projView.updateDisplay();
    }
}

