/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerprojection.dialogs.modal;

import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.viewerprojection.ProjectionViewer;
import edu.uthscsa.ric.mango.viewerprojection.core.Projection;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LookupTableManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ProjectionDialog
extends JPanel
implements ActionListener {
    private final JComboBox<String> colorTableBox;
    private final JTextField maxText;
    private final JTextField minText;
    private final Projection data;
    private final ProjectionViewer projView;
    private static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(0, false);
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_COLOR_TABLE = "Spectrum";

    public ProjectionDialog(ProjectionViewer projView, Projection data) {
        this.projView = projView;
        this.data = data;
        this.colorTableBox = new JComboBox<String>(CollectionUtilities.array(LookupTableManager.NAMES));
        this.colorTableBox.setPrototypeDisplayValue(LookupTableManager.NAMES.get(3));
        this.colorTableBox.setSelectedItem(data.getColorTable());
        this.colorTableBox.addActionListener(this);
        this.colorTableBox.setActionCommand("Color Table");
        JPanel colorLabelPanel = new JPanel();
        colorLabelPanel.setLayout(new BoxLayout(colorLabelPanel, 0));
        colorLabelPanel.add(Box.createHorizontalGlue());
        colorLabelPanel.add(new JLabel("Color Table"));
        colorLabelPanel.add(Box.createHorizontalGlue());
        JPanel colorPanel = new JPanel();
        colorPanel.setLayout(new BoxLayout(colorPanel, 1));
        colorPanel.add(colorLabelPanel);
        colorPanel.add(this.colorTableBox);
        this.minText = new JTextField(4);
        this.minText.setMinimumSize(this.minText.getPreferredSize());
        this.minText.setMaximumSize(this.minText.getPreferredSize());
        this.minText.setText(FORMATTER.format(data.getMin()));
        this.minText.addActionListener(this);
        JPanel minLabelPanel = new JPanel();
        minLabelPanel.setLayout(new BoxLayout(minLabelPanel, 0));
        minLabelPanel.add(Box.createHorizontalGlue());
        minLabelPanel.add(new JLabel("Min"));
        minLabelPanel.add(Box.createHorizontalGlue());
        JPanel minPanel = new JPanel();
        minPanel.setLayout(new BoxLayout(minPanel, 1));
        minPanel.add(minLabelPanel);
        minPanel.add(this.minText);
        this.maxText = new JTextField(4);
        this.maxText.setMinimumSize(this.maxText.getPreferredSize());
        this.maxText.setMaximumSize(this.maxText.getPreferredSize());
        this.maxText.setText(FORMATTER.format(data.getMax()));
        this.maxText.addActionListener(this);
        JPanel maxLabelPanel = new JPanel();
        maxLabelPanel.setLayout(new BoxLayout(maxLabelPanel, 0));
        maxLabelPanel.add(Box.createHorizontalGlue());
        maxLabelPanel.add(new JLabel("Max"));
        maxLabelPanel.add(Box.createHorizontalGlue());
        JPanel maxPanel = new JPanel();
        maxPanel.setLayout(new BoxLayout(maxPanel, 1));
        maxPanel.add(maxLabelPanel);
        maxPanel.add(this.maxText);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        controlPanel.add(Box.createHorizontalGlue());
        controlPanel.add(minPanel);
        controlPanel.add(colorPanel);
        controlPanel.add(maxPanel);
        controlPanel.add(Box.createHorizontalGlue());
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 0));
        JLabel infoLabel = new JLabel("<html><center>Right-click and drag mouse on projection<br>to also control brightness and contrast.</center></html>");
        infoPanel.add(Box.createHorizontalGlue());
        infoPanel.add(infoLabel);
        infoPanel.add(Box.createHorizontalGlue());
        this.setLayout(new BoxLayout(this, 1));
        this.add(controlPanel);
        this.add(Box.createVerticalStrut(8));
        this.add(infoPanel);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.updateView();
    }

    public Projection getOptions() {
        return new Projection(this.colorTableBox.getSelectedItem().toString(), this.getMin(), this.getMax(), this.data.isAnimating());
    }

    public void setToDefault() {
        this.colorTableBox.setSelectedItem(DEFAULT_COLOR_TABLE);
        this.minText.setText(FORMATTER.format(this.projView.getDefaultMin()));
        this.maxText.setText(FORMATTER.format(this.projView.getDefaultMax()));
        this.updateView();
    }

    private double getMax() {
        double max = this.data.getMax();
        try {
            max = Double.parseDouble(this.maxText.getText());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        return max;
    }

    private double getMin() {
        double min = this.data.getMin();
        try {
            min = Double.parseDouble(this.minText.getText());
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        return min;
    }

    private void updateView() {
        this.projView.getOptions().setOptions(this.getOptions());
        this.projView.updateColorTable(this.colorTableBox.getSelectedItem().toString());
        this.projView.updateDisplay();
    }
}

