/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerprojection.dialogs.modal;

import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.viewerprojection.operations.building.BuildProjectionParameters;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.volume.VoxelDimensions;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;

public class BuildProjectionDialog
extends JPanel
implements ActionListener {
    private final JRadioButton planeAxial;
    private final JRadioButton planeCoronal;
    private final JRadioButton planeSagittal;
    private final JRadioButton rotX;
    private final JRadioButton rotY;
    private final JRadioButton rotZ;
    private final JRadioButton typeMax = new JRadioButton("Maximum");
    private final JRadioButton typeMedian = new JRadioButton("Median");
    private final JRadioButton typeMin = new JRadioButton("Minimum");
    private final JSlider smoothnessSlider;
    private final JTextField resX;
    private final JTextField resY;
    private final JTextField resZ;
    private final double xLength;
    private final double yLength;
    private final double zLength;
    private static final long serialVersionUID = 1L;
    public static final MangoNumberFormatter FORMATTER = new MangoNumberFormatter(0, false);
    public static final List<String> LABELS = CollectionUtilities.immutable((String[])new String[]{"Low", "", "Default", "", "High"});
    public static final String ACTION_PLANE = "Plane";
    public static final String ACTION_ROT = "Rot";

    public BuildProjectionDialog(SliceViewer viewer) {
        ButtonGroup bgType = new ButtonGroup();
        bgType.add(this.typeMax);
        bgType.add(this.typeMedian);
        bgType.add(this.typeMin);
        this.typeMax.setSelected(true);
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new BoxLayout(typePanel, 0));
        typePanel.add(Box.createHorizontalGlue());
        typePanel.add(this.typeMax);
        typePanel.add(this.typeMedian);
        typePanel.add(this.typeMin);
        typePanel.add(Box.createHorizontalGlue());
        typePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Rank"));
        this.planeAxial = new JRadioButton("Axial");
        this.planeAxial.addActionListener(this);
        this.planeAxial.setActionCommand(ACTION_PLANE);
        this.planeCoronal = new JRadioButton("Coronal");
        this.planeCoronal.addActionListener(this);
        this.planeCoronal.setActionCommand(ACTION_PLANE);
        this.planeSagittal = new JRadioButton("Sagittal");
        this.planeSagittal.addActionListener(this);
        this.planeSagittal.setActionCommand(ACTION_PLANE);
        this.xLength = (double)viewer.getVolume().getXDim() * viewer.getVolume().getXSize();
        this.yLength = (double)viewer.getVolume().getYDim() * viewer.getVolume().getYSize();
        this.zLength = (double)viewer.getVolume().getZDim() * viewer.getVolume().getZSize();
        ButtonGroup bgPlane = new ButtonGroup();
        bgPlane.add(this.planeAxial);
        bgPlane.add(this.planeCoronal);
        bgPlane.add(this.planeSagittal);
        int sliceDir = viewer.getMainSliceDirection();
        if (sliceDir == 0) {
            this.planeAxial.setSelected(true);
        } else if (sliceDir == 1) {
            this.planeCoronal.setSelected(true);
        } else if (sliceDir == 2) {
            this.planeSagittal.setSelected(true);
        }
        JPanel planePanel = new JPanel();
        planePanel.setLayout(new BoxLayout(planePanel, 0));
        planePanel.add(Box.createHorizontalGlue());
        planePanel.add(this.planeAxial);
        planePanel.add(this.planeCoronal);
        planePanel.add(this.planeSagittal);
        planePanel.add(Box.createHorizontalGlue());
        planePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Projection"));
        VoxelDimensions vd = viewer.getVolume().getVoxelDimensions();
        this.resX = new MangoTextField(FORMATTER.format(vd.getXSize()), 4);
        this.resX.setMinimumSize(this.resX.getPreferredSize());
        this.resX.setMaximumSize(this.resX.getPreferredSize());
        JLabel xResLabel = new JLabel("X");
        this.resY = new MangoTextField(FORMATTER.format(vd.getYSize()), 4);
        this.resY.setMinimumSize(this.resY.getPreferredSize());
        this.resY.setMaximumSize(this.resY.getPreferredSize());
        JLabel yResLabel = new JLabel("Y");
        this.resZ = new MangoTextField(FORMATTER.format(vd.getZSize()), 4);
        this.resZ.setMinimumSize(this.resZ.getPreferredSize());
        this.resZ.setMaximumSize(this.resZ.getPreferredSize());
        JLabel zResLabel = new JLabel("Z");
        JPanel resPanel = new JPanel();
        resPanel.setLayout(new BoxLayout(resPanel, 0));
        resPanel.add(Box.createHorizontalGlue());
        resPanel.add(xResLabel);
        resPanel.add(Box.createHorizontalStrut(2));
        resPanel.add(this.resX);
        resPanel.add(Box.createHorizontalStrut(8));
        resPanel.add(yResLabel);
        resPanel.add(Box.createHorizontalStrut(2));
        resPanel.add(this.resY);
        resPanel.add(Box.createHorizontalStrut(8));
        resPanel.add(zResLabel);
        resPanel.add(Box.createHorizontalStrut(2));
        resPanel.add(this.resZ);
        resPanel.add(Box.createHorizontalGlue());
        resPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Resolution"));
        this.smoothnessSlider = new JSlider(0, 4, 2);
        Hashtable<Integer, JLabel> labelMap = new Hashtable<Integer, JLabel>();
        for (int ctr = 0; ctr < LABELS.size(); ++ctr) {
            ((Dictionary)labelMap).put(ctr, new JLabel(LABELS.get(ctr)));
        }
        this.smoothnessSlider.setLabelTable(labelMap);
        this.smoothnessSlider.setMajorTickSpacing(1);
        this.smoothnessSlider.setPaintLabels(true);
        this.smoothnessSlider.setPaintTicks(true);
        this.smoothnessSlider.setSnapToTicks(true);
        JPanel aniPanel = new JPanel();
        aniPanel.setLayout(new BoxLayout(aniPanel, 0));
        aniPanel.add(Box.createHorizontalGlue());
        aniPanel.add(this.smoothnessSlider);
        aniPanel.add(Box.createHorizontalGlue());
        aniPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Detail"));
        this.rotX = new JRadioButton("About X");
        this.rotX.addActionListener(this);
        this.rotX.setActionCommand(ACTION_ROT);
        this.rotY = new JRadioButton("About Y");
        this.rotY.addActionListener(this);
        this.rotY.setActionCommand(ACTION_ROT);
        this.rotZ = new JRadioButton("About Z");
        this.rotZ.addActionListener(this);
        this.rotZ.setActionCommand(ACTION_ROT);
        ButtonGroup rotBg = new ButtonGroup();
        rotBg.add(this.rotX);
        rotBg.add(this.rotY);
        rotBg.add(this.rotZ);
        this.rotZ.setSelected(true);
        this.updatePlane();
        JPanel rotPanel = new JPanel();
        rotPanel.setLayout(new BoxLayout(rotPanel, 0));
        rotPanel.add(Box.createHorizontalGlue());
        rotPanel.add(this.rotX);
        rotPanel.add(this.rotY);
        rotPanel.add(this.rotZ);
        rotPanel.add(Box.createHorizontalGlue());
        rotPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Rotation"));
        this.setLayout(new BoxLayout(this, 1));
        this.add(typePanel);
        this.add(Box.createVerticalStrut(8));
        this.add(planePanel);
        this.add(Box.createVerticalStrut(8));
        this.add(resPanel);
        this.add(Box.createVerticalStrut(8));
        this.add(rotPanel);
        this.add(Box.createVerticalStrut(8));
        this.add(aniPanel);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String actionCommand = ae.getActionCommand();
        if (actionCommand.equals(ACTION_PLANE)) {
            this.updateRotationAxis();
        } else if (actionCommand.equals(ACTION_ROT)) {
            this.updatePlane();
        }
    }

    public BuildProjectionParameters getParameters() {
        BuildProjectionParameters bpp = new BuildProjectionParameters();
        bpp.axisOfRotation = this.getAxisOfRotation();
        bpp.planeOfProjection = this.getPlaneOfProjection();
        bpp.smoothness = this.smoothnessSlider.getValue();
        bpp.resX = this.getResX();
        bpp.resY = this.getResY();
        bpp.resZ = this.getResZ();
        bpp.rankType = this.getRankType();
        return bpp;
    }

    public float getResX() {
        String text = this.resX.getText();
        float val = 0.0f;
        try {
            val = Float.parseFloat(text);
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        return val;
    }

    public float getResY() {
        String text = this.resY.getText();
        float val = 0.0f;
        try {
            val = Float.parseFloat(text);
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        return val;
    }

    public float getResZ() {
        String text = this.resZ.getText();
        float val = 0.0f;
        try {
            val = Float.parseFloat(text);
        }
        catch (Exception ex) {
            AppLogger.info((Throwable)ex);
        }
        return val;
    }

    private int getAxisOfRotation() {
        if (this.rotX.isSelected()) {
            return 0;
        }
        if (this.rotY.isSelected()) {
            return 1;
        }
        if (this.rotZ.isSelected()) {
            return 2;
        }
        return -1;
    }

    private int getPlaneOfProjection() {
        if (this.planeAxial.isSelected()) {
            return 0;
        }
        if (this.planeCoronal.isSelected()) {
            return 1;
        }
        if (this.planeSagittal.isSelected()) {
            return 2;
        }
        return -1;
    }

    private int getRankType() {
        if (this.typeMax.isSelected()) {
            return 0;
        }
        if (this.typeMedian.isSelected()) {
            return 1;
        }
        if (this.typeMin.isSelected()) {
            return 2;
        }
        return -1;
    }

    private void updatePlane() {
        if (this.rotX.isSelected()) {
            if (this.yLength > this.zLength) {
                this.planeAxial.setSelected(true);
            } else {
                this.planeCoronal.setSelected(true);
            }
        } else if (this.rotY.isSelected()) {
            if (this.zLength > this.xLength) {
                this.planeSagittal.setSelected(true);
            } else {
                this.planeAxial.setSelected(true);
            }
        } else if (this.xLength > this.yLength) {
            this.planeCoronal.setSelected(true);
        } else {
            this.planeSagittal.setSelected(true);
        }
    }

    private void updateRotationAxis() {
        if (this.planeAxial.isSelected()) {
            if (this.rotZ.isSelected()) {
                this.rotX.setSelected(true);
            }
        } else if (this.planeCoronal.isSelected()) {
            if (this.rotY.isSelected()) {
                this.rotX.setSelected(true);
            }
        } else if (this.planeSagittal.isSelected() && this.rotX.isSelected()) {
            this.rotY.setSelected(true);
        }
    }
}

