/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerprojection.dialogs.cine;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.dialogs.cine.AbstractCine;
import edu.uthscsa.ric.mango.dialogs.cine.VideoCaptureManager;
import edu.uthscsa.ric.mango.dialogs.script.Recordable;
import edu.uthscsa.ric.mango.viewerprojection.ProjectionViewer;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class CineProjection
extends AbstractCine {
    private final ProjectionViewer projection;
    private static final long serialVersionUID = 1L;

    public CineProjection(SliceViewer viewer, VideoCaptureManager videoCaptureManager) {
        this(viewer, videoCaptureManager, false);
    }

    public CineProjection(SliceViewer viewer, VideoCaptureManager videoCaptureManager, boolean silent) {
        super(viewer, videoCaptureManager, silent);
        this.projection = viewer.getProjection().getProjectionView();
    }

    @Override
    public void animate() {
        this.viewer.setNavigationDisabled(true);
        this.viewer.setStopPaintingState(true);
        this.projection.resetFrameIndex();
        this.storeRecordingParameters();
        this.recordButton.setEnabled(false);
        this.recordButton.setText("Animating");
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                CineProjection.this.doAnimate();
            }
        });
        workThread.start();
    }

    private void doAnimate() {
        final Vector<BufferedImage> frames = new Vector<BufferedImage>();
        int numFrames = this.projection.getNumFrames() * 2;
        final ProgressMeter progressBar = this.viewer.makeProgressMeter();
        progressBar.setDescription("Recording Animation");
        progressBar.start(0, 0, numFrames);
        for (int ctr = 0; ctr < numFrames; ++ctr) {
            final int index = ctr;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        frames.add(CineProjection.this.projection.captureImage(true));
                        progressBar.setValue(index);
                        CineProjection.this.projection.incrementFrameIndex();
                    }
                });
                continue;
            }
            catch (InterruptedException ex) {
                AppLogger.error((Throwable)ex);
                continue;
            }
            catch (InvocationTargetException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
        if (this.isSilent()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        progressBar.setValue(progressBar.getMax());
                        CineProjection.this.projection.resetFrameIndex();
                        CineProjection.this.viewer.setStopPaintingState(false);
                        CineProjection.this.viewer.setNavigationDisabled(false);
                        CineProjection.this.viewer.updateViewer();
                    }
                });
            }
            catch (InterruptedException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                AppLogger.error((Throwable)ex);
            }
            this.stopSilently(frames);
        } else {
            SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                @Override
                public void run() {
                    progressBar.setValue(progressBar.getMax());
                    CineProjection.this.projection.resetFrameIndex();
                    CineProjection.this.viewer.setStopPaintingState(false);
                    CineProjection.this.viewer.setNavigationDisabled(false);
                    CineProjection.this.viewer.updateViewer();
                    if (CineProjection.this.isSilent()) {
                        CineProjection.this.stopSilently(frames);
                    } else {
                        CineProjection.this.stop(frames);
                    }
                }
            });
        }
    }

    @Override
    public double getFrameRateAdjuster(boolean isAnimate) {
        return 1.0;
    }

    @Override
    public void updateLabels() {
        this.autoSlicesLabel.setText("projection view");
        this.recorderLabel.setText("Record projection view ");
        this.infoLabel.setText("<html><center>Creates a video of the projection view either as an automated<br>animation or a freeform recording.</center></html>");
    }

    @Override
    public void animateSilently() {
        this.viewer.setNavigationDisabled(true);
        this.viewer.setStopPaintingState(true);
        this.doAnimate();
    }

    @Override
    public Recordable getRecordable() {
        return this.projection;
    }
}

