/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.viewerprojection;

import edu.uthscsa.ric.mango.core.Capturable;
import edu.uthscsa.ric.mango.core.StickyWindow;
import edu.uthscsa.ric.mango.dialogs.cine.VideoCaptureListener;
import edu.uthscsa.ric.mango.dialogs.cine.VideoCaptureManager;
import edu.uthscsa.ric.mango.dialogs.script.Recordable;
import edu.uthscsa.ric.mango.dialogs.script.ScriptUtils;
import edu.uthscsa.ric.mango.dialogs.snapshot.Snapshot;
import edu.uthscsa.ric.mango.viewerprojection.ProjectionData;
import edu.uthscsa.ric.mango.viewerprojection.ProjectionManager;
import edu.uthscsa.ric.mango.viewerprojection.core.Projection;
import edu.uthscsa.ric.mango.viewerprojection.dialogs.cine.CineProjection;
import edu.uthscsa.ric.mango.viewerprojection.window.ProjectionFrame;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LookupTableManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;

public class ProjectionViewer
extends JComponent
implements Capturable,
MouseListener,
MouseMotionListener,
ProjectionManager,
Recordable,
StickyWindow,
VideoCaptureManager {
    private CineProjection cine;
    private BufferedImage currentVideoFrame;
    private BufferedImage screenSliceFilteredScaled;
    private boolean capturingVideo;
    private VideoCaptureListener videoCaptureListener;
    private Timer videoCaptureTimer;
    private int videoCaptureFps;
    private Vector<BufferedImage> videoFrames;
    private LookupTableManager lookupTable;
    private ProjectionData data;
    private Timer timer;
    private boolean flipping;
    private boolean sticky;
    private boolean windowMode;
    private double defaultMax;
    private double defaultMin;
    private double longestDimSize;
    private int longestDim;
    private int mouseX;
    private int previousMouseX;
    private int previousMouseY;
    private int previousProjectionIndex;
    private int projectionIndex;
    private int startAnimationIndex;
    private int startProjectionIndex;
    private long startTime;
    private final AffineTransform finalTransform;
    private final AffineTransform flipTransform;
    private final AffineTransform screenTransform;
    private final BufferedImage sliceImage;
    private final BufferedImage sliceImageFiltered;
    private final ProjectionFrame frame;
    private final SliceViewer viewer;
    private final Projection options;
    private final double xSize;
    private final double ySize;
    private final int xDim;
    private final int yDim;
    private final int[] rgbData;
    private static final long serialVersionUID = 1L;
    public static final int SPEED = 10;
    public static final long ANIMATION_DURATION = 5000L;
    public static final List<String> OPTION_QUALITY = CollectionUtilities.immutable((String[])new String[]{"Fastest", "Fast", "Default", "High", "Best"});

    public ProjectionViewer(SliceViewer viewer, int xDim, int yDim, double xSize, double ySize, boolean isYaxis, ProjectionFrame frame) {
        this.xDim = xDim;
        this.yDim = yDim;
        this.xSize = xSize;
        this.ySize = ySize;
        this.viewer = viewer;
        this.frame = frame;
        this.setLongestDim();
        this.sliceImage = new BufferedImage(xDim, yDim, 2);
        this.sliceImageFiltered = new BufferedImage(xDim, yDim, 2);
        DataBufferInt dbi = (DataBufferInt)this.sliceImage.getRaster().getDataBuffer();
        this.rgbData = dbi.getData();
        this.screenTransform = new AffineTransform();
        this.flipTransform = new AffineTransform(isYaxis ? -1.0f : 1.0f, 0.0f, 0.0f, isYaxis ? 1.0f : -1.0f, isYaxis ? (float)xDim : 0.0f, isYaxis ? 0.0f : (float)yDim);
        this.finalTransform = new AffineTransform();
        this.options = new Projection("Spectrum", viewer.getScreenVolume().getDynamicScreenMin(), viewer.getScreenVolume().getDynamicScreenMax(), true);
        this.updateColorTable(this.options.getColorTable());
        this.updateScreenTransform(viewer.getSize().width);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public BufferedImage captureImage() {
        return this.captureImage(false);
    }

    public BufferedImage captureImage(boolean video) {
        BufferedImage bi = null;
        bi = video ? new BufferedImage(this.getSize().width, this.getSize().height, 1) : new BufferedImage(this.getSize().width, this.getSize().height, 2);
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        super.paintComponent(g2d);
        g2d.setColor(Color.BLACK);
        if (this.data != null) {
            this.lookupTable.getOp().filter(this.sliceImage, this.sliceImageFiltered);
            g2d.drawImage(this.sliceImageFiltered, this.finalTransform, null);
        }
        return bi;
    }

    public boolean clear() {
        this.stopAnimating();
        if (this.data != null) {
            this.data.getData().clear();
            this.data = null;
        }
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
        }
        return true;
    }

    @Override
    public File getCaptureDir() {
        return this.viewer.getLoadedFile().getParentFile();
    }

    @Override
    public String getCaptureName() {
        String name = this.viewer.getLoadedFile().getName();
        if (name.indexOf(46) != -1) {
            name = name.substring(0, name.indexOf(46));
        }
        return name;
    }

    public ProjectionData getData() {
        return this.data;
    }

    public double getDefaultMax() {
        return this.defaultMax;
    }

    public double getDefaultMin() {
        return this.defaultMin;
    }

    @Override
    public JFrame getFrame() {
        return this.frame;
    }

    public Projection getOptions() {
        return this.options;
    }

    public SliceViewer getViewer() {
        return this.viewer;
    }

    public Dimension getViewerSize() {
        return new Dimension(this.getSize().width, this.getSize().height);
    }

    @Override
    public boolean isSticky() {
        return this.sticky;
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        int currentCursorX = me.getPoint().x;
        int currentCursorY = me.getPoint().y;
        if (this.windowMode) {
            int changeX = 0;
            int changeY = 0;
            if (Math.abs(this.previousMouseX - currentCursorX) > Math.abs(this.previousMouseY - currentCursorY)) {
                changeX = this.previousMouseX - currentCursorX;
            } else {
                changeY = this.previousMouseY - currentCursorY;
            }
            this.windowLevelChanged(changeX, changeY);
            this.previousMouseX = currentCursorX;
            this.previousMouseY = currentCursorY;
        } else {
            int mouseDiff = me.getPoint().x - this.mouseX;
            double percent = (float)mouseDiff / (float)this.getSize().width;
            int frames = this.data.getData().size();
            int frameDiff = (int)Math.round((double)(frames - 1) * percent);
            this.projectionIndex = this.startProjectionIndex + frameDiff;
            this.flipping = Math.abs(this.projectionIndex / frames % 2) == 1;
        }
        this.updateData();
        this.repaint();
    }

    public int getProjectionIndex() {
        return this.projectionIndex;
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.recordAction("pauseScriptForUserInput");
        this.windowMode = me.isMetaDown();
        this.previousMouseX = me.getPoint().x;
        this.previousMouseY = me.getPoint().y;
        this.stopAnimating();
        this.options.setAnimating(false);
        this.mouseX = me.getPoint().x;
        this.startProjectionIndex = this.projectionIndex;
    }

    public void pauseScriptForUserInput() {
        this.viewer.pauseScriptForUserInput();
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    private void updateScaledImage() {
        if (this.screenSliceFilteredScaled == null) {
            int w = (int)((double)this.longestDim * this.finalTransform.getScaleX());
            int h = (int)((double)this.longestDim * this.finalTransform.getScaleY());
            this.screenSliceFilteredScaled = new BufferedImage(w, h, 2);
        }
        AffineTransformOp scaleOp = new AffineTransformOp(this.finalTransform, 2);
        scaleOp.filter(this.sliceImageFiltered, this.screenSliceFilteredScaled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        super.paintComponent(g);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2d.setColor(Color.BLACK);
        g2d.fill(g2d.getClip());
        if (this.data != null) {
            this.lookupTable.getOp().filter(this.sliceImage, this.sliceImageFiltered);
            this.updateScaledImage();
            g2d.drawImage(this.screenSliceFilteredScaled, null, null);
        }
        if (this.isCapturingVideo()) {
            ProjectionViewer projectionViewer = this;
            synchronized (projectionViewer) {
                this.currentVideoFrame = this.captureImage(true);
            }
        }
    }

    public void setData(ProjectionData data) {
        this.data = data;
        this.startAnimating();
    }

    public void setDefaultMax(double defaultMax) {
        this.defaultMax = defaultMax;
    }

    public void setDefaultMin(double defaultMin) {
        this.defaultMin = defaultMin;
    }

    public void setSticky(boolean bool) {
        this.sticky = bool;
    }

    public final void updateColorTable(String colorTableName) {
        this.lookupTable = LookupTableManager.createLookupTableManager(LookupTableManager.findIndex(colorTableName), true);
        this.lookupTable.initLUT();
    }

    public void updateDisplay() {
        this.updateData();
        this.repaint();
    }

    public void resetFrameIndex() {
        this.projectionIndex = 0;
        this.flipping = false;
        this.updateData();
        this.repaint();
    }

    public int getNumFrames() {
        return this.data.getData().size();
    }

    public void incrementFrameIndex() {
        ++this.projectionIndex;
        this.flipping = Math.abs(this.projectionIndex / this.getNumFrames() % 2) == 1;
        this.updateData();
        this.repaint();
    }

    public void setProjectionIndex(int index) {
        this.projectionIndex = index;
        this.flipping = Math.abs(this.projectionIndex / this.getNumFrames() % 2) == 1;
        this.updateData();
        this.repaint();
    }

    public void startAnimating() {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Animate"), ScriptUtils.convertBoolean(true)});
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                long currentTime = System.currentTimeMillis();
                int numFrames = ProjectionViewer.this.data.getData().size();
                long frameLength = Math.round(5000.0 / (double)numFrames);
                int frameIndex = (int)Math.round((double)(currentTime - ProjectionViewer.this.startTime) / (double)frameLength);
                ProjectionViewer.this.projectionIndex = ProjectionViewer.this.startAnimationIndex + frameIndex;
                ProjectionViewer.this.flipping = Math.abs(ProjectionViewer.this.projectionIndex / numFrames % 2) == 1;
                if (ProjectionViewer.this.projectionIndex != ProjectionViewer.this.previousProjectionIndex) {
                    ProjectionViewer.this.updateData();
                    ProjectionViewer.this.repaint();
                    ProjectionViewer.this.previousProjectionIndex = ProjectionViewer.this.projectionIndex;
                }
            }
        };
        this.startAnimationIndex = this.projectionIndex;
        this.previousProjectionIndex = -1;
        this.startTime = System.currentTimeMillis();
        this.timer.scheduleAtFixedRate(timerTask, 0L, 10L);
    }

    public void stopAnimating() {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Animate"), ScriptUtils.convertBoolean(false)});
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void stopAnimatingQuietly() {
        this.options.setAnimating(false);
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public final void updateScreenTransform(double width) {
        double scaleY;
        double scaleX;
        double totalX = (double)this.xDim * this.xSize;
        double totalY = (double)this.yDim * this.ySize;
        if (totalX > totalY) {
            scaleX = width / (double)this.longestDim * (this.xSize / this.longestDimSize);
            scaleY = width / (double)this.longestDim * this.getYXratio() * (this.xSize / this.longestDimSize);
        } else {
            scaleX = width / (double)this.longestDim * this.getXYratio() * (this.ySize / this.longestDimSize);
            scaleY = width / (double)this.longestDim * (this.ySize / this.longestDimSize);
        }
        double transX = (width - (double)this.xDim * scaleX) / 2.0;
        double transY = (width - (double)this.yDim * scaleY) / 2.0;
        this.screenTransform.setTransform(scaleX, 0.0, 0.0, scaleY, transX, transY);
        this.screenSliceFilteredScaled = null;
    }

    private double getXYratio() {
        return this.xSize / this.ySize;
    }

    private double getYXratio() {
        return this.ySize / this.xSize;
    }

    private void setLongestDim() {
        this.longestDim = this.xDim;
        this.longestDimSize = this.xSize;
        if ((double)this.yDim * this.ySize > (double)this.longestDim * this.longestDimSize) {
            this.longestDim = this.yDim;
            this.longestDimSize = this.ySize;
        }
    }

    private void updateData() {
        double screenRatio = 255.0 / (this.options.getMax() - this.options.getMin());
        int index = Math.abs(this.projectionIndex % this.data.getData().size());
        float[] dat = this.data.getData().get(index);
        for (int ctr = 0; ctr < this.rgbData.length; ++ctr) {
            double val = dat[ctr];
            if (val <= this.options.getMin()) {
                this.rgbData[ctr] = 0;
                continue;
            }
            if (val > this.options.getMax()) {
                this.rgbData[ctr] = -1;
                continue;
            }
            int num = (int)((val - this.options.getMin()) * screenRatio + 0.5);
            this.rgbData[ctr] = num | num << 8 | num << 16 | 0xFF000000;
        }
        this.frame.updateProjectionManager();
        this.updateFinalTransform();
    }

    private void updateFinalTransform() {
        this.finalTransform.setTransform(this.screenTransform);
        if (this.flipping) {
            this.finalTransform.concatenate(this.flipTransform);
        }
    }

    private void windowLevelChanged(int contrastChange, int brightnessChange) {
        double maxFinal;
        double minFinal;
        ScreenVolume baseVol = this.viewer.getScreenVolume();
        double range = baseVol.getImageMax() - baseVol.getImageMin();
        double step = range * 0.01;
        if (Math.abs(contrastChange) > Math.abs(brightnessChange)) {
            minFinal = this.options.getMin() + step * (double)Math.signum(contrastChange);
            maxFinal = this.options.getMax() + -1.0 * step * (double)Math.signum(contrastChange);
            if (maxFinal <= minFinal) {
                minFinal = this.options.getMin();
                maxFinal = this.options.getMin();
            }
        } else {
            minFinal = this.options.getMin() + step * (double)Math.signum(brightnessChange);
            maxFinal = this.options.getMax() + step * (double)Math.signum(brightnessChange);
        }
        this.options.setMin(minFinal);
        this.options.setMax(maxFinal);
        this.updateData();
        this.repaint();
    }

    @Override
    public synchronized void startVideoCapture(int fps, VideoCaptureListener videoCaptureListener) {
        this.videoCaptureListener = videoCaptureListener;
        this.videoCaptureFps = fps;
        this.videoFrames = new Vector();
        this.setCapturingVideo(true);
        this.repaint();
        this.startVideoCaptureTimer();
    }

    private synchronized void startVideoCaptureTimer() {
        this.stopVideoCaptureTimer();
        this.videoCaptureTimer = new Timer();
        TimerTask videoCaptureTask = new TimerTask(){

            @Override
            public void run() {
                ProjectionViewer.this.captureVideo();
            }
        };
        this.videoCaptureTimer.scheduleAtFixedRate(videoCaptureTask, 0L, (long)(1000 / this.videoCaptureFps));
    }

    public void setCapturingVideo(boolean capturingVideo) {
        this.capturingVideo = capturingVideo;
    }

    public boolean isCapturingVideo() {
        return this.capturingVideo;
    }

    private synchronized void stopVideoCaptureTimer() {
        if (this.videoCaptureTimer != null) {
            this.videoCaptureTimer.cancel();
            this.videoCaptureTimer = null;
        }
    }

    @Override
    public Vector<BufferedImage> endVideoCapture() {
        this.stopVideoCaptureTimer();
        this.setCapturingVideo(false);
        return this.videoFrames;
    }

    private synchronized void captureVideo() {
        if (this.currentVideoFrame != null) {
            this.videoFrames.add(this.currentVideoFrame);
            if (this.videoFrames.size() >= 1200) {
                this.videoCaptureListener.videoCaptureEnded();
            }
        }
    }

    @Override
    public Dimension getVideoFrameDimensions() {
        return this.getSize();
    }

    @Override
    public String getCaptureType() {
        return "projection";
    }

    @Override
    public void recordAction(String name) {
        this.recordAction(name, null);
    }

    @Override
    public void recordAction(String name, String[] argValues) {
        this.recordAction(name, argValues, false, this);
    }

    @Override
    public void recordAction(String name, String[] argValues, boolean forceNeedsUserInput) {
        this.recordAction(name, argValues, forceNeedsUserInput, this);
    }

    @Override
    public void recordAction(String name, String[] argValues, boolean forceNeedsUserInput, Recordable recordable) {
        this.viewer.recordAction(name, argValues, forceNeedsUserInput, recordable);
    }

    @Override
    public Method findRecordableMethod(String name, int numArgs) {
        try {
            Method[] methods;
            for (Method method : methods = ProjectionManager.class.getMethods()) {
                if (!method.getName().equals(name) || numArgs != method.getParameterTypes().length) continue;
                return method;
            }
        }
        catch (SecurityException ex) {
            AppLogger.error((Throwable)ex);
        }
        return null;
    }

    @Override
    public String getScriptObjectName() {
        return this.viewer.getScriptObjectName() + ".projectionManager";
    }

    public void selectMenuOption(final String name) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (name.equals("Maximize")) {
                    ProjectionViewer.this.selectWindowMenuOptionMaximize();
                } else if (name.equals("Dock")) {
                    ProjectionViewer.this.selectWindowMenuOptionMinimize();
                } else if (name.equals("Zoom In")) {
                    ProjectionViewer.this.selectWindowMenuOptionZoomIn();
                } else if (name.equals("Zoom Out")) {
                    ProjectionViewer.this.selectWindowMenuOptionZoomOut();
                } else {
                    JMenuItem mi = ProjectionViewer.this.frame.getMenuItem(name);
                    if (mi != null) {
                        mi.doClick();
                    } else {
                        ProjectionViewer.this.viewer.doClickMenuItem(name);
                    }
                }
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void selectWindowMenuOptionMaximize() {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Maximize")});
        this.frame.maximize();
        this.updateDisplay();
    }

    public void selectWindowMenuOptionMinimize() {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Dock")});
        this.frame.setState(1);
    }

    public void selectWindowMenuOptionZoomIn() {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Zoom In")});
        this.frame.incrementSize();
    }

    public void selectWindowMenuOptionZoomOut() {
        this.recordAction("selectMenuOption", new String[]{ScriptUtils.convertString("Zoom Out")});
        this.frame.decrementSize();
    }

    public void setWindowMenuOptionStick(boolean sticky) {
        this.recordAction("setMenuOption", new String[]{ScriptUtils.convertString("Stick to Slice Viewer"), ScriptUtils.convertBoolean(sticky)});
        this.setSticky(!this.isSticky());
        if (this.isSticky()) {
            this.viewer.doSticky();
        }
    }

    public void setMenuOption(final String name, final boolean value) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (name.equals("Stick to Slice Viewer")) {
                    ProjectionViewer.this.setWindowMenuOptionStick(value);
                } else if (name.equals("Animate")) {
                    if (value) {
                        ProjectionViewer.this.startAnimating();
                    } else {
                        ProjectionViewer.this.stopAnimating();
                    }
                } else {
                    JMenuItem mi = ProjectionViewer.this.frame.getMenuItem(name);
                    if (mi != null) {
                        mi.doClick();
                    } else {
                        ProjectionViewer.this.viewer.doClickMenuItem(name);
                    }
                }
            }
        };
        SwingWidgetUtilities.invokeAndWaitSafely((Runnable)runnable);
    }

    public void captureSnapshot(String saveLocation) {
        Snapshot.takeSnapshot(saveLocation, this);
    }

    public void captureVideoStart(String saveLocation, int videoFormat, int videoQuality, int fps, boolean animate) {
        this.cine = new CineProjection(this.viewer, this, true);
        this.cine.startSilentFreeRecording(fps, videoQuality, videoFormat, new File(saveLocation), animate);
    }

    public void captureVideoStop() {
        if (this.cine != null) {
            this.cine.stopSilentRecording();
            this.cine = null;
        }
    }

    public void setOptions(String colorTable, double thresholdMin, double thresholdMax) {
        Projection proj = new Projection(colorTable, thresholdMin, thresholdMax, this.getOptions().isAnimating());
        this.getOptions().setOptions(proj);
        this.updateColorTable(proj.getColorTable());
        this.updateDisplay();
    }
}

