/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.plugin.atlases.atlasfsl;

import Jama.Matrix;
import edu.uthscsa.ric.mango.Atlas;
import edu.uthscsa.ric.mango.plugin.atlases.atlasfsl.AtlasFormatException;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.URLUtilities;
import edu.uthscsa.ric.volume.Header;
import edu.uthscsa.ric.volume.InvalidHeaderException;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.VolumeIOException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AtlasFSL
implements Atlas {
    private Matrix tempCoord;
    private Matrix transform;
    private String name;
    private String[] currentLabel;
    private URI xmlPath;
    private URI imagePath;
    private Vector<String[]> labels;
    private Volume volume;
    private boolean isProbabalistic;
    private boolean[] displayStrings;
    private int maxLabels;
    public static final String MIN_MANGO_VERSION = "2.5";
    public static final String PLUGIN_RESOURCE_URL = "http://rii.uthscsa.edu/mango/imango_guide_atlas.html";
    public static final String VERSION = "1.0";
    public static final List<String> PROBABILISTIC = CollectionUtilities.immutable((String[])new String[]{"probabalistic", "probabilistic"});
    public static final List<String> TALAIRACH_NAME_OVERWRITE = CollectionUtilities.immutable((String[])new String[]{"Talairach Daemon Labels", "MNI (Talairach Daemon Labels)"});

    public static Vector<Atlas> loadAtlasDirectory(File atlasDir) throws AtlasFormatException {
        File[] files;
        Vector<Atlas> atlases = new Vector<Atlas>();
        if (atlasDir.exists() && atlasDir.isDirectory() && (files = atlasDir.listFiles()) != null) {
            for (File file : files) {
                String name = file.getName();
                if (!name.endsWith(".xml")) continue;
                atlases.add(new AtlasFSL(file.toURI()));
            }
        }
        return atlases;
    }

    public AtlasFSL(File atlasDir) throws AtlasFormatException {
        if (!atlasDir.isDirectory()) {
            throw new AtlasFormatException("AtlasFSL: Atlas path should be a folder, not a file!");
        }
        File[] allFiles = atlasDir.listFiles();
        if (allFiles != null) {
            for (File allFile : allFiles) {
                String ext;
                String fileStr = allFile.toString();
                int dotIndex = fileStr.lastIndexOf(46);
                if (dotIndex == -1 || !(ext = fileStr.substring(dotIndex).toLowerCase()).equals(".xml")) continue;
                if (this.xmlPath != null) {
                    throw new AtlasFormatException("AtlasFSL: Atlas folder can contain only one XML file!");
                }
                this.xmlPath = allFile.toURI();
            }
        }
        this.parseHeader();
    }

    public AtlasFSL(URI xmlPath) throws AtlasFormatException {
        this.xmlPath = xmlPath;
        this.parseHeader();
    }

    public void clear() {
        this.volume.clear(true);
        this.volume = null;
        this.labels.clear();
        this.labels = null;
    }

    public String[] getLabel(double xPosVal, double yPosVal, double zPosVal) {
        int ctr;
        double xPos = xPosVal;
        double yPos = yPosVal;
        double zPos = zPosVal;
        if (this.transform != null) {
            this.tempCoord.set(0, 0, xPos);
            this.tempCoord.set(0, 1, yPos);
            this.tempCoord.set(0, 2, zPos);
            this.tempCoord = this.tempCoord.times(this.transform);
            xPos = this.tempCoord.get(0, 0);
            yPos = this.tempCoord.get(0, 1);
            zPos = this.tempCoord.get(0, 2);
        }
        int index = (int)this.volume.getVoxelValueAtCoordinateNN(xPos, yPos, zPos);
        if (this.isProbabalistic) {
            --index;
        }
        String[] labelsAtIndex = null;
        int displayIndex = 0;
        if (index >= 0 && index < this.labels.size()) {
            labelsAtIndex = this.labels.get(index);
            for (ctr = 0; ctr < labelsAtIndex.length; ++ctr) {
                if (ctr >= this.displayStrings.length || !this.displayStrings[ctr] || displayIndex >= this.currentLabel.length) continue;
                if (labelsAtIndex[ctr].equals("*")) {
                    labelsAtIndex[ctr] = "";
                }
                this.currentLabel[displayIndex++] = labelsAtIndex[ctr];
            }
        }
        for (ctr = displayIndex; ctr < this.currentLabel.length; ++ctr) {
            this.currentLabel[ctr] = "";
        }
        return this.currentLabel;
    }

    public int getMaxReturnedLabels() {
        return this.currentLabel.length;
    }

    public String getMinimumVersionSupported() {
        return MIN_MANGO_VERSION;
    }

    public String getPluginName() {
        return this.name;
    }

    public URL getPluginURL() {
        try {
            return new URL(PLUGIN_RESOURCE_URL);
        }
        catch (MalformedURLException ex) {
            AppLogger.warn((Throwable)ex);
            return null;
        }
    }

    public String getVersion() {
        return VERSION;
    }

    public boolean hasNewerVersion() {
        return false;
    }

    public void loadAtlas(File tempDir) {
        try {
            this.volume = new Volume(this.imagePath);
            this.labels = new Vector();
            this.parseData();
            if (this.displayStrings == null) {
                this.displayStrings = new boolean[this.maxLabels];
                for (int ctr = 0; ctr < this.maxLabels; ++ctr) {
                    this.displayStrings[ctr] = ctr >= 0 && ctr <= 2 || ctr == this.maxLabels - 1;
                }
            }
            int numDisplay = 0;
            for (boolean displayString : this.displayStrings) {
                if (!displayString) continue;
                ++numDisplay;
            }
            this.currentLabel = new String[numDisplay];
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (VolumeIOException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (AtlasFormatException ex) {
            AppLogger.error((Throwable)ex);
        }
    }

    private void parseData() throws AtlasFormatException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(this.xmlPath.toString());
            doc.getDocumentElement().normalize();
            NodeList headerList = doc.getElementsByTagName("data");
            for (int ctr = 0; ctr < headerList.getLength(); ++ctr) {
                Node node = headerList.item(ctr);
                if (node.getNodeType() != 1) continue;
                Element fstElmnt = (Element)node;
                NodeList labelList = fstElmnt.getElementsByTagName("label");
                for (int ctrL = 0; ctrL < labelList.getLength(); ++ctrL) {
                    Element labelElem = (Element)labelList.item(ctrL);
                    NodeList labelNodeList = labelElem.getChildNodes();
                    String labelStr = labelNodeList.item(0).getNodeValue();
                    this.labels.add(this.parseLabel(labelStr));
                }
            }
        }
        catch (DOMException ex) {
            AppLogger.error((Throwable)ex);
            throw new AtlasFormatException(ex);
        }
        catch (ParserConfigurationException ex) {
            AppLogger.error((Throwable)ex);
            throw new AtlasFormatException(ex);
        }
        catch (SAXException ex) {
            AppLogger.error((Throwable)ex);
            throw new AtlasFormatException(ex);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            throw new AtlasFormatException(ex);
        }
    }

    private void parseDisplayStrings(String str) {
        StringTokenizer st = new StringTokenizer(str, ".");
        int numTokens = st.countTokens();
        if (numTokens > 0) {
            this.displayStrings = new boolean[numTokens];
            int index = 0;
            while (st.hasMoreTokens()) {
                this.displayStrings[index++] = "*".equals(st.nextToken().trim());
            }
        }
    }

    private void parseHeader() throws AtlasFormatException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(this.xmlPath.toString());
            doc.getDocumentElement().normalize();
            NodeList headerList = doc.getElementsByTagName("header");
            for (int ctr = 0; ctr < headerList.getLength(); ++ctr) {
                Node node = headerList.item(ctr);
                if (node.getNodeType() == 1) {
                    NodeList xtransList;
                    NodeList typeList;
                    Element typeElem;
                    NodeList typeNodeList;
                    String type;
                    NodeList nameNodeList;
                    Element nameElem;
                    Element fstElmnt = (Element)node;
                    NodeList nameList = fstElmnt.getElementsByTagName("shortname");
                    if (nameList.getLength() > 0) {
                        nameElem = (Element)nameList.item(0);
                        nameNodeList = nameElem.getChildNodes();
                        this.name = nameNodeList.item(0).getNodeValue();
                    }
                    if (this.name == null && (nameList = fstElmnt.getElementsByTagName("name")).getLength() > 0) {
                        nameElem = (Element)nameList.item(0);
                        nameNodeList = nameElem.getChildNodes();
                        this.name = nameNodeList.item(0).getNodeValue();
                    }
                    if (this.name == null) {
                        String xmlName = FileUtilities.getName((URI)this.xmlPath);
                        if (xmlName.indexOf(46) != -1) {
                            xmlName = xmlName.substring(0, xmlName.indexOf(46));
                        }
                        this.name = FileUtilities.getName((URI)this.xmlPath);
                    }
                    this.isProbabalistic = (type = (typeNodeList = (typeElem = (Element)(typeList = fstElmnt.getElementsByTagName("type")).item(0)).getChildNodes()).item(0).getNodeValue().trim().toLowerCase()).equals(PROBABILISTIC.get(0)) || type.equals(PROBABILISTIC.get(1));
                    NodeList imagesList = fstElmnt.getElementsByTagName("images");
                    Header highestResHeader = null;
                    URI highestResPath = null;
                    for (int ctrI = 0; ctrI < imagesList.getLength(); ++ctrI) {
                        Node imagesNode = imagesList.item(ctrI);
                        if (imagesNode.getNodeType() != 1) continue;
                        NodeList summaryList = ((Element)imagesNode).getElementsByTagName("summaryimagefile");
                        Element summaryElem = (Element)summaryList.item(0);
                        NodeList summaryNodeList = summaryElem.getChildNodes();
                        String relativeImagePath = summaryNodeList.item(0).getNodeValue().trim();
                        URI currentPath = null;
                        String imagePathStr = FileUtilities.getParent((URI)this.xmlPath) + "/" + relativeImagePath + ".nii.gz";
                        if (FileUtilities.uriIsFile((URI)this.xmlPath)) {
                            currentPath = new File(imagePathStr).toURI();
                        } else {
                            StringBuffer buf = URLUtilities.encodePath(null, (String)imagePathStr);
                            if (buf != null) {
                                imagePathStr = buf.toString();
                            }
                            currentPath = new URI(imagePathStr);
                        }
                        if (!FileUtilities.exists((URI)currentPath)) continue;
                        Header currentHeader = new Header(currentPath);
                        if (highestResHeader != null) {
                            int highestNumVoxels = highestResHeader.getImageDimensions().getNumVoxelsVolume();
                            int currentNumVoxels = currentHeader.getImageDimensions().getNumVoxelsVolume();
                            if (currentNumVoxels <= highestNumVoxels) continue;
                            highestResHeader = currentHeader;
                            highestResPath = currentPath;
                            continue;
                        }
                        highestResHeader = currentHeader;
                        highestResPath = currentPath;
                    }
                    if (highestResPath == null) {
                        throw new AtlasFormatException("AtlasFSL.parseXMLHeader(): Cannot find summary image file!");
                    }
                    this.imagePath = highestResPath;
                    NodeList displayList = fstElmnt.getElementsByTagName("display");
                    if (displayList.getLength() > 0) {
                        Element displayElem = (Element)displayList.item(0);
                        NodeList displayNodeList = displayElem.getChildNodes();
                        String displayStr = displayNodeList.item(0).getNodeValue();
                        this.parseDisplayStrings(displayStr);
                    }
                    if ((xtransList = fstElmnt.getElementsByTagName("transform")).getLength() > 0) {
                        Element xtransElem = (Element)xtransList.item(0);
                        NodeList xtransNodeList = xtransElem.getChildNodes();
                        String transformStr = xtransNodeList.item(0).getNodeValue();
                        this.parseTransform(transformStr);
                    }
                }
                if (this.name == null || !this.name.equals(TALAIRACH_NAME_OVERWRITE.get(0))) continue;
                this.name = TALAIRACH_NAME_OVERWRITE.get(1);
            }
        }
        catch (ParserConfigurationException ex) {
            AppLogger.error((Throwable)ex);
            throw new AtlasFormatException(ex);
        }
        catch (SAXException ex) {
            AppLogger.error((Throwable)ex);
            throw new AtlasFormatException(ex);
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
            throw new AtlasFormatException(ex);
        }
        catch (URISyntaxException ex) {
            AppLogger.error((Throwable)ex);
            throw new AtlasFormatException(ex);
        }
        catch (InvalidHeaderException ex) {
            AppLogger.error((Throwable)ex);
            throw new AtlasFormatException((Exception)((Object)ex));
        }
    }

    private String[] parseLabel(String str) {
        StringTokenizer st = new StringTokenizer(str, ".,/:");
        int numTokens = st.countTokens();
        String[] currentLabels = null;
        if (numTokens > 0) {
            currentLabels = new String[numTokens];
            int index = 0;
            while (st.hasMoreTokens()) {
                String aLabel = st.nextToken().trim();
                currentLabels[index++] = aLabel;
            }
        }
        if (numTokens > this.maxLabels) {
            this.maxLabels = numTokens;
        }
        return currentLabels;
    }

    private void parseTransform(String str) {
        StringTokenizer st = new StringTokenizer(str);
        int numTokens = st.countTokens();
        if (numTokens == 16) {
            double[] xform = new double[16];
            int index = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                xform[index++] = Double.parseDouble(token);
            }
            this.transform = new Matrix(xform, 4);
            this.tempCoord = new Matrix(1, 4);
            this.tempCoord.set(0, 3, 1.0);
        }
    }

    public String toString() {
        return this.name;
    }

    public URI getXmlPath() {
        return this.xmlPath;
    }
}

