/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.platform;

import edu.uthscsa.ric.utilities.AppLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;

public final class DisplayUtils {
    private static boolean isMirrored;
    public static final Dimension SCREEN_SIZE_DEFAULT;
    public static final Insets SCREEN_INSETS_DEFAULT;
    public static final int DEFAULT_PADDING = 20;

    private DisplayUtils() {
    }

    public static Rectangle findBoundsOfDisplay(int index) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        if (gd != null && !isMirrored) {
            GraphicsConfiguration gc = gd[index].getDefaultConfiguration();
            return gc.getBounds();
        }
        return new Rectangle(0, 0, DisplayUtils.SCREEN_SIZE_DEFAULT.width, DisplayUtils.SCREEN_SIZE_DEFAULT.height);
    }

    public static int findCurrentDisplayIndex(Component win) {
        int index = 0;
        if (win != null) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] gd = ge.getScreenDevices();
            Point location = DisplayUtils.getLocation(win);
            if (gd != null && !isMirrored) {
                for (int ctr = 0; ctr < gd.length; ++ctr) {
                    GraphicsConfiguration gc = gd[ctr].getDefaultConfiguration();
                    Rectangle bounds = gc.getBounds();
                    if (!bounds.contains(location)) continue;
                    index = ctr;
                    break;
                }
            }
        }
        return index;
    }

    public static Insets findInsetsOfDisplay(int index) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        if (gd != null && !isMirrored) {
            GraphicsConfiguration gc = gd[index].getDefaultConfiguration();
            return Toolkit.getDefaultToolkit().getScreenInsets(gc);
        }
        return SCREEN_INSETS_DEFAULT;
    }

    public static Dimension findSizeOfDisplay(int index) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        if (gd != null && !isMirrored) {
            GraphicsConfiguration gc = gd[index].getDefaultConfiguration();
            return gc.getBounds().getSize();
        }
        return SCREEN_SIZE_DEFAULT;
    }

    public static Rectangle[] getAllDisplayBounds() {
        Rectangle[] rects = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        if (gd != null && !isMirrored) {
            rects = new Rectangle[gd.length];
            for (int ctr = 0; ctr < gd.length; ++ctr) {
                rects[ctr] = gd[ctr].getDefaultConfiguration().getBounds();
            }
        } else {
            rects = new Rectangle[]{new Rectangle(0, 0, DisplayUtils.SCREEN_SIZE_DEFAULT.width, DisplayUtils.SCREEN_SIZE_DEFAULT.height)};
        }
        return rects;
    }

    public static Insets[] getAllDisplayInsets() {
        Insets[] insets = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        if (gd != null && !isMirrored) {
            insets = new Insets[gd.length];
            for (int ctr = 0; ctr < gd.length; ++ctr) {
                insets[ctr] = Toolkit.getDefaultToolkit().getScreenInsets(gd[ctr].getDefaultConfiguration());
            }
        } else {
            insets = new Insets[]{SCREEN_INSETS_DEFAULT};
        }
        return insets;
    }

    public static Dimension[] getAllDisplaySizes() {
        Dimension[] dims = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        if (gd != null && !isMirrored) {
            dims = new Dimension[gd.length];
            for (int ctr = 0; ctr < gd.length; ++ctr) {
                dims[ctr] = gd[ctr].getDefaultConfiguration().getBounds().getSize();
            }
        } else {
            dims = new Dimension[]{SCREEN_SIZE_DEFAULT};
        }
        return dims;
    }

    public static Point getCenterDialogLocation(Component parentWindow, Dimension dialogSize) {
        Point point = new Point();
        Rectangle currentScreen = DisplayUtils.findBoundsOfDisplay(DisplayUtils.findCurrentDisplayIndex(parentWindow));
        Point center = new Point((int)currentScreen.getCenterX(), (int)currentScreen.getCenterY());
        point.x = center.x - dialogSize.width / 2;
        point.y = center.y - dialogSize.height / 2;
        return point;
    }

    public static Point getCenterDialogLocationRelative(Component parentWindow, Dimension dialogSize) {
        Rectangle bounds = parentWindow.getBounds();
        bounds.setLocation(DisplayUtils.getLocation(parentWindow));
        return DisplayUtils.getCenterDialogLocationRelative(bounds, dialogSize);
    }

    public static Point getCenterDialogLocationRelative(Rectangle parentBounds, Dimension dialogSize) {
        Point point = new Point();
        Point center = new Point((int)parentBounds.getCenterX(), (int)parentBounds.getCenterY());
        point.x = center.x - dialogSize.width / 2;
        point.y = center.y - dialogSize.height / 2;
        return point;
    }

    public static Point getDefaultLocation() {
        Rectangle bounds = DisplayUtils.findBoundsOfDisplay(0);
        Insets insets = DisplayUtils.findInsetsOfDisplay(0);
        return new Point(bounds.x + insets.left + 20, bounds.y + insets.top + 20);
    }

    public static Point getNextWindowLocation(Component current, Dimension nextSize, Rectangle[] important) {
        return DisplayUtils.getNextWindowLocation(current, nextSize, important, false, false, false);
    }

    public static Point getNextWindowLocation(Component current, Dimension nextSize, Rectangle[] important, boolean applet) {
        if (applet) {
            return DisplayUtils.getCenterDialogLocation(current, nextSize);
        }
        return DisplayUtils.getNextWindowLocation(current, nextSize, null);
    }

    public static Point getNextWindowLocation(Component current, Dimension nextSize, Rectangle[] important, boolean forceLeft, boolean forceRight, boolean forceTop) {
        boolean currentIsLeft;
        Point point = new Point();
        int displayIndex = DisplayUtils.findCurrentDisplayIndex(current);
        Rectangle currentScreen = DisplayUtils.findBoundsOfDisplay(displayIndex);
        Insets currentInsets = DisplayUtils.findInsetsOfDisplay(displayIndex);
        Point currentLoc = DisplayUtils.getLocation(current);
        Dimension currentSize = current.getSize();
        int currentCenterX = currentLoc.x + currentSize.width / 2;
        boolean bl = currentIsLeft = currentCenterX < currentScreen.x + currentScreen.width / 2;
        if (forceLeft) {
            currentIsLeft = true;
        } else if (forceRight) {
            currentIsLeft = false;
        }
        point.x = currentIsLeft ? currentLoc.x + currentSize.width + 20 : currentLoc.x - 20 - nextSize.width;
        point.y = forceTop ? currentInsets.top + 20 : currentLoc.y;
        Rectangle nextBounds = new Rectangle(point.x, point.y, nextSize.width, nextSize.height);
        boolean screenContainsNextWindow = currentScreen.contains(nextBounds);
        boolean coversImportantArea = false;
        if (important != null) {
            for (Rectangle element : important) {
                if (!nextBounds.intersects(element)) continue;
                coversImportantArea = true;
                break;
            }
        }
        if (!screenContainsNextWindow || coversImportantArea) {
            point.x = currentIsLeft ? currentLoc.x + 20 : currentLoc.x - 20;
            point.y = forceTop ? currentInsets.top + 20 : currentLoc.y + 20;
        }
        return point;
    }

    public static Point getNonOccludingDialogLocationRelative(Component parentWindow, Dimension dialogSize) {
        Rectangle bounds = parentWindow.getBounds();
        bounds.setLocation(DisplayUtils.getLocation(parentWindow));
        return DisplayUtils.getNonOccludingDialogLocationRelative(bounds, dialogSize);
    }

    public static boolean isFarthestLeftDisplay(int index) {
        return DisplayUtils.isFarthestDisplay(index, 1);
    }

    public static boolean isFarthestRightDisplay(int index) {
        return DisplayUtils.isFarthestDisplay(index, 4);
    }

    public static boolean isValidLocation(Point loc) {
        Rectangle[] allBounds = DisplayUtils.getAllDisplayBounds();
        Insets[] allInsets = DisplayUtils.getAllDisplayInsets();
        for (int ctr = 0; ctr < allBounds.length; ++ctr) {
            if (loc.x < allBounds[ctr].x + allInsets[ctr].left || loc.x >= allBounds[ctr].x + allBounds[ctr].width - allInsets[ctr].right || loc.y < allBounds[ctr].y + allInsets[ctr].top || loc.y >= allBounds[ctr].y + allBounds[ctr].height - allInsets[ctr].bottom) continue;
            return true;
        }
        return false;
    }

    private static Point getLocation(Component com) {
        Point point = null;
        try {
            if (com.isVisible()) {
                point = com.getLocationOnScreen();
            }
        }
        catch (IllegalComponentStateException ex) {
            AppLogger.warn((Throwable)ex);
        }
        if (point == null) {
            point = com.getLocation();
        }
        return point;
    }

    private static Point getNonOccludingDialogLocationRelative(Rectangle parentBounds, Dimension dialogSize) {
        Point point = new Point();
        Point center = new Point((int)parentBounds.getCenterX(), (int)parentBounds.getCenterY());
        point.x = center.x - dialogSize.width / 2;
        point.y = parentBounds.y + parentBounds.height - (int)Math.round(0.1 * (double)parentBounds.height);
        return point;
    }

    private static boolean isFarthestDisplay(int index, int outcodeType) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        if (gd != null && !isMirrored) {
            Rectangle bounds = gd[index].getDefaultConfiguration().getBounds();
            for (int ctr = 0; ctr < gd.length; ++ctr) {
                GraphicsConfiguration gc;
                Rectangle rect;
                Point current;
                if (ctr == index || (bounds.outcode(current = new Point((int)(rect = (gc = gd[ctr].getDefaultConfiguration()).getBounds()).getCenterX(), (int)rect.getCenterY())) & outcodeType) == 0) continue;
                return false;
            }
        }
        return true;
    }

    static {
        SCREEN_SIZE_DEFAULT = Toolkit.getDefaultToolkit().getScreenSize();
        SCREEN_INSETS_DEFAULT = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        Rectangle[] rects = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gd = ge.getScreenDevices();
        if (gd != null) {
            rects = new Rectangle[gd.length];
            for (int ctr = 0; ctr < gd.length; ++ctr) {
                boolean noSize;
                rects[ctr] = gd[ctr].getDefaultConfiguration().getBounds();
                if (ctr <= 0) continue;
                boolean sameSize = rects[ctr].equals(rects[ctr - 1]);
                boolean bl = noSize = rects[ctr].width == 0 || rects[ctr].height == 0;
                if (!sameSize && !noSize) continue;
                isMirrored = true;
                break;
            }
        }
    }
}

