/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.menus;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.OpenURIHandler;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.core.LoadItem;
import edu.uthscsa.ric.mango.core.StringComparator;
import edu.uthscsa.ric.mango.viewerslice.menus.ViewerMenuAction;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class AppleMenus
implements OpenFilesHandler,
AboutHandler,
PreferencesHandler,
QuitHandler,
OpenURIHandler {
    private final Mango mango;

    public AppleMenus(Mango mango) {
        this.mango = mango;
        Application app = Application.getApplication();
        app.setAboutHandler(this);
        app.setPreferencesHandler(this);
        app.setQuitHandler(this);
        app.setOpenFileHandler(this);
        app.setOpenURIHandler(this);
    }

    @Override
    public void handleAbout(AppEvent.AboutEvent ae) {
        this.mango.showAbout();
    }

    @Override
    public void handlePreferences(AppEvent.PreferencesEvent pe) {
        ViewerMenuAction.showPreferences();
    }

    @Override
    public void handleQuitRequestWith(AppEvent.QuitEvent qe, QuitResponse qr) {
        this.mango.exitProgram();
    }

    @Override
    public void openFiles(AppEvent.OpenFilesEvent ofe) {
        TreeSet<Object> treeSet = new TreeSet<Object>(new StringComparator());
        List<File> files = ofe.getFiles();
        Iterator<File> it = files.iterator();
        while (it.hasNext()) {
            LoadItem item = new LoadItem(it.next());
            treeSet.add(item);
        }
        this.mango.addToLoadSet(treeSet);
    }

    @Override
    public void openURI(AppEvent.OpenURIEvent oue) {
        this.mango.openCustomURL(oue.getURI());
    }
}

