/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.stats;

import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.dialogs.stats.PointsView;
import edu.uthscsa.ric.mango.dialogs.stats.Statistic;
import edu.uthscsa.ric.mango.dialogs.stats.StatisticsView;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class StatisticsViewCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final MangoNumberFormatter VALUE_FORMATTER = new MangoNumberFormatter(1);
    private final boolean isNumber;

    public StatisticsViewCellRenderer(boolean isNumber) {
        this.isNumber = isNumber;
        if (isNumber) {
            this.setHorizontalAlignment(4);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object val, boolean isSelected, boolean hasFocus, int row, int col) {
        Object value = val;
        Component cell = null;
        if (value instanceof Statistic) {
            Statistic stat = (Statistic)value;
            AnalysisImpl analysis = stat.getAnalysis();
            boolean isClosedViewer = stat.isViewerClosed();
            if (col == StatisticsView.COL_VOLUME) {
                value = stat.getAnalysis().getName();
            } else if (col == StatisticsView.COL_DESCRIPTION) {
                value = stat.getDescription();
            } else if (col == StatisticsView.COL_SIZE) {
                value = this.getSizeString(stat.getAnalysis());
            } else if (col == StatisticsView.COL_COUNT) {
                value = this.getCountString(stat.getAnalysis());
            } else if (col == StatisticsView.COL_MEAN) {
                value = this.getMeanString(analysis);
            } else if (col == StatisticsView.COL_SUM) {
                value = this.getSumString(analysis);
            } else if (col == StatisticsView.COL_SD) {
                value = this.getStdevString(analysis);
            }
            cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            if (isSelected) {
                cell.setBackground(StatisticsView.SELECTED_COLOR);
            } else {
                cell.setBackground(Color.WHITE);
            }
            if (col == StatisticsView.COL_DESCRIPTION) {
                if (analysis.getColor() != null) {
                    cell.setBackground(analysis.getColor());
                } else {
                    int roiIndex = analysis.getROI();
                    if (roiIndex >= 0) {
                        cell.setBackground(ROIColor.getColor(roiIndex));
                    }
                }
            }
            if (isClosedViewer) {
                cell.setForeground(Color.GRAY);
            } else {
                ScreenVolume overlay;
                if (col == PointsView.COL_VOLUME && (overlay = stat.getViewer().getOverlayManager().getOverlay(stat.getVolume())) != null && overlay.isOverlay()) {
                    ScreenVolume sv = stat.getViewer().getOverlayManager().getOverlay(stat.getVolume());
                    Color color = sv.getLookupTableManager().getMinimumColor2();
                    cell.setBackground(color);
                }
                cell.setForeground(Color.BLACK);
            }
            if (this.isNumber) {
                cell.setFont(new Font("Monospaced", 0, 12));
            } else {
                cell.setFont(MangoStyle.FONT_REGULAR);
            }
        }
        return cell;
    }

    private String getCountString(AnalysisImpl analysis) {
        int type = analysis.getType();
        if (type == 7) {
            return "";
        }
        return VALUE_FORMATTER.format(analysis.getCount());
    }

    private String getMeanString(AnalysisImpl analysis) {
        if (analysis.getType() == 7) {
            return "";
        }
        return VALUE_FORMATTER.format(analysis.getMean());
    }

    private String getSizeString(AnalysisImpl analysis) {
        return VALUE_FORMATTER.format(analysis.getRegionSize());
    }

    private String getStdevString(AnalysisImpl analysis) {
        if (analysis.getType() == 7) {
            return "";
        }
        return VALUE_FORMATTER.format(analysis.getStandardDev());
    }

    private String getSumString(AnalysisImpl analysis) {
        if (analysis.getType() == 7) {
            return "";
        }
        return VALUE_FORMATTER.format(analysis.getSum());
    }
}

