/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.stats;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.dialogs.modal.file.SaveFileDialog;
import edu.uthscsa.ric.mango.dialogs.stats.ResultsTableHeaderRenderer;
import edu.uthscsa.ric.mango.dialogs.stats.ResultsView;
import edu.uthscsa.ric.mango.dialogs.stats.RowNumberTable;
import edu.uthscsa.ric.mango.dialogs.stats.Statistic;
import edu.uthscsa.ric.mango.dialogs.stats.StatisticsTable;
import edu.uthscsa.ric.mango.dialogs.stats.StatisticsViewCellRenderer;
import edu.uthscsa.ric.mango.dialogs.stats.TableManager;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class StatisticsView
extends JPanel
implements MouseListener,
ResultsView {
    private DefaultTableModel model;
    private JScrollBar scrollBar;
    private RowNumberTable rowTable;
    private StatisticsTable table;
    private boolean isAddingNewLine;
    private long lastAddedTimestamp;
    private int pressedRow;
    private final Mango mango;
    private final TableManager manager;
    private static final long serialVersionUID = 1L;
    private static int numColumns;
    public static final String NAME = "Global Statistics";
    public static final String COL_DESCRIPTION_NAME = "Description";
    public static final String COL_MEAN_NAME = "Mean";
    public static final String COL_SUM_NAME = "Sum";
    public static final String COL_SD_NAME = "SD";
    public static final String COL_SIZE_NAME = "Size";
    public static final String COL_COUNT_NAME = "Count";
    public static final String COL_VOLUME_NAME = "Image";
    public static final int COL_VOLUME;
    public static final int COL_DESCRIPTION;
    public static final int COL_MEAN;
    public static final int COL_SUM;
    public static final int COL_SD;
    public static final int COL_SIZE;
    public static final int COL_COUNT;

    public StatisticsView(TableManager manager) {
        this.manager = manager;
        this.mango = Mango.getInstance();
        this.pressedRow = -1;
        this.createGUI();
    }

    private void createGUI() {
        ResultsTableHeaderRenderer headerRenderer = new ResultsTableHeaderRenderer();
        this.model = new DefaultTableModel();
        this.table = new StatisticsTable((TableModel)this.model, new StatisticsViewCellRenderer(false));
        JScrollPane scroller = new JScrollPane(this.table);
        this.rowTable = new RowNumberTable(this.table);
        scroller.setRowHeaderView(this.rowTable);
        scroller.setCorner("UPPER_LEFT_CORNER", this.rowTable.getTableHeader());
        this.scrollBar = scroller.getVerticalScrollBar();
        this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent ae) {
                if (StatisticsView.this.isAddingNewLine) {
                    StatisticsView.this.scrollBar.setValue(StatisticsView.this.scrollBar.getMaximum() - StatisticsView.this.scrollBar.getVisibleAmount());
                    StatisticsView.this.isAddingNewLine = false;
                }
            }
        });
        JTableHeader tableHeader = this.table.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        this.table.addMouseListener(this);
        this.model.addColumn(COL_VOLUME);
        this.model.addColumn(COL_DESCRIPTION);
        this.model.addColumn(COL_COUNT);
        this.model.addColumn(COL_SIZE);
        this.model.addColumn(COL_SD);
        this.model.addColumn(COL_MEAN);
        this.model.addColumn(COL_SUM);
        tableColumnModel.getColumn(COL_VOLUME).setCellRenderer(new StatisticsViewCellRenderer(false));
        tableColumnModel.getColumn(COL_DESCRIPTION).setCellRenderer(new StatisticsViewCellRenderer(false));
        tableColumnModel.getColumn(COL_COUNT).setCellRenderer(new StatisticsViewCellRenderer(true));
        tableColumnModel.getColumn(COL_SIZE).setCellRenderer(new StatisticsViewCellRenderer(true));
        tableColumnModel.getColumn(COL_SD).setCellRenderer(new StatisticsViewCellRenderer(true));
        tableColumnModel.getColumn(COL_MEAN).setCellRenderer(new StatisticsViewCellRenderer(true));
        tableColumnModel.getColumn(COL_SUM).setCellRenderer(new StatisticsViewCellRenderer(true));
        tableColumnModel.getColumn(COL_VOLUME).setHeaderRenderer(headerRenderer);
        tableColumnModel.getColumn(COL_DESCRIPTION).setHeaderRenderer(headerRenderer);
        tableColumnModel.getColumn(COL_COUNT).setHeaderRenderer(headerRenderer);
        tableColumnModel.getColumn(COL_SIZE).setHeaderRenderer(headerRenderer);
        tableColumnModel.getColumn(COL_SD).setHeaderRenderer(headerRenderer);
        tableColumnModel.getColumn(COL_MEAN).setHeaderRenderer(headerRenderer);
        tableColumnModel.getColumn(COL_SUM).setHeaderRenderer(headerRenderer);
        tableHeader.getColumnModel().getColumn(COL_VOLUME).setHeaderValue(COL_VOLUME_NAME);
        tableHeader.getColumnModel().getColumn(COL_DESCRIPTION).setHeaderValue(COL_DESCRIPTION_NAME);
        tableHeader.getColumnModel().getColumn(COL_COUNT).setHeaderValue(COL_COUNT_NAME);
        tableHeader.getColumnModel().getColumn(COL_SIZE).setHeaderValue(COL_SIZE_NAME);
        tableHeader.getColumnModel().getColumn(COL_SD).setHeaderValue(COL_SD_NAME);
        tableHeader.getColumnModel().getColumn(COL_MEAN).setHeaderValue(COL_MEAN_NAME);
        tableHeader.getColumnModel().getColumn(COL_SUM).setHeaderValue(COL_SUM_NAME);
        tableColumnModel.getColumn(COL_VOLUME).setPreferredWidth(150);
        tableColumnModel.getColumn(COL_DESCRIPTION).setPreferredWidth(150);
        tableColumnModel.getColumn(COL_COUNT).setPreferredWidth(100);
        tableColumnModel.getColumn(COL_SIZE).setPreferredWidth(100);
        tableColumnModel.getColumn(COL_SD).setPreferredWidth(100);
        tableColumnModel.getColumn(COL_MEAN).setPreferredWidth(100);
        tableColumnModel.getColumn(COL_SUM).setPreferredWidth(100);
        tableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                StatisticsView.this.table.clearSelection();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)scroller, "Center");
    }

    @Override
    public void updateTable() {
        this.table.repaint();
        this.table.getTableHeader().repaint();
    }

    private void addLine(Statistic statistic) {
        if (statistic.getAnalysis().getType() == 7 || statistic.getAnalysis().getType() == 0 || statistic.getAnalysis().getCount() > 0) {
            long timestamp = new Date().getTime();
            long diff = timestamp - this.lastAddedTimestamp;
            if (diff > 2000L) {
                this.clearRecentFlags();
            }
            statistic.setAddBorder(true);
            this.lastAddedTimestamp = timestamp;
            this.isAddingNewLine = true;
            Object[] data = new Object[numColumns];
            for (int ctr = 0; ctr < numColumns; ++ctr) {
                data[ctr] = statistic;
            }
            this.model.addRow(data);
            this.manager.lineAdded();
            ((DefaultTableModel)this.rowTable.getModel()).fireTableDataChanged();
            this.rowTable.repaint();
            this.repaint();
        }
    }

    public void makeLine(final SliceViewer viewer, final Volume volume, final AnalysisImpl stats) {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                StatisticsView.this.addLine(new Statistic(stats, viewer, volume));
                if (stats.getType() == 7) {
                    StatisticsView.this.updateTable();
                }
            }
        });
    }

    public void makeLine(final SliceViewer viewer, final Volume volume, final List<AnalysisImpl> stats) {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                for (AnalysisImpl stat : stats) {
                    StatisticsView.this.addLine(new Statistic(stat, viewer, volume));
                }
            }
        });
    }

    private void clearRecentFlags() {
        int numRows = this.table.getRowCount();
        for (int ctrR = 0; ctrR < numRows; ++ctrR) {
            Statistic stat = (Statistic)this.table.getValueAt(ctrR, 0);
            stat.setAddBorder(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export() {
        String oldDir = this.mango.getLoadFileDirectory();
        File startFile = new File(oldDir, "stats.csv");
        File selectedFile = SaveFileDialog.showSaveFileChooser(this.manager.getFrame(), this.mango.getLoadFileDirectory(), startFile.getName());
        if (selectedFile != null) {
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(new BufferedWriter(new FileWriter(selectedFile)));
                String headers = "Viewer,Image,Description,Mean,Sum,SD,Size (mm),Voxels";
                writer.println("Viewer,Image,Description,Mean,Sum,SD,Size (mm),Voxels");
                int numRows = this.table.getRowCount();
                for (int ctrR = 0; ctrR < numRows; ++ctrR) {
                    Statistic stat = (Statistic)this.table.getValueAt(ctrR, 0);
                    AnalysisImpl analysis = stat.getAnalysis();
                    writer.print(stat.getViewerName() + ",");
                    writer.print(analysis.getName() + ",");
                    writer.print(analysis.getExportableDescription() + ",");
                    if (analysis.getType() == 7) {
                        writer.print(",");
                    } else {
                        writer.print(analysis.getMean() + ",");
                    }
                    if (analysis.getType() == 7) {
                        writer.print(",");
                    } else {
                        writer.print(analysis.getSum() + ",");
                    }
                    if (analysis.getType() == 7) {
                        writer.print(",");
                    } else {
                        writer.print(analysis.getStandardDev() + ",");
                    }
                    writer.print(analysis.getRegionSize() + ",");
                    if (analysis.getType() == 7) {
                        writer.print(",");
                    } else {
                        writer.print(analysis.getCount() + ",");
                    }
                    writer.println();
                }
            }
            catch (Exception ex) {
                AppLogger.error((Throwable)ex);
                this.mango.showErrorDialog("Problem writing stats file!", "File Write Error");
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
    }

    @Override
    public StatisticsTable getTable() {
        return this.table;
    }

    private void goToCoordinate(int row) {
        Statistic stat = (Statistic)this.table.getValueAt(row, 0);
        if (!stat.isViewerClosed()) {
            SliceViewer viewer = stat.getViewer();
            Coordinate coor = viewer.getVolume().getCenter();
            Volume vol = stat.getVolume();
            viewer.frameToFront();
            viewer.setCurrentOverlay(vol);
            viewer.setCurrentCoordinate(coor, true, -1);
            viewer.setCurrentSeriesPoint(stat.getSeriesPoint());
            viewer.updateScreenSliceTransforms();
            viewer.updateSurface();
            viewer.updateSync();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.pressedRow = this.table.rowAtPoint(me.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        int releasedRow = this.table.rowAtPoint(me.getPoint());
        if (this.pressedRow >= 0 && this.pressedRow == releasedRow) {
            this.goToCoordinate(this.pressedRow);
        }
        this.pressedRow = -1;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    static {
        COL_VOLUME = numColumns++;
        COL_DESCRIPTION = numColumns++;
        COL_MEAN = numColumns++;
        COL_SUM = numColumns++;
        COL_SD = numColumns++;
        COL_SIZE = numColumns++;
        COL_COUNT = numColumns++;
    }
}

