/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.stats;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;

public class StatisticsTable
extends JTable {
    private final TableModel model;
    private final DefaultTableCellRenderer renderer;
    private static final long serialVersionUID = 1L;

    public StatisticsTable(TableModel model, DefaultTableCellRenderer renderer) {
        super(model);
        this.model = model;
        this.renderer = renderer;
        AbstractAction copyAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StatisticsTable.this.copy();
            }
        };
        AbstractAction deleteAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StatisticsTable.this.delete(true);
            }
        };
        this.registerKeyboardAction(copyAction, KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), 0);
        this.registerKeyboardAction(deleteAction, KeyStroke.getKeyStroke(8, 0), 0);
        this.registerKeyboardAction(deleteAction, KeyStroke.getKeyStroke(127, 0), 0);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == this.getColumnCount() - 1;
    }

    protected void delete(boolean deleteAll) {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        int numRows = model.getRowCount();
        if (deleteAll) {
            for (int ctr = numRows - 1; ctr >= 0; --ctr) {
                model.removeRow(ctr);
            }
        } else {
            for (int ctr = numRows - 1; ctr >= 0; --ctr) {
                if (!this.isRowSelected(ctr)) continue;
                model.removeRow(ctr);
            }
        }
        this.clearSelection();
    }

    public void copy() {
        int numRows = this.model.getRowCount();
        int numCols = this.model.getColumnCount();
        boolean hasSelection = this.getSelectedRowCount() > 0;
        StringBuffer copyBuffer = new StringBuffer();
        for (int ctrR = 0; ctrR < numRows; ++ctrR) {
            if (hasSelection && !this.isRowSelected(ctrR)) continue;
            for (int ctrC = 0; ctrC < numCols; ++ctrC) {
                this.renderer.getTableCellRendererComponent(this, this.getValueAt(ctrR, ctrC), false, false, ctrR, ctrC);
                copyBuffer.append(this.renderer.getText());
                copyBuffer.append('\t');
            }
            copyBuffer.append('\n');
        }
        String copyString = copyBuffer.toString();
        if (StringUtils.isNotBlank((CharSequence)copyString)) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(copyString), null);
        }
    }
}

