/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.stats;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoDropDownButton;
import edu.uthscsa.ric.mango.dialogs.stats.AnalysisPointImpl;
import edu.uthscsa.ric.mango.dialogs.stats.PointsView;
import edu.uthscsa.ric.mango.dialogs.stats.ResultsView;
import edu.uthscsa.ric.mango.dialogs.stats.Statistic;
import edu.uthscsa.ric.mango.dialogs.stats.StatisticsTable;
import edu.uthscsa.ric.mango.dialogs.stats.StatisticsView;
import edu.uthscsa.ric.mango.dialogs.stats.TableManager;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.volume.Analysis;
import edu.uthscsa.ric.volume.AnalysisPoint;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.Volume;
import edu.uthscsa.ric.volume.operations.stats.AnalysisImpl;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class ResultsTool
extends JFrame
implements ActionListener,
PopupMenuListener,
TableManager {
    private JButton clearButton;
    private JPopupMenu clearButtonPopup;
    private JTabbedPane tabbedPane;
    private PointsView pointsView;
    private StatisticsView statsView;
    private long popupTimeCanceled;
    private final Mango mango;
    private static final long serialVersionUID = 1L;
    public static final Dimension START_SIZE = new Dimension(825, 200);
    public static final String NAME = "All Results";
    public static final int MINIMUM_HEIGHT = 200;
    public static final int MINIMUM_WIDTH = 650;
    public static final int PADDING = 10;

    public ResultsTool(Mango mango) {
        this.mango = mango;
        this.createGUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals("Export...")) {
            this.getCurrentResultsView().export();
        } else if (command.equals("Copy")) {
            this.getCurrentResultsView().getTable().copy();
        } else if (command.equals("Clear")) {
            long timeSinceCancel = new Date().getTime() - this.popupTimeCanceled;
            if (this.clearButtonPopup.getComponentCount() > 0 && timeSinceCancel > 250L) {
                this.clearButtonPopup.show(this.clearButton, 2, 35);
            }
        } else if (command.equals("Clear Selected")) {
            this.getCurrentResultsView().getTable().delete(false);
        } else if (command.equals("Clear Table")) {
            this.getCurrentResultsView().getTable().delete(true);
        } else if (command.equals("Clear All Tables")) {
            this.statsView.getTable().delete(true);
            this.pointsView.getTable().delete(true);
        }
        this.getCurrentResultsView().updateTable();
    }

    public void addPoint(SliceViewer viewer, Volume volume, Coordinate4D coordinate, double result, String description) {
        AnalysisPointImpl poi = new AnalysisPointImpl(coordinate, result, viewer, volume, description, "Point");
        this.pointsView.makeLine(poi);
        this.tabbedPane.setSelectedIndex(1);
    }

    public void addPoint(SliceViewer viewer, Volume volume, Coordinate4D coordinate, double result, String description, Color color) {
        AnalysisPointImpl poi = new AnalysisPointImpl(coordinate, result, viewer, volume, description, "Point");
        if (color != null) {
            poi.setColor(color);
        }
        this.pointsView.makeLine(poi);
        this.tabbedPane.setSelectedIndex(1);
    }

    public void addStatistic(SliceViewer viewer, Volume volume, AnalysisImpl stats) {
        this.statsView.makeLine(viewer, volume, stats);
        this.tabbedPane.setSelectedIndex(0);
        if (stats.getType() != 7) {
            this.addPointFromStat(viewer, volume, stats);
        }
    }

    public void addStatistic(SliceViewer viewer, Volume volume, List<AnalysisImpl> stats) {
        this.statsView.makeLine(viewer, volume, stats);
        for (AnalysisImpl stat : stats) {
            this.addPointFromStat(viewer, volume, stat);
        }
    }

    public List<Analysis> getAllAnalyses() {
        StatisticsTable table = this.statsView.getTable();
        ArrayList<Analysis> stats = new ArrayList<Analysis>();
        int numRows = table.getRowCount();
        for (int ctrR = 0; ctrR < numRows; ++ctrR) {
            Statistic stat = (Statistic)table.getValueAt(ctrR, 0);
            AnalysisImpl analysis = stat.getAnalysis();
            stats.add(analysis);
        }
        return stats;
    }

    public List<AnalysisPoint> getAllAnalysisPoints() {
        StatisticsTable table = this.pointsView.getTable();
        ArrayList<AnalysisPoint> stats = new ArrayList<AnalysisPoint>();
        int numRows = table.getRowCount();
        for (int ctrR = 0; ctrR < numRows; ++ctrR) {
            AnalysisPointImpl stat = (AnalysisPointImpl)table.getValueAt(ctrR, 0);
            stats.add(stat);
        }
        return stats;
    }

    @Override
    public JFrame getFrame() {
        return this;
    }

    @Override
    public void lineAdded() {
        if (!this.isVisible()) {
            this.updateLocation();
        }
        this.validate();
        this.setVisible(true);
        if ((this.getState() & 1) != 0) {
            this.setState(0);
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent pme) {
        if (pme.getSource() == this.clearButtonPopup) {
            this.popupTimeCanceled = new Date().getTime();
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    public void updateTables() {
        this.statsView.updateTable();
        this.pointsView.updateTable();
    }

    private void addPointFromStat(SliceViewer viewer, Volume volume, AnalysisImpl stats) {
        if (stats.getType() == 0) {
            String type = "Point";
            AnalysisPointImpl poi = new AnalysisPointImpl(stats.getMaxCoordinate(), stats.max, viewer, volume, stats.description, "Point");
            poi.setColor(stats.getColor());
            poi.setROI(stats.getROI());
            this.pointsView.makeLine(poi);
        } else {
            String type = "Max";
            AnalysisPointImpl poi = new AnalysisPointImpl(stats.getMaxCoordinate(), stats.max, viewer, volume, stats.description, type);
            poi.setColor(stats.getColor());
            poi.setROI(stats.getROI());
            this.pointsView.makeLine(poi);
            type = "Min";
            poi = new AnalysisPointImpl(stats.getMinCoordinate(), stats.min, viewer, volume, stats.description, type);
            poi.setColor(stats.getColor());
            poi.setROI(stats.getROI());
            this.pointsView.makeLine(poi);
            type = "Centroid";
            poi = new AnalysisPointImpl(stats.getCentroidCoordinate(), stats.centroid, viewer, volume, stats.description, type);
            poi.setColor(stats.getColor());
            poi.setROI(stats.getROI());
            this.pointsView.makeLine(poi);
        }
    }

    private void createGUI() {
        this.tabbedPane = new JTabbedPane();
        JPanel statsPanel = new JPanel(new BorderLayout());
        this.statsView = new StatisticsView(this);
        statsPanel.add((Component)this.statsView, "Center");
        JPanel pointsPanel = new JPanel(new BorderLayout());
        this.pointsView = new PointsView(this);
        pointsPanel.add((Component)this.pointsView, "Center");
        this.tabbedPane.addTab("Global Statistics", statsPanel);
        this.tabbedPane.addTab("Point Statistics", pointsPanel);
        this.clearButton = new MangoDropDownButton("Clear");
        this.clearButton.addActionListener(this);
        this.clearButton.setActionCommand("Clear");
        this.makeClearButtonPopup();
        JButton exportButton = new JButton("Export...");
        exportButton.addActionListener(this);
        JButton copyButton = new JButton("Copy");
        copyButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(this.clearButton);
        if (!this.mango.isApplet()) {
            buttonPanel.add(Box.createHorizontalStrut(4));
            buttonPanel.add(copyButton);
            buttonPanel.add(Box.createHorizontalStrut(4));
            buttonPanel.add(exportButton);
        }
        buttonPanel.add(Box.createHorizontalGlue());
        JLabel instructionLabel = new JLabel("Click a row to navigate to that point in the associated viewer.");
        instructionLabel.setForeground(Color.GRAY);
        buttonPanel.add(instructionLabel);
        buttonPanel.add(Box.createHorizontalStrut(4));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(2, 8, 8, 8));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent ce) {
                Dimension dim = ResultsTool.this.getSize();
                if (dim.width < 650 && dim.height >= 200) {
                    ResultsTool.this.setSize(650, dim.height);
                } else if (dim.width >= 650 && dim.height < 200) {
                    ResultsTool.this.setSize(dim.width, 200);
                } else if (dim.width < 650 && dim.height < 200) {
                    ResultsTool.this.setSize(650, 200);
                }
            }
        });
        this.setDefaultCloseOperation(1);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setIconImage(MangoStyle.ICON_APP.getImage());
        this.setBackground(Color.LIGHT_GRAY);
        this.setTitle(NAME);
        this.setSize(START_SIZE);
        if (!this.isVisible()) {
            this.updateLocation();
        }
    }

    private ResultsView getCurrentResultsView() {
        int index = this.tabbedPane.getSelectedIndex();
        if (index == 0) {
            return this.statsView;
        }
        return this.pointsView;
    }

    private void makeClearButtonPopup() {
        this.clearButtonPopup = new JPopupMenu();
        JMenuItem mi = new JMenuItem("Selected");
        mi.setActionCommand("Clear Selected");
        mi.addActionListener(this);
        this.clearButtonPopup.add(mi);
        mi = new JMenuItem("Table");
        mi.setActionCommand("Clear Table");
        mi.addActionListener(this);
        this.clearButtonPopup.add(mi);
        mi = new JMenuItem("All Tables");
        mi.setActionCommand("Clear All Tables");
        mi.addActionListener(this);
        this.clearButtonPopup.add(mi);
        this.clearButtonPopup.addPopupMenuListener(this);
    }

    private void updateLocation() {
        if (!this.mango.isApplet()) {
            this.setLocation(DisplayUtils.getCenterDialogLocation(this.mango.getToolBox(), this.getSize()));
        } else {
            this.setLocation(DisplayUtils.getCenterDialogLocation(Mango.getMangoApplet(), this.getSize()));
        }
    }
}

