/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.stats;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoNumberFormatter;
import edu.uthscsa.ric.mango.dialogs.stats.AnalysisPointImpl;
import edu.uthscsa.ric.mango.dialogs.stats.PointsView;
import edu.uthscsa.ric.mango.dialogs.stats.Result;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.screen.ScreenVolume;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Coordinate4D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.commons.lang3.StringUtils;

class PointsViewCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    public static final MangoNumberFormatter VALUE_FORMATTER = new MangoNumberFormatter(1);
    public static final MangoNumberFormatter NUMBER_FORMATTER = new MangoNumberFormatter();
    private final boolean isNumber;

    public PointsViewCellRenderer(boolean isNumber) {
        this.isNumber = isNumber;
        if (isNumber) {
            this.setHorizontalAlignment(4);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object val, boolean isSelected, boolean hasFocus, int row, int col) {
        Object value = val;
        Component cell = null;
        if (value instanceof AnalysisPointImpl) {
            AnalysisPointImpl poi = (AnalysisPointImpl)value;
            boolean isClosedViewer = poi.isViewerClosed();
            if (col == PointsView.COL_VOLUME) {
                value = poi.getName();
            } else if (col == PointsView.COL_TYPE) {
                value = poi.getType();
            } else if (col == PointsView.COL_DESCRIPTION) {
                value = poi.getDescription();
            } else if (col == PointsView.COL_VALUE) {
                value = this.getCoordinateValue(poi);
            } else if (col == PointsView.COL_COORD_X) {
                value = this.getCoordinateStringX(poi, poi.getCoordinate());
            } else if (col == PointsView.COL_COORD_Y) {
                value = this.getCoordinateStringY(poi, poi.getCoordinate());
            } else if (col == PointsView.COL_COORD_Z) {
                value = this.getCoordinateStringZ(poi, poi.getCoordinate());
            } else if (col == PointsView.COL_COORD_T) {
                value = this.getCoordinateStringT(poi, poi.getCoordinate());
            } else if (col == PointsView.COL_ATLAS_1) {
                value = this.getAtlasLabel(poi, 0);
            } else if (col == PointsView.COL_ATLAS_2) {
                value = this.getAtlasLabel(poi, 1);
            } else if (col == PointsView.COL_ATLAS_3) {
                value = this.getAtlasLabel(poi, 2);
            } else if (col == PointsView.COL_ATLAS_4) {
                value = this.getAtlasLabel(poi, 3);
            }
            cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            if (isSelected) {
                cell.setBackground(PointsView.SELECTED_COLOR);
            } else {
                cell.setBackground(Color.WHITE);
            }
            if (col == PointsView.COL_DESCRIPTION) {
                if (poi.getColor() != null) {
                    cell.setBackground(poi.getColor());
                } else {
                    int roiIndex = poi.getROI();
                    if (roiIndex >= 0) {
                        cell.setBackground(ROIColor.getColor(roiIndex));
                    }
                }
            }
            if (isClosedViewer) {
                cell.setForeground(Color.GRAY);
            } else {
                ScreenVolume overlay;
                if (col == PointsView.COL_VOLUME && (overlay = ((SliceViewer)poi.getViewer()).getOverlayManager().getOverlay(poi.getVolume())) != null && overlay.isOverlay()) {
                    ScreenVolume sv = ((SliceViewer)poi.getViewer()).getOverlayManager().getOverlay(poi.getVolume());
                    Color color = sv.getLookupTableManager().getMinimumColor2();
                    cell.setBackground(color);
                }
                cell.setForeground(Color.BLACK);
            }
            if (this.isNumber) {
                cell.setFont(new Font("Monospaced", 0, 12));
            } else {
                cell.setFont(MangoStyle.FONT_REGULAR);
            }
        }
        return cell;
    }

    private String getAtlasLabel(AnalysisPointImpl poi, int index) {
        String[] labels = poi.getLabels();
        if (labels != null && index < labels.length && StringUtils.isNotBlank((CharSequence)labels[index])) {
            String label = labels[index];
            if (label.indexOf("Brodmann area") != -1) {
                label = label.replace("Brodmann area", "BA");
            }
            return label;
        }
        return "";
    }

    private String getCoordinateValue(AnalysisPointImpl poi) {
        if (Double.isNaN(poi.getValue())) {
            return "";
        }
        return VALUE_FORMATTER.format(poi.getValue());
    }

    public String getCoordinateStringT(Result result, Coordinate4D coor) {
        String label = "";
        if (coor != null) {
            label = String.valueOf(coor.getSeriesPoint() + 1);
        }
        return label;
    }

    public String getCoordinateStringX(Result result, Coordinate4D coor) {
        if (coor != null) {
            if (Mango.getInstance().getToolBox().isWorldMode()) {
                Coordinate origin = result.getViewerOrigin();
                return NUMBER_FORMATTER.format((coor.xDbl - (double)origin.xInt) * result.getSizeX());
            }
            return NUMBER_FORMATTER.format(SliceViewer.convertCoordinateOriginX(coor.xInt, result.getXDim()));
        }
        return "";
    }

    public String getCoordinateStringY(Result result, Coordinate4D coor) {
        if (coor != null) {
            if (Mango.getInstance().getToolBox().isWorldMode()) {
                Coordinate origin = result.getViewerOrigin();
                return NUMBER_FORMATTER.format(((double)origin.yInt - coor.yDbl) * result.getSizeY());
            }
            return NUMBER_FORMATTER.format(SliceViewer.convertCoordinateOriginY(coor.yInt, result.getYDim()));
        }
        return "";
    }

    public String getCoordinateStringZ(Result result, Coordinate4D coor) {
        if (coor != null) {
            if (Mango.getInstance().getToolBox().isWorldMode()) {
                Coordinate origin = result.getViewerOrigin();
                return NUMBER_FORMATTER.format(((double)origin.zInt - coor.zDbl) * result.getSizeZ());
            }
            return NUMBER_FORMATTER.format(SliceViewer.convertCoordinateOriginZ(coor.zInt, result.getZDim()));
        }
        return "";
    }
}

