/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.stats;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.dialogs.modal.file.SaveFileDialog;
import edu.uthscsa.ric.mango.dialogs.stats.AnalysisPointImpl;
import edu.uthscsa.ric.mango.dialogs.stats.PointsViewCellRenderer;
import edu.uthscsa.ric.mango.dialogs.stats.ResultsTableHeaderRenderer;
import edu.uthscsa.ric.mango.dialogs.stats.ResultsView;
import edu.uthscsa.ric.mango.dialogs.stats.RowNumberTable;
import edu.uthscsa.ric.mango.dialogs.stats.StatisticsTable;
import edu.uthscsa.ric.mango.dialogs.stats.TableManager;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.Volume;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class PointsView
extends JPanel
implements MouseListener,
ResultsView {
    private DefaultTableModel model;
    private JScrollBar scrollBar;
    private RowNumberTable rowTable;
    private StatisticsTable table;
    private PointsViewCellRenderer cellRenderer;
    private final Mango mango;
    private boolean isAddingNewLine;
    private long lastAddedTimestamp;
    private int pressedRow;
    private final TableManager manager;
    private static final long serialVersionUID = 1L;
    private static int numColumns;
    public static final int COL_VOLUME;
    public static final int COL_DESCRIPTION;
    public static final int COL_TYPE;
    public static final int COL_VALUE;
    public static final int COL_COORD_X;
    public static final int COL_COORD_Y;
    public static final int COL_COORD_Z;
    public static final int COL_COORD_T;
    public static final int COL_ATLAS_1;
    public static final int COL_ATLAS_2;
    public static final int COL_ATLAS_3;
    public static final int COL_ATLAS_4;
    public static final String COL_ATLAS_1_NAME = "Atlas 1";
    public static final String COL_ATLAS_2_NAME = "Atlas 2";
    public static final String COL_ATLAS_3_NAME = "Atlas 3";
    public static final String COL_ATLAS_4_NAME = "Atlas 4";
    public static final String COL_COORD_T_NAME = "T";
    public static final String COL_COORD_X_NAME = "X";
    public static final String COL_COORD_Y_NAME = "Y";
    public static final String COL_COORD_Z_NAME = "Z";
    public static final String COL_TYPE_NAME = "Type";
    public static final String COL_VALUE_NAME = "Value";
    public static final String COL_VOLUME_NAME = "Volume";
    public static final String COL_DESCRIPTION_NAME = "Description";
    public static final String NAME = "Point Statistics";

    public PointsView(TableManager manager) {
        this.manager = manager;
        this.mango = Mango.getInstance();
        this.pressedRow = -1;
        this.createGUI();
    }

    private void createGUI() {
        this.cellRenderer = new PointsViewCellRenderer(false);
        ResultsTableHeaderRenderer headerRenderer = new ResultsTableHeaderRenderer();
        this.model = new DefaultTableModel();
        this.table = new StatisticsTable((TableModel)this.model, this.cellRenderer);
        JScrollPane scroller = new JScrollPane(this.table);
        this.rowTable = new RowNumberTable(this.table);
        scroller.setRowHeaderView(this.rowTable);
        scroller.setCorner("UPPER_LEFT_CORNER", this.rowTable.getTableHeader());
        this.scrollBar = scroller.getVerticalScrollBar();
        this.scrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent ae) {
                if (PointsView.this.isAddingNewLine) {
                    PointsView.this.scrollBar.setValue(PointsView.this.scrollBar.getMaximum() - PointsView.this.scrollBar.getVisibleAmount());
                    PointsView.this.isAddingNewLine = false;
                }
            }
        });
        JTableHeader tableHeader = this.table.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        this.table.addMouseListener(this);
        this.model.addColumn(COL_VOLUME);
        this.model.addColumn(COL_DESCRIPTION);
        this.model.addColumn(COL_TYPE);
        this.model.addColumn(COL_VALUE);
        this.model.addColumn(COL_COORD_X);
        this.model.addColumn(COL_COORD_Y);
        this.model.addColumn(COL_COORD_Z);
        this.model.addColumn(COL_COORD_T);
        this.model.addColumn(COL_ATLAS_1);
        this.model.addColumn(COL_ATLAS_2);
        this.model.addColumn(COL_ATLAS_3);
        this.model.addColumn(COL_ATLAS_4);
        tableColumnModel.getColumn(COL_VOLUME).setCellRenderer(new PointsViewCellRenderer(false));
        tableColumnModel.getColumn(COL_DESCRIPTION).setCellRenderer(new PointsViewCellRenderer(false));
        tableColumnModel.getColumn(COL_TYPE).setCellRenderer(new PointsViewCellRenderer(false));
        tableColumnModel.getColumn(COL_VALUE).setCellRenderer(new PointsViewCellRenderer(true));
        tableColumnModel.getColumn(COL_COORD_X).setCellRenderer(new PointsViewCellRenderer(true));
        tableColumnModel.getColumn(COL_COORD_Y).setCellRenderer(new PointsViewCellRenderer(true));
        tableColumnModel.getColumn(COL_COORD_Z).setCellRenderer(new PointsViewCellRenderer(true));
        tableColumnModel.getColumn(COL_COORD_T).setCellRenderer(new PointsViewCellRenderer(true));
        tableColumnModel.getColumn(COL_ATLAS_1).setCellRenderer(new PointsViewCellRenderer(false));
        tableColumnModel.getColumn(COL_ATLAS_2).setCellRenderer(new PointsViewCellRenderer(false));
        tableColumnModel.getColumn(COL_ATLAS_3).setCellRenderer(new PointsViewCellRenderer(false));
        tableColumnModel.getColumn(COL_ATLAS_4).setCellRenderer(new PointsViewCellRenderer(false));
        tableColumnModel.getColumn(COL_VOLUME).setHeaderRenderer(headerRenderer);
        tableColumnModel.getColumn(COL_DESCRIPTION).setHeaderRenderer(headerRenderer);
        tableColumnModel.getColumn(COL_TYPE).setHeaderRenderer(headerRenderer);
        tableColumnModel.getColumn(COL_VALUE).setHeaderRenderer(headerRenderer);
        tableColumnModel.getColumn(COL_COORD_X).setHeaderRenderer(headerRenderer);
        tableColumnModel.getColumn(COL_COORD_Y).setHeaderRenderer(headerRenderer);
        tableColumnModel.getColumn(COL_COORD_Z).setHeaderRenderer(headerRenderer);
        tableColumnModel.getColumn(COL_COORD_T).setHeaderRenderer(headerRenderer);
        tableColumnModel.getColumn(COL_ATLAS_1).setHeaderRenderer(headerRenderer);
        tableColumnModel.getColumn(COL_ATLAS_2).setHeaderRenderer(headerRenderer);
        tableColumnModel.getColumn(COL_ATLAS_3).setHeaderRenderer(headerRenderer);
        tableColumnModel.getColumn(COL_ATLAS_4).setHeaderRenderer(headerRenderer);
        tableHeader.getColumnModel().getColumn(COL_VOLUME).setHeaderValue(COL_VOLUME_NAME);
        tableHeader.getColumnModel().getColumn(COL_DESCRIPTION).setHeaderValue(COL_DESCRIPTION_NAME);
        tableHeader.getColumnModel().getColumn(COL_TYPE).setHeaderValue(COL_TYPE_NAME);
        tableHeader.getColumnModel().getColumn(COL_VALUE).setHeaderValue(COL_VALUE_NAME);
        tableHeader.getColumnModel().getColumn(COL_COORD_X).setHeaderValue(COL_COORD_X_NAME);
        tableHeader.getColumnModel().getColumn(COL_COORD_Y).setHeaderValue(COL_COORD_Y_NAME);
        tableHeader.getColumnModel().getColumn(COL_COORD_Z).setHeaderValue(COL_COORD_Z_NAME);
        tableHeader.getColumnModel().getColumn(COL_COORD_T).setHeaderValue(COL_COORD_T_NAME);
        tableHeader.getColumnModel().getColumn(COL_ATLAS_1).setHeaderValue(COL_ATLAS_1_NAME);
        tableHeader.getColumnModel().getColumn(COL_ATLAS_2).setHeaderValue(COL_ATLAS_2_NAME);
        tableHeader.getColumnModel().getColumn(COL_ATLAS_3).setHeaderValue(COL_ATLAS_3_NAME);
        tableHeader.getColumnModel().getColumn(COL_ATLAS_4).setHeaderValue(COL_ATLAS_4_NAME);
        tableColumnModel.getColumn(COL_VOLUME).setPreferredWidth(150);
        tableColumnModel.getColumn(COL_DESCRIPTION).setPreferredWidth(150);
        tableColumnModel.getColumn(COL_TYPE).setPreferredWidth(100);
        tableColumnModel.getColumn(COL_VALUE).setPreferredWidth(100);
        tableColumnModel.getColumn(COL_COORD_X).setPreferredWidth(100);
        tableColumnModel.getColumn(COL_COORD_Y).setPreferredWidth(100);
        tableColumnModel.getColumn(COL_COORD_Z).setPreferredWidth(100);
        tableColumnModel.getColumn(COL_COORD_T).setPreferredWidth(50);
        tableColumnModel.getColumn(COL_ATLAS_1).setPreferredWidth(150);
        tableColumnModel.getColumn(COL_ATLAS_2).setPreferredWidth(150);
        tableColumnModel.getColumn(COL_ATLAS_3).setPreferredWidth(150);
        tableColumnModel.getColumn(COL_ATLAS_4).setPreferredWidth(150);
        tableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                PointsView.this.table.clearSelection();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)scroller, "Center");
    }

    private void goToCoordinate(int row) {
        AnalysisPointImpl point = (AnalysisPointImpl)this.table.getValueAt(row, 0);
        if (!point.isViewerClosed()) {
            Coordinate4D coor = point.getCoordinate();
            SliceViewer viewer = (SliceViewer)point.getViewer();
            Volume vol = point.getVolume();
            int timepoint = 0;
            if (coor != null) {
                timepoint = coor.seriesPoint;
            }
            if (timepoint < 0) {
                timepoint = 0;
            }
            viewer.frameToFront();
            viewer.setCurrentOverlay(vol);
            viewer.setCurrentTimepoint(timepoint, vol);
            viewer.setCurrentCoordinate((Coordinate)coor, true, -1);
            viewer.updateScreenSliceTransforms();
            viewer.updateSurface();
            viewer.updateSync();
        }
    }

    public void makeLine(final AnalysisPointImpl poi) {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                PointsView.this.addLine(poi);
            }
        });
    }

    @Override
    public void updateTable() {
        this.table.repaint();
        this.table.getTableHeader().repaint();
    }

    private void addLine(AnalysisPointImpl poi) {
        long timestamp = new Date().getTime();
        long diff = timestamp - this.lastAddedTimestamp;
        if (diff > 2000L) {
            this.clearRecentFlags();
        }
        poi.setAddBorder(true);
        this.lastAddedTimestamp = timestamp;
        this.isAddingNewLine = true;
        Object[] data = new Object[numColumns];
        for (int ctr = 0; ctr < numColumns; ++ctr) {
            data[ctr] = poi;
        }
        this.model.addRow(data);
        this.manager.lineAdded();
        ((DefaultTableModel)this.rowTable.getModel()).fireTableDataChanged();
        this.rowTable.repaint();
        this.repaint();
    }

    private void clearRecentFlags() {
        int numRows = this.table.getRowCount();
        for (int ctrR = 0; ctrR < numRows; ++ctrR) {
            AnalysisPointImpl poi = (AnalysisPointImpl)this.table.getValueAt(ctrR, 0);
            poi.setAddBorder(false);
        }
    }

    @Override
    public StatisticsTable getTable() {
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export() {
        String oldDir = this.mango.getLoadFileDirectory();
        File startFile = new File(oldDir, "stats.csv");
        File selectedFile = SaveFileDialog.showSaveFileChooser(this.manager.getFrame(), this.mango.getLoadFileDirectory(), startFile.getName());
        if (selectedFile != null) {
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(new BufferedWriter(new FileWriter(selectedFile)));
                String headers1 = "Viewer,Image,Type,Value,X,Y,Z,Series,Label 1,Label 2,Label 3,Label 4";
                writer.println("Viewer,Image,Type,Value,X,Y,Z,Series,Label 1,Label 2,Label 3,Label 4");
                int numRows = this.table.getRowCount();
                for (int ctrR = 0; ctrR < numRows; ++ctrR) {
                    AnalysisPointImpl poi = (AnalysisPointImpl)this.table.getValueAt(ctrR, 0);
                    writer.print(poi.getViewerName() + ",");
                    writer.print(poi.getName() + ",");
                    writer.print(poi.getDescription() + ",");
                    Coordinate4D coor = poi.getCoordinate();
                    writer.print(poi.getValue() + ",");
                    writer.print(this.cellRenderer.getCoordinateStringX(poi, coor) + ",");
                    writer.print(this.cellRenderer.getCoordinateStringY(poi, coor) + ",");
                    writer.print(this.cellRenderer.getCoordinateStringZ(poi, coor) + ",");
                    writer.print(this.cellRenderer.getCoordinateStringT(poi, coor) + ",");
                    String[] labels = poi.getLabels();
                    if (labels != null) {
                        for (int ctr = 0; ctr < labels.length; ++ctr) {
                            if (labels[ctr] != null) {
                                writer.print(labels[ctr]);
                            }
                            if (ctr >= labels.length - 1) continue;
                            writer.print(",");
                        }
                    }
                    writer.println();
                }
            }
            catch (Exception ex) {
                AppLogger.error((Throwable)ex);
                this.mango.showErrorDialog("Problem writing stats file!", "File Write Error");
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.pressedRow = this.table.rowAtPoint(me.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        int releasedRow = this.table.rowAtPoint(me.getPoint());
        if (this.pressedRow >= 0 && this.pressedRow == releasedRow) {
            this.goToCoordinate(this.pressedRow);
        }
        this.pressedRow = -1;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    static {
        COL_VOLUME = numColumns++;
        COL_DESCRIPTION = numColumns++;
        COL_TYPE = numColumns++;
        COL_VALUE = numColumns++;
        COL_COORD_X = numColumns++;
        COL_COORD_Y = numColumns++;
        COL_COORD_Z = numColumns++;
        COL_COORD_T = numColumns++;
        COL_ATLAS_1 = numColumns++;
        COL_ATLAS_2 = numColumns++;
        COL_ATLAS_3 = numColumns++;
        COL_ATLAS_4 = numColumns++;
    }
}

