/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.stats;

import edu.uthscsa.ric.mango.Atlas;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.dialogs.stats.Result;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.volume.AnalysisPoint;
import edu.uthscsa.ric.volume.Coordinate;
import edu.uthscsa.ric.volume.Coordinate4D;
import edu.uthscsa.ric.volume.ImageVolume;
import edu.uthscsa.ric.volume.SeriesDefaultLabels;
import edu.uthscsa.ric.volume.Volume;
import java.awt.Color;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class AnalysisPointImpl
implements AnalysisPoint,
Result {
    private boolean addBorder;
    private Color color;
    private final Coordinate4D coordinate;
    private final String description;
    private String[] labels;
    private final String name;
    private int roi;
    private final double sizeX;
    private final double sizeY;
    private final double sizeZ;
    private final String type;
    private final double value;
    private final WeakReference<VolumeManager> viewer;
    private final String viewerName;
    private final Coordinate viewerOrigin;
    private final WeakReference<Volume> volume;
    private final int xDim;
    private final int yDim;
    private final int zDim;

    public AnalysisPointImpl(Coordinate4D coordinate, double value, VolumeManager viewer, Volume volume, String description, String type) {
        this.viewer = new WeakReference<VolumeManager>(viewer);
        this.coordinate = coordinate;
        this.description = this.makeDescription(description, volume);
        this.type = type;
        this.value = value;
        this.viewerOrigin = viewer.getOrigin();
        this.sizeX = viewer.getBaseVolume().getXSize();
        this.sizeY = viewer.getBaseVolume().getYSize();
        this.sizeZ = viewer.getBaseVolume().getZSize();
        this.xDim = viewer.getBaseVolume().getXDim();
        this.yDim = viewer.getBaseVolume().getYDim();
        this.zDim = viewer.getBaseVolume().getZDim();
        this.viewerName = viewer.toString();
        if (volume != null) {
            this.volume = new WeakReference<Volume>(volume);
            this.name = viewer.getName((ImageVolume)volume);
        } else {
            this.volume = null;
            this.name = null;
        }
        Atlas atlas = Mango.getInstance().getCurrentAtlas();
        if (atlas != null && Mango.getInstance().isWorldMode()) {
            Coordinate coor = new Coordinate((Coordinate)coordinate);
            viewer.convertIndexToWorldCoordinate(coor);
            this.labels = atlas.getLabel(coor.xDbl, coor.yDbl, coor.zDbl);
            this.labels = Arrays.copyOf(atlas.getLabel(coor.xDbl, coor.yDbl, coor.zDbl), this.labels.length);
        } else {
            this.labels = null;
        }
        this.roi = -1;
    }

    private String makeDescription(String des, Volume vol) {
        String seriesLabel = "";
        String label = des;
        if (this.coordinate != null && vol != null && vol.isInitialized() && vol.getNumTimepoints() > 1) {
            seriesLabel = vol.getLabel(this.coordinate.getSeriesPoint(), SeriesDefaultLabels.getDefaultLabel(this.coordinate.getSeriesPoint(), vol));
        }
        if (StringUtils.isNotBlank((CharSequence)seriesLabel)) {
            label = label + " (" + seriesLabel + ")";
        }
        return label;
    }

    public Color getColor() {
        return this.color;
    }

    public Coordinate4D getCoordinate() {
        return this.coordinate;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public String getName() {
        return this.name;
    }

    public int getROI() {
        return this.roi;
    }

    @Override
    public double getSizeX() {
        return this.sizeX;
    }

    @Override
    public double getSizeY() {
        return this.sizeY;
    }

    @Override
    public double getSizeZ() {
        return this.sizeZ;
    }

    public String getType() {
        return this.type;
    }

    public double getValue() {
        return this.value;
    }

    public VolumeManager getViewer() {
        return (VolumeManager)this.viewer.get();
    }

    public String getViewerName() {
        return this.viewerName;
    }

    @Override
    public Coordinate getViewerOrigin() {
        return this.viewerOrigin;
    }

    @Override
    public Volume getVolume() {
        if (this.volume == null) {
            return null;
        }
        return (Volume)this.volume.get();
    }

    @Override
    public int getXDim() {
        return this.xDim;
    }

    @Override
    public int getYDim() {
        return this.yDim;
    }

    @Override
    public int getZDim() {
        return this.zDim;
    }

    @Override
    public boolean isAddBorder() {
        return this.addBorder;
    }

    @Override
    public boolean isDisplayGotoButton() {
        return !this.isViewerClosed();
    }

    public boolean isViewerClosed() {
        VolumeManager msv = (VolumeManager)this.viewer.get();
        if (msv == null) {
            return true;
        }
        if (msv instanceof SliceViewer) {
            return ((SliceViewer)msv).isCleared();
        }
        return true;
    }

    public void setAddBorder(boolean addBorder) {
        this.addBorder = addBorder;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setROI(int roi) {
        this.roi = roi;
    }
}

