/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.components.MangoMultiComboBox;
import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.volume.ImageVolume;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;

public class VolumeInput
extends AbstractInput {
    private static final long serialVersionUID = 1L;
    private MangoComboBox<ImageVolume> selectBox;
    private MangoMultiComboBox<ImageVolume> multiSelectBox;
    private final VolumeManager manager;
    private final boolean multiple;
    private final boolean overlaysOnly;

    public VolumeInput(String name, VolumeManager manager, boolean multiple, boolean overlaysOnly) {
        super(name);
        this.manager = manager;
        this.multiple = multiple;
        this.overlaysOnly = overlaysOnly;
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String question = StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        List volumes = this.overlaysOnly ? this.manager.getOverlays() : this.manager.getVolumes();
        question = question + " [option: " + StringUtils.join((Iterable)volumes, (String)", ") + "]?";
        this.ask(question);
    }

    private void createGUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel(StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName()) + ": "));
        List volumes = this.overlaysOnly ? this.manager.getOverlays() : this.manager.getVolumes();
        if (this.multiple) {
            this.multiSelectBox = new MangoMultiComboBox();
            for (ImageVolume vol : volumes) {
                this.multiSelectBox.addItem(vol);
            }
            this.add(this.multiSelectBox);
        } else {
            this.selectBox = new MangoComboBox<ImageVolume>((T[])volumes.toArray(new ImageVolume[volumes.size()]));
            this.add(this.selectBox);
        }
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            List volumes = null;
            volumes = this.overlaysOnly ? this.manager.getOverlays() : this.manager.getVolumes();
            ArrayList<String> volumeStrings = new ArrayList<String>();
            for (ImageVolume volume : volumes) {
                volumeStrings.add(volume.toString());
            }
            while (!volumeStrings.contains(line.trim())) {
                this.createCLI();
                line = sc.nextLine();
            }
            sc.close();
            String str = line.trim();
            for (ImageVolume volume : volumes) {
                if (!str.equals(volume.toString())) continue;
                return volume;
            }
            return volumes.get(0);
        }
        if (this.multiple) {
            return this.multiSelectBox.getAllSelected();
        }
        return this.selectBox.getSelectedItem();
    }
}

