/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.StringUtilities;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.lang3.StringUtils;

public class SliceNumberInput
extends AbstractInput {
    private JSpinner spinner;
    private final int arg;
    private final VolumeManager manager;
    private final boolean useDefaultName;
    private static final long serialVersionUID = 1L;

    public SliceNumberInput(String name, int arg, VolumeManager manager) {
        this(name, arg, manager, true);
    }

    public SliceNumberInput(String name, int arg, VolumeManager manager, boolean useDefaultName) {
        super(name);
        this.arg = arg;
        this.manager = manager;
        this.useDefaultName = useDefaultName;
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String question = StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        question = question + " (default: " + this.arg + ")?";
        this.ask(question);
    }

    private void createGUI() {
        int xDim = this.manager.getBaseVolume().getXDim();
        int yDim = this.manager.getBaseVolume().getYDim();
        int zDim = this.manager.getBaseVolume().getZDim();
        int value = this.arg;
        if (value == -1) {
            value = this.manager.getSliceNumber();
        }
        SpinnerNumberModel model = new SpinnerNumberModel(value, 0, Math.max(Math.max(xDim, yDim), zDim), 1);
        this.spinner = new JSpinner(model);
        this.setLayout(new BoxLayout(this, 0));
        if (this.useDefaultName) {
            this.add(new JLabel("Slice Number: "));
        } else {
            this.add(new JLabel(StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName()) + ": "));
        }
        this.add(this.spinner);
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            sc.close();
            if (!StringUtils.isBlank((CharSequence)line)) {
                String str = line.trim();
                try {
                    return Integer.parseInt(str);
                }
                catch (Exception ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
            return this.arg;
        }
        return this.spinner.getModel().getValue();
    }
}

