/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import java.util.List;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;

public class SliceDirectionInput
extends AbstractInput {
    private MangoComboBox<String> selectBox;
    private final VolumeManager manager;
    private final boolean useDefaultName;
    private final boolean useTime;
    private final int arg;
    private static final List<String> OPTIONS = CollectionUtilities.immutable((String[])new String[]{"Axial", "Coronal", "Sagittal"});
    private static final List<String> OPTIONS_TIME = CollectionUtilities.immutable((String[])new String[]{"Axial", "Coronal", "Sagittal", "Temporal"});
    private static final long serialVersionUID = 1L;

    public SliceDirectionInput(String name, int arg, VolumeManager manager) {
        this(name, arg, manager, true, false);
    }

    public SliceDirectionInput(String name, int arg, VolumeManager manager, boolean useTime) {
        this(name, arg, manager, true, useTime);
    }

    public SliceDirectionInput(String name, int arg, VolumeManager manager, boolean useDefaultName, boolean useTime) {
        super(name);
        this.arg = arg;
        this.manager = manager;
        this.useDefaultName = useDefaultName;
        this.useTime = useTime;
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String question = StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        question = this.useTime ? question + " (default: " + this.arg + ") [options: " + StringUtils.join(OPTIONS_TIME, (String)", ") + "]?" : question + " (default: " + this.arg + ") [options: " + StringUtils.join(OPTIONS, (String)", ") + "]?";
        this.ask(question);
    }

    private void createGUI() {
        this.selectBox = this.useTime ? new MangoComboBox<String>((T[])OPTIONS_TIME.toArray(new String[OPTIONS_TIME.size()])) : new MangoComboBox<String>((T[])OPTIONS.toArray(new String[OPTIONS.size()]));
        if (this.arg == -1) {
            this.selectBox.setSelectedIndex(this.manager.getSliceDirection());
        } else {
            this.selectBox.setSelectedIndex(this.arg);
        }
        this.setLayout(new BoxLayout(this, 0));
        if (this.useDefaultName) {
            this.add(new JLabel("Slice Direction: "));
        } else {
            this.add(new JLabel(StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName()) + ": "));
        }
        this.add(this.selectBox);
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            sc.close();
            while (!OPTIONS.contains(line.trim()) && !StringUtils.isBlank((CharSequence)line)) {
                this.createCLI();
                line = sc.nextLine();
            }
            if (StringUtils.isBlank((CharSequence)line)) {
                return this.arg;
            }
            return OPTIONS_TIME.indexOf(line);
        }
        return this.selectBox.getSelectedIndex();
    }
}

