/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.StringUtilities;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.lang3.StringUtils;

public class SeriesIndexInput
extends AbstractInput {
    private JSpinner spinner;
    private final int arg;
    private final VolumeManager manager;
    private static final long serialVersionUID = 1L;

    public SeriesIndexInput(String name, int arg, VolumeManager manager) {
        super(name);
        this.arg = arg;
        this.manager = manager;
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String question = StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        question = question + " (default: " + this.arg + ")?";
        this.ask(question);
    }

    private void createGUI() {
        int seriesLength = this.manager.getBaseVolume().getSeriesLength();
        int value = this.arg;
        if (value == -1) {
            value = this.manager.getBaseVolume().getCurrentSeriesPoint();
        }
        SpinnerNumberModel model = new SpinnerNumberModel(value + 1, 1, seriesLength, 1);
        this.spinner = new JSpinner(model);
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel(StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName()) + ": "));
        this.add(this.spinner);
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            sc.close();
            if (!StringUtils.isBlank((CharSequence)line)) {
                String str = line.trim();
                try {
                    return Integer.parseInt(str);
                }
                catch (Exception ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
            return this.arg;
        }
        return (Integer)this.spinner.getModel().getValue() - 1;
    }
}

