/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.dialogs.modal.file.SaveFileDialog;
import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;

public class SaveLocationInput
extends AbstractInput
implements ActionListener {
    private MangoTextField text;
    private final String arg;
    private final VolumeManager manager;
    public static final int DEFAULT_SIZE = 16;
    private static final long serialVersionUID = 1L;

    public SaveLocationInput(String name, String arg, VolumeManager manager) {
        super(name);
        this.manager = manager;
        this.arg = arg;
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String ext;
        String dir = FileUtilities.getParent((URI)this.manager.getLoadedURI());
        String name = FileUtilities.removeExtension((String)FileUtilities.getName((URI)this.manager.getLoadedURI()));
        if (StringUtils.isNotBlank((CharSequence)this.arg) && StringUtils.isNotBlank((CharSequence)(ext = FileUtilities.getFullExtension((File)new File(this.arg))))) {
            name = name + '.' + ext;
        }
        String question = StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        question = question + " (default: " + dir + "/" + name + ")?";
        this.ask(question);
    }

    private void createGUI() {
        String ext;
        String dir = FileUtilities.getParent((URI)this.manager.getLoadedURI());
        String name = FileUtilities.removeExtension((String)FileUtilities.getName((URI)this.manager.getLoadedURI()));
        if (StringUtils.isNotBlank((CharSequence)this.arg) && StringUtils.isNotBlank((CharSequence)(ext = FileUtilities.getFullExtension((File)new File(this.arg))))) {
            name = name + '.' + ext;
        }
        this.text = new MangoTextField(dir + "/" + name, 16);
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel(StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName()) + ": "));
        this.add(this.text);
        JButton button = new JButton("Select File...");
        button.addActionListener(this);
        this.add(button);
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            String ext;
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            sc.close();
            if (!StringUtils.isBlank((CharSequence)line)) {
                return line.trim();
            }
            String dir = FileUtilities.getParent((URI)this.manager.getLoadedURI());
            String name = FileUtilities.removeExtension((String)FileUtilities.getName((URI)this.manager.getLoadedURI()));
            if (StringUtils.isNotBlank((CharSequence)this.arg) && StringUtils.isNotBlank((CharSequence)(ext = FileUtilities.getFullExtension((File)new File(this.arg))))) {
                name = name + '.' + ext;
            }
            return dir + "/" + name;
        }
        return this.text.getText();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        File startFile = new File(this.text.getText());
        File file = SaveFileDialog.showSaveFileChooser(null, startFile.getParent(), startFile.getName());
        if (file != null) {
            this.text.setText(file.toString());
        }
    }
}

