/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.components.MangoColorButton;
import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.StringUtilities;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;

public class RoiIndexInput
extends AbstractInput {
    private final VolumeManager manager;
    private MangoColorButton button;
    private final int arg;
    private final boolean useDefaultName;
    private final boolean usedOnly;
    private static final long serialVersionUID = 1L;

    public RoiIndexInput(String name, int arg, VolumeManager manager) {
        super(name);
        this.arg = arg;
        this.manager = manager;
        this.useDefaultName = false;
        this.usedOnly = true;
        this.createUI();
    }

    public RoiIndexInput(String name, int arg, VolumeManager manager, boolean usedOnly) {
        this(name, arg, manager, true, usedOnly);
    }

    public RoiIndexInput(String name, int arg, VolumeManager manager, boolean useDefaultName, boolean usedOnly) {
        super(name);
        this.arg = arg;
        this.manager = manager;
        this.useDefaultName = useDefaultName;
        this.usedOnly = usedOnly;
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String question = StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        question = question + " (default: " + this.arg + ")?";
        this.ask(question);
    }

    private void createGUI() {
        SliceViewer viewer = (SliceViewer)this.manager;
        this.button = new MangoColorButton(viewer, null, this.usedOnly);
        if (this.arg != -1) {
            this.button.setColor(this.arg);
        }
        this.setLayout(new BoxLayout(this, 0));
        if (this.useDefaultName) {
            if (this.usedOnly) {
                this.add(new JLabel("ROI Color: "));
            } else {
                this.add(new JLabel("ROI Output Color: "));
            }
        } else {
            this.add(new JLabel(StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName()) + ": "));
        }
        this.add(this.button);
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            sc.close();
            if (!StringUtils.isBlank((CharSequence)line)) {
                String str = line.trim();
                try {
                    return Integer.parseInt(str);
                }
                catch (Exception ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
            return this.arg;
        }
        return this.button.getColor();
    }
}

