/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoSquareButton;
import edu.uthscsa.ric.mango.components.menus.MangoSquareMenu;
import edu.uthscsa.ric.mango.components.menus.MangoSquareMenuItem;
import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.mango.window.Toolbox;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.lang3.StringUtils;

public class RoiEditToolInput
extends AbstractInput
implements ActionListener,
PopupMenuListener {
    private static final long serialVersionUID = 1L;
    private AbstractButton roiEditButton;
    private JPopupMenu popupROIEditFirst;
    private long popupROIEditTimeCanceledFirst;
    private int arg;
    public static final List<String> NAMES = CollectionUtilities.immutable((String[])new String[]{"Nav", "Edit", "Erase", "Paint", "Trace", "Line", "Point", "Add"});
    public static final List<Integer> CODES = CollectionUtilities.immutable((Integer[])new Integer[]{0, 1, 2, 3, 9, 10, 11, 12});

    public RoiEditToolInput(String name, int arg) {
        super(name);
        this.arg = arg;
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String question = StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        question = question + " [options: " + StringUtils.join(NAMES, (String)", ") + "]?";
        this.ask(question);
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            while (!NAMES.contains(line.trim())) {
                this.createCLI();
                line = sc.nextLine();
            }
            sc.close();
            return CODES.get(NAMES.indexOf(line));
        }
        Icon icon = this.roiEditButton.getIcon();
        for (int ctr = 0; ctr < MangoStyle.ICON_EDIT_ROI.size(); ++ctr) {
            if (icon != MangoStyle.ICON_EDIT_ROI.get(ctr)) continue;
            return ctr;
        }
        return 0;
    }

    private void createGUI() {
        this.makeROIEditPopupMenu();
        if (this.arg == -1) {
            this.arg = Mango.getInstance().getToolBox().getROIEditMode();
        }
        this.roiEditButton = new MangoSquareButton(MangoStyle.ICON_EDIT_ROI.get(this.arg), false, null);
        this.roiEditButton.setActionCommand("roiEditButtonToggleFirst");
        this.roiEditButton.addActionListener(this);
        this.roiEditButton.setPreferredSize(new Dimension(35, 35));
        this.roiEditButton.setMinimumSize(this.roiEditButton.getPreferredSize());
        this.roiEditButton.setMaximumSize(this.roiEditButton.getPreferredSize());
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel(StringUtils.isNotBlank((CharSequence)this.getName()) ? this.getName() + ": " : "ROI Tool: "));
        this.add(this.roiEditButton);
    }

    private void makeROIEditPopupMenu() {
        final MangoSquareMenu subMenuEdit = new MangoSquareMenu(MangoStyle.ICON_EDIT_ROI.get(1));
        subMenuEdit.setPreferredSize(new Dimension(30, 30));
        subMenuEdit.setBackground(Toolbox.POPUP_MENU_ITEM_COLOR);
        subMenuEdit.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                RoiEditToolInput.this.roiEditButton.setIcon(MangoStyle.ICON_EDIT_ROI.get(1));
                subMenuEdit.getPopupMenu().setVisible(false);
                RoiEditToolInput.this.popupROIEditFirst.setVisible(false);
            }
        });
        final MangoSquareMenu subMenuRectangle = new MangoSquareMenu(MangoStyle.ICON_EDIT_ROI.get(7));
        subMenuRectangle.setPreferredSize(new Dimension(30, 30));
        subMenuRectangle.setBackground(Toolbox.POPUP_MENU_ITEM_COLOR);
        subMenuRectangle.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                RoiEditToolInput.this.roiEditButton.setIcon(MangoStyle.ICON_EDIT_ROI.get(7));
                subMenuRectangle.getPopupMenu().setVisible(false);
                RoiEditToolInput.this.popupROIEditFirst.setVisible(false);
            }
        });
        final MangoSquareMenu subMenuMagicWand = new MangoSquareMenu(MangoStyle.ICON_EDIT_ROI.get(12));
        subMenuMagicWand.setPreferredSize(new Dimension(30, 30));
        subMenuMagicWand.setBackground(Toolbox.POPUP_MENU_ITEM_COLOR);
        subMenuMagicWand.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                RoiEditToolInput.this.roiEditButton.setIcon(MangoStyle.ICON_EDIT_ROI.get(12));
                subMenuMagicWand.getPopupMenu().setVisible(false);
                RoiEditToolInput.this.popupROIEditFirst.setVisible(false);
            }
        });
        this.popupROIEditFirst = new JPopupMenu();
        for (int ctr = 0; ctr < MangoStyle.ICON_EDIT_ROI.size(); ++ctr) {
            MangoSquareMenuItem mi = new MangoSquareMenuItem(MangoStyle.ICON_EDIT_ROI.get(ctr));
            mi.setPreferredSize(new Dimension(30, 30));
            mi.setBackground(Toolbox.POPUP_MENU_ITEM_COLOR);
            mi.setContentAreaFilled(true);
            mi.setActionCommand("roiEditButtonChosenFirst" + ctr);
            mi.addActionListener(this);
            if (ctr == 1) {
                this.popupROIEditFirst.add(subMenuEdit);
            } else if (ctr == 7) {
                this.popupROIEditFirst.add(subMenuRectangle);
            } else if (ctr == 12) {
                this.popupROIEditFirst.add(subMenuMagicWand);
            } else {
                this.popupROIEditFirst.add(mi);
            }
            if (ctr >= 2 && ctr <= 6) {
                subMenuEdit.add(mi);
            } else if (ctr >= 8 && ctr <= 11) {
                subMenuRectangle.add(mi);
            } else if (ctr >= 13) {
                subMenuMagicWand.add(mi);
            }
            this.popupROIEditFirst.addPopupMenuListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        long timeSinceCancel;
        String command = ae.getActionCommand();
        if (command.indexOf("roiEditButtonChosenFirst") != -1) {
            this.roiEditButton.setIcon(MangoStyle.ICON_EDIT_ROI.get(Integer.parseInt(ae.getActionCommand().substring(24))));
        } else if (command.equals("roiEditButtonToggleFirst") && (timeSinceCancel = new Date().getTime() - this.popupROIEditTimeCanceledFirst) > 250L) {
            this.popupROIEditFirst.show(this.roiEditButton, 2, 35);
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent pme) {
        if (pme.getSource() == this.popupROIEditFirst) {
            this.popupROIEditTimeCanceledFirst = new Date().getTime();
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
    }
}

