/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.MangoContext;
import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.StringUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;

public class OpenVolumeManagerInput
extends AbstractInput {
    private static final long serialVersionUID = 1L;
    private MangoComboBox<VolumeManager> selectBox;
    private final List<VolumeManager> allOtherManagers;

    public OpenVolumeManagerInput(String name, MangoContext context, VolumeManager originatingManager) {
        super(name);
        this.allOtherManagers = context.getOtherVolumeManagers(originatingManager);
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String question = StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        question = question + " [options: " + StringUtils.join(this.allOtherManagers, (String)", ") + "]?";
        this.ask(question);
    }

    private void createGUI() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel(StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName()) + ": "));
        this.selectBox = new MangoComboBox<VolumeManager>((T[])this.allOtherManagers.toArray(new VolumeManager[this.allOtherManagers.size()]));
        this.add(this.selectBox);
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            ArrayList<String> allOtherVolumeStrings = new ArrayList<String>();
            for (VolumeManager manager : this.allOtherManagers) {
                allOtherVolumeStrings.add(manager.toString());
            }
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            while (!allOtherVolumeStrings.contains(line.trim())) {
                this.createCLI();
                line = sc.nextLine();
            }
            sc.close();
            String str = line.trim();
            for (VolumeManager manager : this.allOtherManagers) {
                if (!str.equals(manager.toString())) continue;
                return manager;
            }
            return this.allOtherManagers.get(0);
        }
        return this.selectBox.getSelectedItem();
    }
}

