/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.StringUtilities;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.lang3.StringUtils;

public class KernelSizeInput
extends AbstractInput {
    private JSpinner spinner;
    private final int arg;
    public static final int MIN_SIZE = 3;
    public static final int MAX_SIZE = 15;
    private static final long serialVersionUID = 1L;

    public KernelSizeInput(String name, int arg) {
        super(name);
        this.arg = arg;
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String question = StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        question = question + " (default: " + this.arg + ")?";
        this.ask(question);
    }

    private void createGUI() {
        int value = Math.max(this.arg, 3);
        value = Math.min(value, 15);
        SpinnerNumberModel model = new SpinnerNumberModel(value, 3, 15, 2);
        this.spinner = new JSpinner(model);
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel("Kernel Size: "));
        this.add(this.spinner);
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            sc.close();
            if (!StringUtils.isBlank((CharSequence)line)) {
                String str = line.trim();
                try {
                    int val = Integer.parseInt(str);
                    if (val % 2 != 0) {
                        return val;
                    }
                    return val + 1;
                }
                catch (Exception ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
            return this.arg;
        }
        return this.spinner.getModel().getValue();
    }
}

