/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.StringUtilities;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;

public class IntegerInput
extends AbstractInput {
    private MangoTextField text;
    private final int arg;
    public static final int DEFAULT_SIZE = 6;
    private static final long serialVersionUID = 1L;

    public IntegerInput(String name, int arg) {
        super(name);
        this.arg = arg;
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String question = StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        question = question + " (default: " + this.arg + ")?";
        this.ask(question);
    }

    private void createGUI() {
        this.text = new MangoTextField(String.valueOf(this.arg), 6);
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel(StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName()) + ": "));
        this.add(this.text);
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            sc.close();
            if (!StringUtils.isBlank((CharSequence)line)) {
                String str = line.trim();
                try {
                    return Integer.parseInt(str);
                }
                catch (Exception ex) {
                    AppLogger.warn((Throwable)ex);
                }
            }
            return this.arg;
        }
        String str = this.text.getText();
        int value = 0;
        try {
            value = Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            AppLogger.warn((Throwable)ex);
        }
        return value;
    }
}

