/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script.input;

import edu.uthscsa.ric.mango.dialogs.script.ScriptUtils;
import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.utilities.StringUtilities;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import org.apache.commons.lang3.StringUtils;

public class BooleanInput
extends AbstractInput {
    private JCheckBox checkbox;
    private JRadioButton falseButton;
    private JRadioButton trueButton;
    private final boolean arg;
    private static final long serialVersionUID = 1L;

    public BooleanInput(String name, boolean arg) {
        super(name);
        this.arg = arg;
        this.createUI();
    }

    private void createUI() {
        if (this.isHeadless()) {
            this.createCLI();
        } else {
            this.createGUI();
        }
    }

    private void createCLI() {
        String name = this.getName();
        String question = "";
        question = name.indexOf(47) != -1 ? StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)name.substring(name.indexOf(47) + 1)) : StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName());
        question = question + " (default: " + ScriptUtils.convertBoolean(this.arg) + ")?";
        this.ask(question);
    }

    private void createGUI() {
        String name = this.getName();
        this.setLayout(new BoxLayout(this, 0));
        if (name.indexOf(47) != -1) {
            String nameFalse = name.substring(0, name.indexOf(47));
            String nameTrue = name.substring(name.indexOf(47) + 1);
            this.falseButton = new JRadioButton(StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)nameFalse));
            this.trueButton = new JRadioButton(StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)nameTrue));
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.falseButton);
            bg.add(this.trueButton);
            this.falseButton.setSelected(true);
            this.add(this.falseButton);
            this.add(this.trueButton);
            if (this.arg) {
                this.trueButton.setSelected(true);
            }
        } else {
            this.checkbox = new JCheckBox(StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)this.getName()));
            this.add(this.checkbox);
            this.checkbox.setSelected(this.arg);
        }
    }

    @Override
    public Object getResult() {
        if (this.isHeadless()) {
            Scanner sc = new Scanner(System.in);
            String line = sc.nextLine();
            sc.close();
            if (!StringUtils.isBlank((CharSequence)line)) {
                return Boolean.parseBoolean(line.trim());
            }
            return this.arg;
        }
        if (this.checkbox != null) {
            return this.checkbox.isSelected();
        }
        return this.trueButton.isSelected();
    }
}

