/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.script;

import edu.uthscsa.ric.cli.ParameterNameAnnotation;
import edu.uthscsa.ric.mango.MangoContext;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPane;
import edu.uthscsa.ric.mango.dialogs.script.input.AbstractInput;
import edu.uthscsa.ric.mango.dialogs.script.input.BooleanInput;
import edu.uthscsa.ric.mango.dialogs.script.input.ColorInput;
import edu.uthscsa.ric.mango.dialogs.script.input.CoordinateInput;
import edu.uthscsa.ric.mango.dialogs.script.input.FloatInput;
import edu.uthscsa.ric.mango.dialogs.script.input.IntegerInput;
import edu.uthscsa.ric.mango.dialogs.script.input.KernelSizeInput;
import edu.uthscsa.ric.mango.dialogs.script.input.MultiInput;
import edu.uthscsa.ric.mango.dialogs.script.input.OpenLocationInput;
import edu.uthscsa.ric.mango.dialogs.script.input.OpenVolumeManagerInput;
import edu.uthscsa.ric.mango.dialogs.script.input.OptionInput;
import edu.uthscsa.ric.mango.dialogs.script.input.OrientationInput;
import edu.uthscsa.ric.mango.dialogs.script.input.RoiEditToolInput;
import edu.uthscsa.ric.mango.dialogs.script.input.RoiIndexInput;
import edu.uthscsa.ric.mango.dialogs.script.input.RoiMaskInput;
import edu.uthscsa.ric.mango.dialogs.script.input.RotationAxisInput;
import edu.uthscsa.ric.mango.dialogs.script.input.SaveLocationInput;
import edu.uthscsa.ric.mango.dialogs.script.input.SeriesIndexInput;
import edu.uthscsa.ric.mango.dialogs.script.input.SliceDirectionInput;
import edu.uthscsa.ric.mango.dialogs.script.input.SliceNumberInput;
import edu.uthscsa.ric.mango.dialogs.script.input.StringInput;
import edu.uthscsa.ric.mango.dialogs.script.input.SurfaceInput;
import edu.uthscsa.ric.mango.dialogs.script.input.SurfaceShapeInput;
import edu.uthscsa.ric.mango.dialogs.script.input.VolumeInput;
import edu.uthscsa.ric.mango.viewerslice.VolumeManager;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.StringUtilities;
import edu.uthscsa.ric.volume.Coordinate;
import java.awt.Frame;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class UserInput {
    public static final String NONE = "None";
    static final List<String> INPUTS_SIGNATURES = new ArrayList<String>();
    static final List<String> INPUT_FUNCTIONS = new ArrayList<String>();
    public static final String BOOLEAN_INPUT_FUNC;
    public static final String BOOLEAN_INPUT_SIG = "getBoolean(name, default)";
    public static final String DEF = "def ";
    public static final String FLOAT_INPUT_FUNC;
    public static final String FLOAT_INPUT_SIG = "getFloat(name, default)";
    public static final String FUNC_END = "  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
    public static final String IMPORT;
    public static final String INPUT_FUNC;
    public static final String INPUT_SIG = "getMultiInput(manager, title, names, types, args)";
    public static final String INTEGER_INPUT_FUNC;
    public static final String INTEGER_INPUT_SIG = "getInteger(name, default)";
    public static final String STRING_INPUT_FUNC;
    public static final String STRING_INPUT_SIG = "getString(name, default)";
    public static final String COLOR_INPUT_FUNC;
    public static final String COLOR_INPUT_SIG = "getColor(name, default)";
    public static final String COORD_INPUT_FUNC;
    public static final String COORD_INPUT_SIG = "getCoordinate(manager, name, default)";
    public static final String KERNEL_INPUT_FUNC;
    public static final String KERNEL_INPUT_SIG = "getKernelSize(name, default)";
    public static final String OPEN_LOC_INPUT_FUNC;
    public static final String OPEN_LOC_INPUT_SIG = "getOpenLocation(manager, name, default)";
    public static final String SELECT_VOLMAN_INPUT_FUNC;
    public static final String SELECT_VOLMAN_INPUT_SIG = "getVolumeManager(mango, manager, name)";
    public static final String SELECT_LIST_INPUT_FUNC;
    public static final String SELECT_LIST_INPUT_SIG = "getListItem(name, list, default)";
    public static final String SELECT_MAP_INPUT_FUNC;
    public static final String SELECT_MAP_INPUT_SIG = "getMapValue(name, dict, default)";
    public static final String SELECT_ORIENTATION_INPUT_FUNC;
    public static final String SELECT_ORIENTATION_INPUT_SIG = "getOrientation(name, default)";
    public static final String SELECT_ROI_INDEX_INPUT_FUNC;
    public static final String SELECT_ROI_INDEX_INPUT_SIG = "getRoiColorIndex(manager, name, default)";
    public static final String SELECT_ROI_MASK_INPUT_FUNC;
    public static final String SELECT_ROI_MASK_INPUT_SIG = "getRoiMask(manager, name, default)";
    public static final String SELECT_SLICE_DIR_INPUT_FUNC;
    public static final String SELECT_SLICE_DIR_INPUT_SIG = "getSliceDirection(manager, name, default)";
    public static final String SELECT_ROT_AXIS_INPUT_FUNC;
    public static final String SELECT_ROT_AXIS_INPUT_SIG = "getRotationAxis(manager, name, default)";
    public static final String SELECT_SAVE_LOC_INPUT_FUNC;
    public static final String SELECT_SAVE_LOC_INPUT_SIG = "getSaveLocation(manager, name, default)";
    public static final String SELECT_SERIES_POINT_INPUT_FUNC;
    public static final String SELECT_SERIES_POINT_INPUT_SIG = "getSeriesPoint(manager, name, default)";
    public static final String SELECT_SLICE_NUMBER_INPUT_FUNC;
    public static final String SELECT_SLICE_NUMBER_INPUT_SIG = "getSliceNumber(manager, name, default)";
    public static final String SELECT_SURFACE_INPUT_FUNC;
    public static final String SELECT_SURFACE_INPUT_SIG = "getSurface(manager, name)";
    public static final String SELECT_SURFACE_SHAPE_INPUT_FUNC;
    public static final String SELECT_SURFACE_SHAPE_INPUT_SIG = "getSurfaceShape(manager, name)";
    public static final String SELECT_VOL_INPUT_FUNC;
    public static final String SELECT_VOL_INPUT_SIG = "getVolume(manager, name)";
    public static final String SELECT_OVLY_INPUT_FUNC;
    public static final String SELECT_OVLY_INPUT_SIG = "getOverlay(manager, name)";
    public static final String SELECT_OVLYS_INPUT_FUNC;
    public static final String SELECT_OVLYS_INPUT_SIG = "getOverlays(manager, name)";
    public static final String SELECT_TOOL_INPUT_FUNC;
    public static final String SELECT_TOOL_INPUT_SIG = "getTool(name, default)";
    public static final String SELECT_DIR_INPUT_FUNC;
    public static final String SELECT_DIR_INPUT_SIG = "getDirection(manager, name, default)";

    private UserInput() {
    }

    public static Object getBooleanInput(String name, boolean arg) {
        BooleanInput gui = new BooleanInput(name, arg);
        return UserInput.getInput(gui);
    }

    public static Object getToolInput(String name, int arg) {
        RoiEditToolInput gui = new RoiEditToolInput(name, arg);
        return UserInput.getInput(gui);
    }

    public static Object getVolumeInput(String name, VolumeManager manager) {
        VolumeInput gui = new VolumeInput(name, manager, false, false);
        return UserInput.getInput(gui);
    }

    public static Object getOverlayInput(String name, VolumeManager manager) {
        VolumeInput gui = new VolumeInput(name, manager, false, true);
        return UserInput.getInput(gui);
    }

    public static Object getOverlaysInput(String name, VolumeManager manager) {
        VolumeInput gui = new VolumeInput(name, manager, true, true);
        return UserInput.getInput(gui);
    }

    public static Object getSurfaceInput(String name, VolumeManager manager) {
        SurfaceInput gui = new SurfaceInput(name, manager);
        return UserInput.getInput(gui);
    }

    public static Object getSurfaceShapeInput(String name, VolumeManager manager) {
        SurfaceShapeInput gui = new SurfaceShapeInput(name, manager);
        return UserInput.getInput(gui);
    }

    public static Object getSeriesPointInput(String name, int arg, VolumeManager manager) {
        SeriesIndexInput gui = new SeriesIndexInput(name, arg, manager);
        return UserInput.getInput(gui);
    }

    public static Object getRotationAxisInput(String name, int arg, VolumeManager manager) {
        RotationAxisInput gui = new RotationAxisInput(name, arg, manager);
        return UserInput.getInput(gui);
    }

    public static Object getRoiColorIndex(String name, int arg, VolumeManager manager) {
        RoiIndexInput gui = new RoiIndexInput(name, arg, manager);
        return UserInput.getInput(gui);
    }

    public static Object getOrientationInput(String name, String arg) {
        OrientationInput gui = new OrientationInput(name, arg);
        return UserInput.getInput(gui);
    }

    public static Object getOptionList(String name, List<?> list, Object arg) {
        OptionInput gui = new OptionInput(name, list, arg);
        return UserInput.getInput(gui);
    }

    public static Object getOptionMap(String name, Map<?, ?> map, Object arg) {
        OptionInput gui = new OptionInput(name, map, arg);
        return UserInput.getInput(gui);
    }

    public static Object getVolumeManagerInput(String name, MangoContext ctx, VolumeManager manager) {
        OpenVolumeManagerInput gui = new OpenVolumeManagerInput(name, ctx, manager);
        return UserInput.getInput(gui);
    }

    public static Object getOpenLocationInput(String name, String arg, VolumeManager manager) {
        OpenLocationInput gui = new OpenLocationInput(name, arg, manager);
        return UserInput.getInput(gui);
    }

    public static Object getSaveLocationInput(String name, String arg, VolumeManager manager) {
        SaveLocationInput gui = new SaveLocationInput(name, arg, manager);
        return UserInput.getInput(gui);
    }

    public static Object getKernelSizeInput(String name, int arg) {
        KernelSizeInput gui = new KernelSizeInput(name, arg);
        return UserInput.getInput(gui);
    }

    public static Object getCoordinateInput(String name, Coordinate arg, VolumeManager manager) {
        CoordinateInput gui = new CoordinateInput(name, arg, manager);
        return UserInput.getInput(gui);
    }

    public static Object getColorInput(String name, int arg) {
        ColorInput gui = new ColorInput(name, arg);
        return UserInput.getInput(gui);
    }

    public static Object getFloatInput(String name, double arg) {
        FloatInput gui = new FloatInput(name, arg);
        return UserInput.getInput(gui);
    }

    public static Iterable<Object> getInput(VolumeManager manager, String title, List<String> names, List<String> types, List<Object> args) {
        boolean headless = Boolean.getBoolean("java.awt.headless");
        MultiInput gui = new MultiInput(manager, title, names, types, args, headless);
        gui.createInputs();
        if (headless) {
            Iterable<Object> results = gui.getResultHeadless();
            return results;
        }
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane((Frame)null, (Object)gui, StringUtilities.makeHumanReadableDescriptionFromCamelCase((String)title), -1);
        int result = jopf.show();
        if (result == 0) {
            return gui.getResult();
        }
        return null;
    }

    public static Object getIntegerInput(String name, int arg) {
        IntegerInput gui = new IntegerInput(name, arg);
        return UserInput.getInput(gui);
    }

    public static Object getKernelInput(String name, int arg) {
        KernelSizeInput gui = new KernelSizeInput(name, arg);
        return UserInput.getInput(gui);
    }

    public static Object getOptionInput(String name, List<Object> list, Object obj) {
        OptionInput gui = new OptionInput(name, list, obj);
        return UserInput.getInput(gui);
    }

    public static Object getOptionInput(String name, Map<Object, Object> map, Object obj) {
        OptionInput gui = new OptionInput(name, map, obj);
        return UserInput.getInput(gui);
    }

    public static Object getRoiIndexInput(String name, int arg, VolumeManager manager) {
        RoiIndexInput gui = new RoiIndexInput(name, arg, manager, false);
        return UserInput.getInput(gui);
    }

    public static Object getRoiMaskInput(String name, long arg, VolumeManager manager) {
        RoiMaskInput gui = new RoiMaskInput(name, arg, manager, false);
        if (gui.isHeadless()) {
            return gui.getResult();
        }
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane((Frame)null, (Object)gui, null, -1);
        gui.setDialog(jopf.getJDialog());
        int result = jopf.show();
        if (result == 0) {
            return gui.getResult();
        }
        return null;
    }

    public static Object getSliceDirInput(String name, int arg, VolumeManager manager) {
        SliceDirectionInput gui = new SliceDirectionInput(name, arg, manager, false, false);
        return UserInput.getInput(gui);
    }

    public static Object getDirectionInput(String name, int arg, VolumeManager manager) {
        SliceDirectionInput gui = new SliceDirectionInput(name, arg, manager, false, true);
        return UserInput.getInput(gui);
    }

    public static Object getSliceNumInput(String name, int arg, VolumeManager manager) {
        SliceNumberInput gui = new SliceNumberInput(name, arg, manager, false);
        return UserInput.getInput(gui);
    }

    public static Object getStringInput(String name, String arg) {
        StringInput gui = new StringInput(name, arg);
        return UserInput.getInput(gui);
    }

    public static String makeUserInputString(VolumeManager manager, Method method, String[] args, boolean forceNeedsUserInput, boolean forceNoDialogs) {
        StringBuffer sb = new StringBuffer(32);
        Object[] types = method.getParameterTypes();
        if (ArrayUtils.isNotEmpty((Object[])types)) {
            ParameterNameAnnotation pna;
            ParameterNameAnnotation annotation;
            String[] names = null;
            if (method.isAnnotationPresent(ParameterNameAnnotation.class) && (annotation = method.getAnnotation(ParameterNameAnnotation.class)) != null && types.length != (names = (pna = annotation).names()).length) {
                AppLogger.warn((String)("Number of args does not match number of parameter names:" + method.toGenericString()));
                names = null;
            }
            if (names == null) {
                return null;
            }
            Object[] typeStrings = new String[types.length];
            for (int ctr = 0; ctr < types.length; ++ctr) {
                typeStrings[ctr] = types[ctr] == Boolean.TYPE ? "'" + MultiInput.TYPE_BOOLEAN + "'" : (types[ctr] == Short.TYPE ? "'" + MultiInput.TYPE_SHORT + "'" : (types[ctr] == Integer.TYPE ? "'" + MultiInput.TYPE_INTEGER + "'" : (types[ctr] == Long.TYPE ? "'" + MultiInput.TYPE_LONG + "'" : (types[ctr] == Float.TYPE ? "'" + MultiInput.TYPE_FLOAT + "'" : (types[ctr] == Double.TYPE ? "'" + MultiInput.TYPE_DOUBLE + "'" : (types[ctr] == String.class ? "'string'" : "'" + ((Class)types[ctr]).getName() + "'"))))));
            }
            Object[] nameStrings = new String[names.length];
            for (int ctr = 0; ctr < names.length; ++ctr) {
                String name = names[ctr];
                nameStrings[ctr] = "'" + name + "'";
            }
            if (CollectionUtilities.isEmpty((Object)args)) {
                sb.append("*getMultiInput(" + (manager != null ? manager.getScriptObjectName() : NONE) + ",'" + method.getName() + "',[" + StringUtils.join((Object[])nameStrings, (char)',') + "],[" + StringUtils.join((Object[])typeStrings, (char)',') + "])");
            } else {
                boolean needsUserInput = forceNeedsUserInput && !forceNoDialogs;
                for (int ctr = 0; ctr < args.length; ++ctr) {
                    if (forceNoDialogs) {
                        if (names[ctr].equals("overlay")) {
                            args[ctr] = manager.getScriptObjectName() + ".overlays[-1]";
                            continue;
                        }
                        if (names[ctr].equals("overlays")) {
                            args[ctr] = manager.getScriptObjectName() + ".overlays";
                            continue;
                        }
                        if (names[ctr].equals("volume")) {
                            args[ctr] = manager.getScriptObjectName() + ".volumes[-1]";
                            continue;
                        }
                        if (names[ctr].equals("line")) {
                            args[ctr] = manager.getScriptObjectName() + ".roiData.usedLines" + "[-1]";
                            continue;
                        }
                        if (names[ctr].equals("roi")) {
                            args[ctr] = manager.getScriptObjectName() + ".roiData.allROIs" + "[-1]";
                            continue;
                        }
                        if (names[ctr].equals("manager")) {
                            args[ctr] = "m_Mango_mango.getOtherVolumeManagers(" + manager.getScriptObjectName() + ")[-1]";
                            continue;
                        }
                        if (names[ctr].equals("surface")) {
                            args[ctr] = manager.getScriptObjectName() + ".surfaceManager" + ".surfaces[-1]";
                            continue;
                        }
                        if (names[ctr].equals("surfaces")) {
                            args[ctr] = NONE;
                            continue;
                        }
                        if (names[ctr].equals("shape") || names[ctr].equals("fromShape")) {
                            args[ctr] = manager.getScriptObjectName() + ".surfaceManager" + ".allPointsAndLines[-1]";
                            continue;
                        }
                        if (names[ctr].equals("shape") || names[ctr].equals("toShape")) {
                            args[ctr] = manager.getScriptObjectName() + ".surfaceManager" + ".allPointsAndLines[-2]";
                            continue;
                        }
                        if (names[ctr].equals("fromPoint")) {
                            args[ctr] = manager.getScriptObjectName() + ".surfaceManager" + ".points[-1]";
                            continue;
                        }
                        if (names[ctr].equals("toPoint")) {
                            args[ctr] = manager.getScriptObjectName() + ".surfaceManager" + ".points[-2]";
                            continue;
                        }
                        if (!StringUtils.isBlank((CharSequence)args[ctr]) || !names[ctr].equals("coordinate")) continue;
                        args[ctr] = manager.getScriptObjectName() + ".currentPosition";
                        continue;
                    }
                    if (!StringUtils.isEmpty((CharSequence)args[ctr])) continue;
                    args[ctr] = NONE;
                    needsUserInput |= true;
                }
                if (needsUserInput) {
                    sb.append("*getMultiInput(" + (manager != null ? manager.getScriptObjectName() : NONE) + ",'" + method.getName() + "',[" + StringUtils.join((Object[])nameStrings, (char)',') + "],[" + StringUtils.join((Object[])typeStrings, (char)',') + "],[" + StringUtils.join((Object[])args, (char)',') + "])");
                } else {
                    sb.append(StringUtils.join((Object[])args, (char)','));
                }
            }
        }
        return sb.toString();
    }

    protected static Object getInput(AbstractInput gui) {
        if (gui.isHeadless()) {
            return gui.getResult();
        }
        MangoFocusableOptionPane jopf = new MangoFocusableOptionPane((Frame)null, (Object)gui, null, -1);
        int result = jopf.show();
        if (result == 0) {
            return gui.getResult();
        }
        return null;
    }

    static {
        IMPORT = "import sys\nfrom " + UserInput.class.getPackage().getName() + " import " + UserInput.class.getSimpleName() + "\n";
        BOOLEAN_INPUT_FUNC = "def getBoolean(name, default=False):\n  result = UserInput.getBooleanInput(name, default)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        FLOAT_INPUT_FUNC = "def getFloat(name, default=0.0):\n  result = UserInput.getFloatInput(name, default)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        INPUT_FUNC = "def getMultiInput(manager, title, names, types, args=None):\n  result = UserInput.getInput(manager, title, names, types, args)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        INTEGER_INPUT_FUNC = "def getInteger(name, default=0):\n  result = UserInput.getIntegerInput(name, default)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        STRING_INPUT_FUNC = "def getString(name, default=''):\n  result = UserInput.getStringInput(name, default)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        COLOR_INPUT_FUNC = "def getColor(name, default=''):\n  result = UserInput.getColorInput(name, default)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        COORD_INPUT_FUNC = "def getCoordinate(manager, name, default=''):\n  result = UserInput.getCoordinateInput(name, default, manager)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        KERNEL_INPUT_FUNC = "def getKernelSize(name, default=''):\n  result = UserInput.getKernelSizeInput(name, default)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        OPEN_LOC_INPUT_FUNC = "def getOpenLocation(manager, name, default=''):\n  result = UserInput.getOpenLocationInput(name, default, manager)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        SELECT_VOLMAN_INPUT_FUNC = "def getVolumeManager(mango, manager, name):\n  result = UserInput.getVolumeManagerInput(name, mango, manager)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        SELECT_LIST_INPUT_FUNC = "def getListItem(name, list, default=None):\n  result = UserInput.getOptionList(name, list, default)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        SELECT_MAP_INPUT_FUNC = "def getMapValue(name, dict, default=None):\n  result = UserInput.getOptionMap(name, dict, default)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        SELECT_ORIENTATION_INPUT_FUNC = "def getOrientation(name, default='XYZ+--'):\n  result = UserInput.getOrientationInput(name, default)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        SELECT_ROI_INDEX_INPUT_FUNC = "def getRoiColorIndex(manager, name, default=-1):\n  result = UserInput.getRoiColorIndex(name, default, manager)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        SELECT_ROI_MASK_INPUT_FUNC = "def getRoiMask(manager, name, default=0):\n  result = UserInput.getRoiMaskInput(name, default, manager)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        SELECT_SLICE_DIR_INPUT_FUNC = "def getSliceDirection(manager, name, default=-1):\n  result = UserInput.getSliceDirInput(name, default, manager)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        SELECT_ROT_AXIS_INPUT_FUNC = "def getRotationAxis(manager, name, default=-1):\n  result = UserInput.getRotationAxisInput(name, default, manager)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        SELECT_SAVE_LOC_INPUT_FUNC = "def getSaveLocation(manager, name, default=''):\n  result = UserInput.getSaveLocationInput(name, default, manager)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        SELECT_SERIES_POINT_INPUT_FUNC = "def getSeriesPoint(manager, name, default=-1):\n  result = UserInput.getSeriesPointInput(name, default, manager)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        SELECT_SLICE_NUMBER_INPUT_FUNC = "def getSliceNumber(manager, name, default=-1):\n  result = UserInput.getSliceNumInput(name, default, manager)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        SELECT_SURFACE_INPUT_FUNC = "def getSurface(manager, name):\n  result = UserInput.getSurfaceInput(name, manager)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        SELECT_SURFACE_SHAPE_INPUT_FUNC = "def getSurfaceShape(manager, name):\n  result = UserInput.getSurfaceShapeInput(name, manager)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        SELECT_VOL_INPUT_FUNC = "def getVolume(manager, name):\n  result = UserInput.getVolumeInput(name, manager)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        SELECT_OVLY_INPUT_FUNC = "def getOverlay(manager, name):\n  result = UserInput.getOverlayInput(name, manager)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        SELECT_OVLYS_INPUT_FUNC = "def getOverlays(manager, name):\n  result = UserInput.getOverlaysInput(name, manager)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        SELECT_TOOL_INPUT_FUNC = "def getTool(name, default=-1):\n  result = UserInput.getToolInput(name, default)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        SELECT_DIR_INPUT_FUNC = "def getDirection(manager, name, default=-1):\n  result = UserInput.getDirectionInput(name, default, manager)\n  if result is None:\n    sys.exit('Cancelled')\n  else:\n    return result";
        INPUTS_SIGNATURES.add(BOOLEAN_INPUT_SIG);
        INPUTS_SIGNATURES.add(INTEGER_INPUT_SIG);
        INPUTS_SIGNATURES.add(FLOAT_INPUT_SIG);
        INPUTS_SIGNATURES.add(STRING_INPUT_SIG);
        INPUTS_SIGNATURES.add(COLOR_INPUT_SIG);
        INPUTS_SIGNATURES.add(COORD_INPUT_SIG);
        INPUTS_SIGNATURES.add(KERNEL_INPUT_SIG);
        INPUTS_SIGNATURES.add(OPEN_LOC_INPUT_SIG);
        INPUTS_SIGNATURES.add(SELECT_VOLMAN_INPUT_SIG);
        INPUTS_SIGNATURES.add(SELECT_LIST_INPUT_SIG);
        INPUTS_SIGNATURES.add(SELECT_MAP_INPUT_SIG);
        INPUTS_SIGNATURES.add(SELECT_ORIENTATION_INPUT_SIG);
        INPUTS_SIGNATURES.add(SELECT_ROI_INDEX_INPUT_SIG);
        INPUTS_SIGNATURES.add(SELECT_ROI_MASK_INPUT_SIG);
        INPUTS_SIGNATURES.add(SELECT_SLICE_DIR_INPUT_SIG);
        INPUTS_SIGNATURES.add(SELECT_ROT_AXIS_INPUT_SIG);
        INPUTS_SIGNATURES.add(SELECT_SAVE_LOC_INPUT_SIG);
        INPUTS_SIGNATURES.add(SELECT_SERIES_POINT_INPUT_SIG);
        INPUTS_SIGNATURES.add(SELECT_SLICE_NUMBER_INPUT_SIG);
        INPUTS_SIGNATURES.add(SELECT_SURFACE_INPUT_SIG);
        INPUTS_SIGNATURES.add(SELECT_SURFACE_SHAPE_INPUT_SIG);
        INPUTS_SIGNATURES.add(SELECT_VOL_INPUT_SIG);
        INPUTS_SIGNATURES.add(SELECT_OVLY_INPUT_SIG);
        INPUTS_SIGNATURES.add(SELECT_OVLYS_INPUT_SIG);
        INPUTS_SIGNATURES.add(SELECT_TOOL_INPUT_SIG);
        INPUTS_SIGNATURES.add(SELECT_DIR_INPUT_SIG);
        INPUTS_SIGNATURES.add(INPUT_SIG);
        Collections.sort(INPUTS_SIGNATURES);
        INPUT_FUNCTIONS.add(BOOLEAN_INPUT_FUNC);
        INPUT_FUNCTIONS.add(INTEGER_INPUT_FUNC);
        INPUT_FUNCTIONS.add(FLOAT_INPUT_FUNC);
        INPUT_FUNCTIONS.add(STRING_INPUT_FUNC);
        INPUT_FUNCTIONS.add(COLOR_INPUT_FUNC);
        INPUT_FUNCTIONS.add(COORD_INPUT_FUNC);
        INPUT_FUNCTIONS.add(KERNEL_INPUT_FUNC);
        INPUT_FUNCTIONS.add(OPEN_LOC_INPUT_FUNC);
        INPUT_FUNCTIONS.add(SELECT_VOLMAN_INPUT_FUNC);
        INPUT_FUNCTIONS.add(SELECT_LIST_INPUT_FUNC);
        INPUT_FUNCTIONS.add(SELECT_MAP_INPUT_FUNC);
        INPUT_FUNCTIONS.add(SELECT_ORIENTATION_INPUT_FUNC);
        INPUT_FUNCTIONS.add(SELECT_ROI_INDEX_INPUT_FUNC);
        INPUT_FUNCTIONS.add(SELECT_ROI_MASK_INPUT_FUNC);
        INPUT_FUNCTIONS.add(SELECT_SLICE_DIR_INPUT_FUNC);
        INPUT_FUNCTIONS.add(SELECT_ROT_AXIS_INPUT_FUNC);
        INPUT_FUNCTIONS.add(SELECT_SAVE_LOC_INPUT_FUNC);
        INPUT_FUNCTIONS.add(SELECT_SERIES_POINT_INPUT_FUNC);
        INPUT_FUNCTIONS.add(SELECT_SLICE_NUMBER_INPUT_FUNC);
        INPUT_FUNCTIONS.add(SELECT_SURFACE_INPUT_FUNC);
        INPUT_FUNCTIONS.add(SELECT_SURFACE_SHAPE_INPUT_FUNC);
        INPUT_FUNCTIONS.add(SELECT_VOL_INPUT_FUNC);
        INPUT_FUNCTIONS.add(SELECT_OVLY_INPUT_FUNC);
        INPUT_FUNCTIONS.add(SELECT_OVLYS_INPUT_FUNC);
        INPUT_FUNCTIONS.add(SELECT_TOOL_INPUT_FUNC);
        INPUT_FUNCTIONS.add(SELECT_DIR_INPUT_FUNC);
        INPUT_FUNCTIONS.add(INPUT_FUNC);
    }
}

