/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.modal.preferences;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoComboBox;
import edu.uthscsa.ric.mango.components.MangoSquareButton;
import edu.uthscsa.ric.mango.components.menus.MangoMenuUtil;
import edu.uthscsa.ric.mango.components.menus.MangoSquareMenu;
import edu.uthscsa.ric.mango.components.menus.MangoSquareMenuItem;
import edu.uthscsa.ric.mango.dialogs.modal.preferences.FunctionBoxRenderer;
import edu.uthscsa.ric.mango.dialogs.modal.preferences.FunctionBoxRenderer2;
import edu.uthscsa.ric.mango.dialogs.modal.preferences.SquareButtonPanel;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.mango.viewerslice.screen.lut.LookupTableManager;
import edu.uthscsa.ric.mango.viewersurface.SurfaceViewer;
import edu.uthscsa.ric.mango.window.Toolbox;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.lang3.StringUtils;

public class PreferencesDialog
extends JPanel
implements ActionListener,
PopupMenuListener {
    private JButton roiEditButtonFirst;
    private JButton roiEditButtonSecond;
    private JLabel infoLabel;
    private JLabel listenPortLabel;
    private JPopupMenu popupROIEditFirst;
    private JPopupMenu popupROIEditSecond;
    private JRadioButton retinaOnButton;
    private JRadioButton retinaOffButton;
    private JRadioButton checkAutoButton;
    private JRadioButton checkManualButton;
    private JRadioButton coordinateCurrent;
    private JRadioButton coordinateMouse;
    private JRadioButton desktopButton;
    private JRadioButton imageButton;
    private JRadioButton indexCustom;
    private JRadioButton indexDefault;
    private JRadioButton voxelDisplaySmoothButton;
    private JRadioButton listenOffButton;
    private JRadioButton listenOnButton;
    private JRadioButton voxelDisplayVoxelButton;
    private JRadioButton neurologicalButton;
    private JRadioButton openGlBetter;
    private JRadioButton openGlGood;
    private JRadioButton radiologicalButton;
    private JRadioButton scrollZoomButton;
    private JRadioButton scrollZoomDefault;
    private JRadioButton scrollZoomFlip;
    private JRadioButton sliceButton;
    private JTextField listenPort;
    private MangoComboBox<String> functionBox;
    private MangoComboBox<String> functionKeyBox;
    private MangoComboBox<String> indexBox;
    private MangoComboBox<String> overlayBox1;
    private MangoComboBox<String> overlayBox2;
    private MangoComboBox<String> overlayBox3;
    private String[] allActionNames;
    private boolean freezeFunctionBox;
    private long popupROIEditTimeCanceledFirst;
    private long popupROIEditTimeCanceledSecond;
    private final JTabbedPane tabbedPane;
    private final Mango mango;
    private final String[] allActions;
    private final Vector<JPanel> allPanels;
    private static final int PAD = 6;
    private static final long serialVersionUID = 1L;
    private static final String[] FUNCTION_KEY_NAMES = new String[]{"F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10", "F11", "F12", "F13", "F14", "F15", "F16", "F17", "F18", "F19", "F20", "F21", "F22", "F23", "F24"};
    public static final String CORNER_DEFAULT = "LAS";
    public static final String INFO_AUTO_UPDATE = "<html><body><center>Select how the application checks for updates.  Updates can be checked automatically or manually via the toolbox Help menu.</center></body></html>";
    public static final String INFO_DEFAULT = "Hover over a preference to get more information.";
    public static final String INFO_DICOM = "<html><body><center>Select the DICOM library to use.</center></body></html>";
    public static final String INFO_FUNCTION_KEYS = "<html><body><center>Create associations between function keys and menu actions.  At least one instance of a viewer type must be loaded in order to see its menu actions in the list.</center></body></html>";
    public static final String INFO_IMAGE_ORIGIN = "<html><body><center>Select which corner to use as the image index origin.  By default, the left-anterior-superior (LAS) corner is used.</center></body></html>";
    public static final String INFO_LISTEN_FOR_FILES = "<html><body><center>Select whether to enable command-line support.  When enabled, the command-line program 'mango' will load images in the currently open instance of Mango.</center></body></html>";
    public static final String INFO_OPENGL = "<html><body><center>Select which OpenGL graphics to use.  For more modern graphics cards, use 'Better Graphics'.</center></body></html>";
    public static final String INFO_OVERLAY_COLOR_TABLES = "<html><body><center>Select which color tables are used by default when loading overlay images.</center></body></html>";
    public static final String INFO_QUICK_KEY = "<html><body><center>Select which ROI tools respond to the 'f' key.  Tapping the 'f' key will toggle between these two selections.</center></body></html>";
    public static final String INFO_RADIOLOGICAL = "<html><body><center>Select which display orientation convention to use.</center></body></html>";
    public static final String INFO_SCREEN_CAPTURE = "<html><body><center>Select where to save screen captures using application camera buttons.  These files can be saved to the desktop or to the viewer's base image folder.</center></body></html>";
    public static final String INFO_SCROLL = "<html><body><center>Select whether the mouse scroll zooms or changes the current slice.</center></body></html>";
    public static final String INFO_SCROLL_DIRECTION = "<html><body><center>Select the direction of the scroll zoom.</center></body></html>";
    public static final String INFO_SMOOTH_DISPLAY = "<html><body><center>Select 'Smooth Display' to always use interpolation. Select 'Voxel Display' to never use interpolation.</center></body></html>";
    public static final String INFO_TOOLBOX_COORDINATE = "<html><body><center>Select whether the toolbox coordinate represents the mouse or crosshairs.</center></body></html>";
    public static final String INFO_WARNINGS = "<html><body><center>Select whether to display warnings.  The display of various warnings can be toggled here.</center></body></html>";
    public static final String INFO_RETINA = "<html><body><center>Select whether to enable or disable high-resolution image display.</center></body></html>";
    public static final String INFO_RGB = "<html><body><center>Select whether to display RGB data as color or intensity data.</center></body></html>";
    public static final String INFO_OVERLAY_ALIGNMENT = "<html><body><center>Select where overlays should align with the image origin or world origin.</center></body></html>";
    public static final String OVERLAY_DEFAULT1 = "Red Overlay";
    public static final String OVERLAY_DEFAULT2 = "Green Overlay";
    public static final String OVERLAY_DEFAULT3 = "Blue Overlay";
    public static final List<String> CORNER_CUSTOM = CollectionUtilities.immutable((String[])new String[]{"RAS", "LAI", "RAI", "LPS", "RPS", "LPI", "RPI"});

    private static int makeImageIndexOriginCode(String origin) {
        int code = 0;
        if (origin.charAt(0) == 'R') {
            code |= 1;
        }
        if (origin.charAt(1) == 'P') {
            code |= 2;
        }
        if (origin.charAt(2) == 'I') {
            code |= 4;
        }
        return code;
    }

    private static String makeImageIndexOriginString(int code) {
        StringBuffer sb = new StringBuffer();
        if ((code & 1) == 1) {
            sb.append('R');
        } else {
            sb.append('L');
        }
        if ((code & 2) == 2) {
            sb.append('P');
        } else {
            sb.append('A');
        }
        if ((code & 4) == 4) {
            sb.append('I');
        } else {
            sb.append('S');
        }
        return sb.toString();
    }

    public PreferencesDialog(Mango mango) {
        this.mango = mango;
        this.tabbedPane = new JTabbedPane();
        this.allActions = new String[Mango.getFActions().length];
        this.allPanels = new Vector();
        this.createUI();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.indexOf("roiEditButtonChosenFirst") != -1) {
            this.roiEditButtonFirst.setIcon(MangoStyle.ICON_EDIT_ROI.get(Integer.parseInt(ae.getActionCommand().substring(24))));
        } else if (command.equals("roiEditButtonToggleFirst")) {
            long timeSinceCancel = new Date().getTime() - this.popupROIEditTimeCanceledFirst;
            if (timeSinceCancel > 250L) {
                this.popupROIEditFirst.show(this.roiEditButtonFirst, 2, 35);
            }
        } else if (command.indexOf("roiEditButtonChosenSecond") != -1) {
            this.roiEditButtonSecond.setIcon(MangoStyle.ICON_EDIT_ROI.get(Integer.parseInt(ae.getActionCommand().substring(25))));
        } else if (command.equals("roiEditButtonToggleSecond")) {
            long timeSinceCancel = new Date().getTime() - this.popupROIEditTimeCanceledSecond;
            if (timeSinceCancel > 250L) {
                this.popupROIEditSecond.show(this.roiEditButtonSecond, 2, 35);
            }
        } else if (ae.getActionCommand().equals("function box")) {
            if (!this.freezeFunctionBox) {
                String action = (String)this.functionBox.getSelectedItem();
                for (int ctr = 0; ctr < this.allActions.length; ++ctr) {
                    if (!this.allActions[ctr].equals(action)) continue;
                    this.allActions[ctr] = "(Not Assigned)";
                }
                this.allActions[this.functionKeyBox.getSelectedIndex()] = (String)this.functionBox.getSelectedItem();
            }
        } else if (ae.getActionCommand().equals("function key box")) {
            int selectedIndex = this.functionKeyBox.getSelectedIndex();
            String action = this.allActions[selectedIndex];
            String so = this.getStringObject(action);
            if (so == null) {
                this.allActions[selectedIndex] = "(Not Assigned)";
                so = this.getStringObject(this.allActions[selectedIndex]);
            }
            this.functionBox.setSelectedItem(so);
        } else if (ae.getActionCommand().equals("port")) {
            this.listenPort.setEnabled(this.listenOnButton.isSelected());
            this.listenPortLabel.setEnabled(this.listenOnButton.isSelected());
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent pme) {
        if (pme.getSource() == this.popupROIEditFirst) {
            this.popupROIEditTimeCanceledFirst = new Date().getTime();
        } else if (pme.getSource() == this.popupROIEditSecond) {
            this.popupROIEditTimeCanceledSecond = new Date().getTime();
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
    }

    public void restoreDefaults() {
        this.voxelDisplayVoxelButton.setSelected(false);
        this.voxelDisplaySmoothButton.setSelected(true);
        this.desktopButton.setSelected(false);
        this.imageButton.setSelected(true);
        this.listenOnButton.setSelected(true);
        this.listenOffButton.setSelected(false);
        this.listenPort.setText(String.valueOf(63086));
        this.checkManualButton.setSelected(false);
        this.checkAutoButton.setSelected(true);
        this.radiologicalButton.setSelected(false);
        this.neurologicalButton.setSelected(true);
        this.roiEditButtonFirst.setIcon(MangoStyle.ICON_EDIT_ROI.get(0));
        this.roiEditButtonSecond.setIcon(MangoStyle.ICON_EDIT_ROI.get(0));
        this.scrollZoomButton.setSelected(true);
        this.sliceButton.setSelected(false);
        this.scrollZoomDefault.setSelected(true);
        this.scrollZoomFlip.setSelected(false);
        this.openGlGood.setSelected(true);
        for (int ctr = 0; ctr < this.allActions.length; ++ctr) {
            this.allActions[ctr] = "(Not Assigned)";
        }
        this.indexDefault.setSelected(true);
        this.indexBox.setSelectedItem(CORNER_CUSTOM.get(0));
        this.overlayBox1.setSelectedItem(OVERLAY_DEFAULT1);
        this.overlayBox2.setSelectedItem(OVERLAY_DEFAULT2);
        this.overlayBox3.setSelectedItem(OVERLAY_DEFAULT3);
        this.coordinateMouse.setSelected(true);
        this.freezeFunctionBox = true;
        this.functionKeyBox.setSelectedIndex(0);
        int selectedIndex = this.functionKeyBox.getSelectedIndex();
        String action = this.allActions[selectedIndex];
        String so = this.getStringObject(action);
        if (so == null) {
            this.allActions[selectedIndex] = "(Not Assigned)";
            so = this.getStringObject(this.allActions[selectedIndex]);
        }
        this.functionBox.setSelectedItem(so);
        this.freezeFunctionBox = false;
    }

    public boolean storePreferences() {
        int ctr;
        boolean needUpdate = false;
        if (this.voxelDisplayVoxelButton.isSelected()) {
            Mango.setVoxelDisplayMode(true);
        } else {
            Mango.setVoxelDisplayMode(false);
        }
        Mango.setRetinaDisplayMode(this.retinaOnButton.isSelected());
        if (this.checkAutoButton.isSelected()) {
            this.mango.setAutoCheck(true);
        } else {
            this.mango.setAutoCheck(false);
        }
        int portNumber = 63086;
        try {
            portNumber = Integer.parseInt(this.listenPort.getText());
        }
        catch (NumberFormatException ex) {
            AppLogger.warn((Throwable)ex);
        }
        this.listenPort.setText(String.valueOf(portNumber));
        this.mango.setServer(this.listenOnButton.isSelected(), portNumber);
        this.mango.setCaptureToDesktop(this.desktopButton.isSelected());
        this.mango.setScrollwheelSlices(this.sliceButton.isSelected());
        Mango.getInstance().setScrollwheelDirectionFlip(this.scrollZoomFlip.isSelected());
        boolean useShaders = this.openGlBetter.isSelected();
        needUpdate |= useShaders ^ SurfaceViewer.isUseShaders();
        SurfaceViewer.setUseShaders(useShaders);
        Icon first = this.roiEditButtonFirst.getIcon();
        Icon second = this.roiEditButtonSecond.getIcon();
        for (ctr = 0; ctr < MangoStyle.ICON_EDIT_ROI.size(); ++ctr) {
            if (first != MangoStyle.ICON_EDIT_ROI.get(ctr)) continue;
            this.mango.setQuickKeyFirst(ctr);
        }
        for (ctr = 0; ctr < MangoStyle.ICON_EDIT_ROI.size(); ++ctr) {
            if (second != MangoStyle.ICON_EDIT_ROI.get(ctr)) continue;
            this.mango.setQuickKeySecond(ctr);
        }
        if (this.radiologicalButton.isSelected()) {
            if (!this.mango.isRadiologicalMode()) {
                this.mango.setRadiologicalMode(true);
                this.mango.updateRadiologicalMode();
            }
        } else if (this.mango.isRadiologicalMode()) {
            this.mango.setRadiologicalMode(false);
            this.mango.updateRadiologicalMode();
        }
        this.mango.setFunctionKeyActions(this.allActions);
        this.mango.updateAllFunctionHotKeys();
        if (this.indexDefault.isSelected()) {
            this.mango.setImageIndexOrigin(0);
        } else {
            this.mango.setImageIndexOrigin(PreferencesDialog.makeImageIndexOriginCode(this.indexBox.getSelectedItem().toString()));
        }
        Mango.getInstance().setOverlayColorTable1(this.overlayBox1.getSelectedItem().toString());
        Mango.getInstance().setOverlayColorTable2(this.overlayBox2.getSelectedItem().toString());
        Mango.getInstance().setOverlayColorTable3(this.overlayBox3.getSelectedItem().toString());
        this.mango.setToolboxCoordinateCurrentSlice(this.coordinateCurrent.isSelected());
        this.mango.updateToolboxCoordinateCurrentSlice();
        return needUpdate;
    }

    private void clearSelected(JPanel except) {
        for (JPanel panel : this.allPanels) {
            if (panel == except) continue;
            SwingWidgetUtilities.colorBackgroundOfAllComponents((Container)panel, null, (Class[])new Class[]{JTextField.class, MangoSquareButton.class, MangoComboBox.class, SquareButtonPanel.class});
            this.infoLabel.setText(INFO_DEFAULT);
            this.infoLabel.setForeground(Color.GRAY);
        }
    }

    private void createUI() {
        JLabel picture = new JLabel("Screen Capture");
        picture.setFont(Mango.FONT_HEADING);
        JPanel pictureLabelPanel = new JPanel();
        pictureLabelPanel.setLayout(new BoxLayout(pictureLabelPanel, 0));
        pictureLabelPanel.add(Box.createHorizontalGlue());
        pictureLabelPanel.add(picture);
        pictureLabelPanel.add(Box.createHorizontalGlue());
        this.imageButton = new JRadioButton("To Image Folder");
        this.imageButton.setFont(MangoStyle.FONT_REGULAR);
        JPanel imageButtonPanel = new JPanel();
        imageButtonPanel.setLayout(new BoxLayout(imageButtonPanel, 0));
        imageButtonPanel.add(this.imageButton);
        imageButtonPanel.add(Box.createHorizontalGlue());
        this.desktopButton = new JRadioButton("To Desktop Folder");
        this.desktopButton.setFont(MangoStyle.FONT_REGULAR);
        JPanel desktopButtonPanel = new JPanel();
        desktopButtonPanel.setLayout(new BoxLayout(desktopButtonPanel, 0));
        desktopButtonPanel.add(this.desktopButton);
        desktopButtonPanel.add(Box.createHorizontalGlue());
        ButtonGroup pictureGroup = new ButtonGroup();
        pictureGroup.add(this.imageButton);
        pictureGroup.add(this.desktopButton);
        JPanel picturePanel = new JPanel();
        picturePanel.setLayout(new BoxLayout(picturePanel, 1));
        picturePanel.add(pictureLabelPanel);
        picturePanel.add(Box.createVerticalStrut(2));
        picturePanel.add(imageButtonPanel);
        picturePanel.add(Box.createVerticalStrut(2));
        picturePanel.add(desktopButtonPanel);
        picturePanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JLabel listenForFiles = new JLabel("Command Line");
        listenForFiles.setFont(Mango.FONT_HEADING);
        JPanel listenForFilesPanel = new JPanel();
        listenForFilesPanel.setLayout(new BoxLayout(listenForFilesPanel, 0));
        listenForFilesPanel.add(Box.createHorizontalGlue());
        listenForFilesPanel.add(listenForFiles);
        listenForFilesPanel.add(Box.createHorizontalGlue());
        this.listenOnButton = new JRadioButton("On");
        this.listenOnButton.setActionCommand("port");
        this.listenOnButton.addActionListener(this);
        this.listenOnButton.setFont(MangoStyle.FONT_REGULAR);
        this.listenOffButton = new JRadioButton("Off");
        this.listenOffButton.setActionCommand("port");
        this.listenOffButton.addActionListener(this);
        this.listenOffButton.setFont(MangoStyle.FONT_REGULAR);
        ButtonGroup listenGroup = new ButtonGroup();
        listenGroup.add(this.listenOnButton);
        listenGroup.add(this.listenOffButton);
        JPanel listenOptionsPanel = new JPanel();
        listenOptionsPanel.setLayout(new BoxLayout(listenOptionsPanel, 0));
        listenOptionsPanel.add(this.listenOnButton);
        listenOptionsPanel.add(Box.createHorizontalStrut(8));
        listenOptionsPanel.add(this.listenOffButton);
        listenOptionsPanel.add(Box.createHorizontalGlue());
        listenOptionsPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, listenOptionsPanel.getPreferredSize().height));
        listenOptionsPanel.setMinimumSize(listenOptionsPanel.getPreferredSize());
        this.listenPortLabel = new JLabel(" Port:");
        this.listenPortLabel.setFont(MangoStyle.FONT_REGULAR);
        this.listenPort = new JTextField(String.valueOf(63086), 6);
        this.listenPort.setFont(MangoStyle.FONT_SMALL);
        this.listenPort.setMaximumSize(this.listenPort.getPreferredSize());
        this.listenPort.setMinimumSize(this.listenPort.getPreferredSize());
        JPanel listenPortPanel = new JPanel();
        listenPortPanel.setLayout(new BoxLayout(listenPortPanel, 0));
        listenPortPanel.add(this.listenPortLabel);
        listenPortPanel.add(Box.createHorizontalStrut(4));
        listenPortPanel.add(this.listenPort);
        listenPortPanel.add(Box.createHorizontalGlue());
        listenPortPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, listenPortPanel.getPreferredSize().height));
        listenPortPanel.setMinimumSize(listenPortPanel.getPreferredSize());
        JPanel listenPanel = new JPanel();
        listenPanel.setLayout(new BoxLayout(listenPanel, 1));
        listenPanel.add(listenForFilesPanel);
        listenPanel.add(Box.createVerticalStrut(2));
        listenPanel.add(listenOptionsPanel);
        listenPanel.add(listenPortPanel);
        listenPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JLabel checkUpdate = new JLabel("Check for Updates");
        checkUpdate.setFont(Mango.FONT_HEADING);
        JPanel checkLabelPanel = new JPanel();
        checkLabelPanel.setLayout(new BoxLayout(checkLabelPanel, 0));
        checkLabelPanel.add(Box.createHorizontalGlue());
        checkLabelPanel.add(checkUpdate);
        checkLabelPanel.add(Box.createHorizontalGlue());
        this.checkAutoButton = new JRadioButton("Automatically");
        this.checkAutoButton.setFont(MangoStyle.FONT_REGULAR);
        JPanel checkAutoPanel = new JPanel();
        checkAutoPanel.setLayout(new BoxLayout(checkAutoPanel, 0));
        checkAutoPanel.add(this.checkAutoButton);
        checkAutoPanel.add(Box.createHorizontalGlue());
        this.checkManualButton = new JRadioButton("Manually");
        this.checkManualButton.setFont(MangoStyle.FONT_REGULAR);
        this.checkManualButton.setSelected(true);
        JPanel checkManualPanel = new JPanel();
        checkManualPanel.setLayout(new BoxLayout(checkManualPanel, 0));
        checkManualPanel.add(this.checkManualButton);
        checkManualPanel.add(Box.createHorizontalGlue());
        ButtonGroup checkGroup = new ButtonGroup();
        checkGroup.add(this.checkAutoButton);
        checkGroup.add(this.checkManualButton);
        JPanel checkPanel = new JPanel();
        checkPanel.setLayout(new BoxLayout(checkPanel, 1));
        checkPanel.add(checkLabelPanel);
        checkPanel.add(Box.createVerticalStrut(2));
        checkPanel.add(checkAutoPanel);
        checkPanel.add(Box.createVerticalStrut(2));
        checkPanel.add(checkManualPanel);
        checkPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JLabel indexLabel = new JLabel("Image Origin");
        indexLabel.setFont(Mango.FONT_HEADING);
        JPanel indexLabelPanel = new JPanel();
        indexLabelPanel.setLayout(new BoxLayout(indexLabelPanel, 0));
        indexLabelPanel.add(Box.createHorizontalGlue());
        indexLabelPanel.add(indexLabel);
        indexLabelPanel.add(Box.createHorizontalGlue());
        this.indexDefault = new JRadioButton("Default (LAS)");
        this.indexDefault.setFont(MangoStyle.FONT_REGULAR);
        JPanel indexDefaultPanel = new JPanel();
        indexDefaultPanel.setLayout(new BoxLayout(indexDefaultPanel, 0));
        indexDefaultPanel.add(this.indexDefault);
        indexDefaultPanel.add(Box.createHorizontalGlue());
        this.indexCustom = new JRadioButton();
        this.indexCustom.setFont(MangoStyle.FONT_REGULAR);
        this.indexCustom.setSelected(true);
        this.indexBox = new MangoComboBox<String>((T[])CollectionUtilities.array(CORNER_CUSTOM));
        this.indexBox.setMaximumSize(this.indexBox.getPreferredSize());
        this.indexBox.setMinimumSize(this.indexBox.getPreferredSize());
        JPanel indexCustomPanel = new JPanel();
        indexCustomPanel.setLayout(new BoxLayout(indexCustomPanel, 0));
        indexCustomPanel.add(this.indexCustom);
        indexCustomPanel.add(this.indexBox);
        indexCustomPanel.add(Box.createHorizontalGlue());
        ButtonGroup indexGroup = new ButtonGroup();
        indexGroup.add(this.indexDefault);
        indexGroup.add(this.indexCustom);
        JPanel indexPanel = new JPanel();
        indexPanel.setLayout(new BoxLayout(indexPanel, 1));
        indexPanel.add(indexLabelPanel);
        indexPanel.add(Box.createVerticalStrut(2));
        indexPanel.add(indexDefaultPanel);
        indexPanel.add(Box.createVerticalStrut(2));
        indexPanel.add(indexCustomPanel);
        indexPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JLabel coordinateLabel = new JLabel("Toolbox Coordinate");
        coordinateLabel.setFont(Mango.FONT_HEADING);
        JPanel coordinateLabelPanel = new JPanel();
        coordinateLabelPanel.setLayout(new BoxLayout(coordinateLabelPanel, 0));
        coordinateLabelPanel.add(Box.createHorizontalGlue());
        coordinateLabelPanel.add(coordinateLabel);
        coordinateLabelPanel.add(Box.createHorizontalGlue());
        this.coordinateMouse = new JRadioButton("Mouse Location");
        this.coordinateMouse.setFont(MangoStyle.FONT_REGULAR);
        JPanel coordinateMousePanel = new JPanel();
        coordinateMousePanel.setLayout(new BoxLayout(coordinateMousePanel, 0));
        coordinateMousePanel.add(this.coordinateMouse);
        coordinateMousePanel.add(Box.createHorizontalGlue());
        this.coordinateCurrent = new JRadioButton("Crosshairs");
        this.coordinateCurrent.setFont(MangoStyle.FONT_REGULAR);
        JPanel coordinateCurrentPanel = new JPanel();
        coordinateCurrentPanel.setLayout(new BoxLayout(coordinateCurrentPanel, 0));
        coordinateCurrentPanel.add(this.coordinateCurrent);
        coordinateCurrentPanel.add(Box.createHorizontalGlue());
        ButtonGroup coordinateGroup = new ButtonGroup();
        coordinateGroup.add(this.coordinateMouse);
        coordinateGroup.add(this.coordinateCurrent);
        JPanel coordinatePanel = new JPanel();
        coordinatePanel.setLayout(new BoxLayout(coordinatePanel, 1));
        coordinatePanel.add(coordinateLabelPanel);
        coordinatePanel.add(Box.createVerticalStrut(2));
        coordinatePanel.add(coordinateMousePanel);
        coordinatePanel.add(Box.createVerticalStrut(2));
        coordinatePanel.add(coordinateCurrentPanel);
        coordinatePanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JPanel generalTab = new JPanel(new GridLayout(2, 3));
        generalTab.add(this.makePreferencePanel(checkPanel, INFO_AUTO_UPDATE));
        generalTab.add(this.makePreferencePanel(picturePanel, INFO_SCREEN_CAPTURE));
        generalTab.add(this.makePreferencePanel(listenPanel, INFO_LISTEN_FOR_FILES));
        generalTab.add(this.makePreferencePanel(indexPanel, INFO_IMAGE_ORIGIN));
        generalTab.add(this.makePreferencePanel(coordinatePanel, INFO_TOOLBOX_COORDINATE));
        generalTab.add(new JPanel());
        this.tabbedPane.addTab("General", generalTab);
        JLabel interp = new JLabel("Smoothness");
        interp.setFont(Mango.FONT_HEADING);
        JPanel interpLabelPanel = new JPanel();
        interpLabelPanel.setLayout(new BoxLayout(interpLabelPanel, 0));
        interpLabelPanel.add(Box.createHorizontalGlue());
        interpLabelPanel.add(interp);
        interpLabelPanel.add(Box.createHorizontalGlue());
        this.voxelDisplayVoxelButton = new JRadioButton("Voxel Display");
        this.voxelDisplayVoxelButton.setFont(MangoStyle.FONT_REGULAR);
        JPanel neighborPanel = new JPanel();
        neighborPanel.setLayout(new BoxLayout(neighborPanel, 0));
        neighborPanel.add(this.voxelDisplayVoxelButton);
        neighborPanel.add(Box.createHorizontalGlue());
        this.voxelDisplaySmoothButton = new JRadioButton("Smooth Display");
        this.voxelDisplaySmoothButton.setFont(MangoStyle.FONT_REGULAR);
        JPanel linearPanel = new JPanel();
        linearPanel.setLayout(new BoxLayout(linearPanel, 0));
        linearPanel.add(this.voxelDisplaySmoothButton);
        linearPanel.add(Box.createHorizontalGlue());
        ButtonGroup interpGroup = new ButtonGroup();
        interpGroup.add(this.voxelDisplayVoxelButton);
        interpGroup.add(this.voxelDisplaySmoothButton);
        JPanel interpPanel = new JPanel();
        interpPanel.setLayout(new BoxLayout(interpPanel, 1));
        interpPanel.add(interpLabelPanel);
        interpPanel.add(Box.createVerticalStrut(2));
        interpPanel.add(linearPanel);
        interpPanel.add(Box.createVerticalStrut(2));
        interpPanel.add(neighborPanel);
        interpPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JLabel displayType = new JLabel("View");
        displayType.setFont(Mango.FONT_HEADING);
        JPanel displayLabelPanel = new JPanel();
        displayLabelPanel.setLayout(new BoxLayout(displayLabelPanel, 0));
        displayLabelPanel.add(Box.createHorizontalGlue());
        displayLabelPanel.add(displayType);
        displayLabelPanel.add(Box.createHorizontalGlue());
        this.radiologicalButton = new JRadioButton("Radiological");
        this.radiologicalButton.setFont(MangoStyle.FONT_REGULAR);
        JPanel radiologicalPanel = new JPanel();
        radiologicalPanel.setLayout(new BoxLayout(radiologicalPanel, 0));
        radiologicalPanel.add(this.radiologicalButton);
        radiologicalPanel.add(Box.createHorizontalGlue());
        this.neurologicalButton = new JRadioButton("Neurological");
        this.neurologicalButton.setFont(MangoStyle.FONT_REGULAR);
        this.neurologicalButton.setSelected(true);
        JPanel neurologicalPanel = new JPanel();
        neurologicalPanel.setLayout(new BoxLayout(neurologicalPanel, 0));
        neurologicalPanel.add(this.neurologicalButton);
        neurologicalPanel.add(Box.createHorizontalGlue());
        ButtonGroup displayGroup = new ButtonGroup();
        displayGroup.add(this.radiologicalButton);
        displayGroup.add(this.neurologicalButton);
        JPanel displayPanel = new JPanel();
        displayPanel.setLayout(new BoxLayout(displayPanel, 1));
        displayPanel.add(displayLabelPanel);
        displayPanel.add(Box.createVerticalStrut(2));
        displayPanel.add(neurologicalPanel);
        displayPanel.add(Box.createVerticalStrut(2));
        displayPanel.add(radiologicalPanel);
        displayPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JLabel overlayLabel = new JLabel("Overlay Color Tables");
        overlayLabel.setFont(Mango.FONT_HEADING);
        JPanel overlayLabelPanel = new JPanel();
        overlayLabelPanel.setLayout(new BoxLayout(overlayLabelPanel, 0));
        overlayLabelPanel.add(Box.createHorizontalGlue());
        overlayLabelPanel.add(overlayLabel);
        overlayLabelPanel.add(Box.createHorizontalGlue());
        this.overlayBox1 = new MangoComboBox<String>((T[])LookupTableManager.getAllLUTNames());
        this.overlayBox1.setFont(MangoStyle.FONT_REGULAR);
        this.overlayBox1.setPrototypeDisplayValue("Grayscale");
        JPanel overlayBoxPanel1 = new JPanel();
        overlayBoxPanel1.setLayout(new BoxLayout(overlayBoxPanel1, 0));
        overlayBoxPanel1.add(this.overlayBox1);
        this.overlayBox2 = new MangoComboBox<String>((T[])LookupTableManager.getAllLUTNames());
        this.overlayBox2.setFont(MangoStyle.FONT_REGULAR);
        this.overlayBox2.setPrototypeDisplayValue("Grayscale");
        JPanel overlayBoxPanel2 = new JPanel();
        overlayBoxPanel2.setLayout(new BoxLayout(overlayBoxPanel2, 0));
        overlayBoxPanel2.add(this.overlayBox2);
        this.overlayBox3 = new MangoComboBox<String>((T[])LookupTableManager.getAllLUTNames());
        this.overlayBox3.setFont(MangoStyle.FONT_REGULAR);
        this.overlayBox3.setPrototypeDisplayValue("Grayscale");
        JPanel overlayBoxPanel3 = new JPanel();
        overlayBoxPanel3.setLayout(new BoxLayout(overlayBoxPanel3, 0));
        overlayBoxPanel3.add(this.overlayBox3);
        JPanel overlayPanel = new JPanel();
        overlayPanel.setLayout(new BoxLayout(overlayPanel, 1));
        overlayPanel.add(overlayLabelPanel);
        overlayPanel.add(Box.createVerticalStrut(2));
        overlayPanel.add(overlayBoxPanel1);
        overlayPanel.add(Box.createVerticalStrut(2));
        overlayPanel.add(overlayBoxPanel2);
        overlayPanel.add(Box.createVerticalStrut(2));
        overlayPanel.add(overlayBoxPanel3);
        overlayPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JLabel retina = new JLabel("Retina Display");
        retina.setFont(Mango.FONT_HEADING);
        retina.setEnabled(Platform.isRetinaCapable());
        JPanel retinaPanel = new JPanel();
        retinaPanel.setLayout(new BoxLayout(retinaPanel, 0));
        retinaPanel.add(Box.createHorizontalGlue());
        retinaPanel.add(retina);
        retinaPanel.add(Box.createHorizontalGlue());
        this.retinaOnButton = new JRadioButton("Enabled");
        this.retinaOnButton.setFont(MangoStyle.FONT_REGULAR);
        this.retinaOnButton.setEnabled(Platform.isRetinaCapable());
        JPanel retinaOnButtonPanel = new JPanel();
        retinaOnButtonPanel.setLayout(new BoxLayout(retinaOnButtonPanel, 0));
        retinaOnButtonPanel.add(this.retinaOnButton);
        retinaOnButtonPanel.add(Box.createHorizontalGlue());
        this.retinaOffButton = new JRadioButton("Disabled");
        this.retinaOffButton.setFont(MangoStyle.FONT_REGULAR);
        this.retinaOffButton.setEnabled(Platform.isRetinaCapable());
        JPanel retinaOffButtonPanel = new JPanel();
        retinaOffButtonPanel.setLayout(new BoxLayout(retinaOffButtonPanel, 0));
        retinaOffButtonPanel.add(this.retinaOffButton);
        retinaOffButtonPanel.add(Box.createHorizontalGlue());
        ButtonGroup retinaOffGroup = new ButtonGroup();
        retinaOffGroup.add(this.retinaOnButton);
        retinaOffGroup.add(this.retinaOffButton);
        JPanel retinaOptionsPanel = new JPanel();
        retinaOptionsPanel.setLayout(new BoxLayout(retinaOptionsPanel, 1));
        retinaOptionsPanel.add(retinaPanel);
        retinaOptionsPanel.add(Box.createVerticalStrut(2));
        retinaOptionsPanel.add(retinaOnButtonPanel);
        retinaOptionsPanel.add(Box.createVerticalStrut(2));
        retinaOptionsPanel.add(retinaOffButtonPanel);
        retinaOptionsPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JLabel zoomDirectionLabel = new JLabel("Scroll Zoom");
        zoomDirectionLabel.setFont(Mango.FONT_HEADING);
        JPanel zoomDirectionLabelPanel = new JPanel();
        zoomDirectionLabelPanel.setLayout(new BoxLayout(zoomDirectionLabelPanel, 0));
        zoomDirectionLabelPanel.add(Box.createHorizontalGlue());
        zoomDirectionLabelPanel.add(zoomDirectionLabel);
        zoomDirectionLabelPanel.add(Box.createHorizontalGlue());
        this.scrollZoomDefault = new JRadioButton("Default Direction");
        this.scrollZoomDefault.setFont(MangoStyle.FONT_REGULAR);
        JPanel scrollZoomUpInPanel = new JPanel();
        scrollZoomUpInPanel.setLayout(new BoxLayout(scrollZoomUpInPanel, 0));
        scrollZoomUpInPanel.add(this.scrollZoomDefault);
        scrollZoomUpInPanel.add(Box.createHorizontalGlue());
        this.scrollZoomFlip = new JRadioButton("Flip Direction");
        this.scrollZoomFlip.setFont(MangoStyle.FONT_REGULAR);
        this.scrollZoomFlip.setSelected(true);
        JPanel scrollZoomDownInPanel = new JPanel();
        scrollZoomDownInPanel.setLayout(new BoxLayout(scrollZoomDownInPanel, 0));
        scrollZoomDownInPanel.add(this.scrollZoomFlip);
        scrollZoomDownInPanel.add(Box.createHorizontalGlue());
        ButtonGroup scrollZoomGroup = new ButtonGroup();
        scrollZoomGroup.add(this.scrollZoomDefault);
        scrollZoomGroup.add(this.scrollZoomFlip);
        JPanel scrollZoomPanel = new JPanel();
        scrollZoomPanel.setLayout(new BoxLayout(scrollZoomPanel, 1));
        scrollZoomPanel.add(zoomDirectionLabelPanel);
        scrollZoomPanel.add(Box.createVerticalStrut(2));
        scrollZoomPanel.add(scrollZoomUpInPanel);
        scrollZoomPanel.add(Box.createVerticalStrut(2));
        scrollZoomPanel.add(scrollZoomDownInPanel);
        scrollZoomPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JLabel openGl = new JLabel("OpenGL");
        openGl.setFont(Mango.FONT_HEADING);
        JPanel openGlPanel = new JPanel();
        openGlPanel.setLayout(new BoxLayout(openGlPanel, 0));
        openGlPanel.add(Box.createHorizontalGlue());
        openGlPanel.add(openGl);
        openGlPanel.add(Box.createHorizontalGlue());
        this.openGlGood = new JRadioButton("Default Graphics");
        this.openGlGood.setFont(MangoStyle.FONT_REGULAR);
        JPanel openGlGoodPanel = new JPanel();
        openGlGoodPanel.setLayout(new BoxLayout(openGlGoodPanel, 0));
        openGlGoodPanel.add(this.openGlGood);
        openGlGoodPanel.add(Box.createHorizontalGlue());
        this.openGlBetter = new JRadioButton("Better Graphics");
        this.openGlBetter.setFont(MangoStyle.FONT_REGULAR);
        this.openGlBetter.setEnabled(!Platform.MAC || !Platform.OSX_TIGER && !Platform.OSX_LEOPARD);
        JPanel openGlBetterPanel = new JPanel();
        openGlBetterPanel.setLayout(new BoxLayout(openGlBetterPanel, 0));
        openGlBetterPanel.add(this.openGlBetter);
        openGlBetterPanel.add(Box.createHorizontalGlue());
        ButtonGroup openGlGroup = new ButtonGroup();
        openGlGroup.add(this.openGlGood);
        openGlGroup.add(this.openGlBetter);
        JPanel openGlOptionsPanel = new JPanel();
        openGlOptionsPanel.setLayout(new BoxLayout(openGlOptionsPanel, 1));
        openGlOptionsPanel.add(openGlPanel);
        openGlOptionsPanel.add(Box.createVerticalStrut(2));
        openGlOptionsPanel.add(openGlBetterPanel);
        openGlOptionsPanel.add(Box.createVerticalStrut(2));
        openGlOptionsPanel.add(openGlGoodPanel);
        openGlOptionsPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JPanel displayTab = new JPanel(new GridLayout(2, 3));
        displayTab.add(this.makePreferencePanel(interpPanel, INFO_SMOOTH_DISPLAY));
        displayTab.add(this.makePreferencePanel(retinaOptionsPanel, INFO_RETINA));
        displayTab.add(this.makePreferencePanel(displayPanel, INFO_RADIOLOGICAL));
        displayTab.add(this.makePreferencePanel(overlayPanel, INFO_OVERLAY_COLOR_TABLES));
        displayTab.add(this.makePreferencePanel(openGlOptionsPanel, INFO_OPENGL));
        displayTab.add(this.makePreferencePanel(scrollZoomPanel, INFO_SCROLL_DIRECTION));
        this.tabbedPane.addTab("Display", displayTab);
        JLabel quickKey = new JLabel("Quick Toggle");
        quickKey.setFont(Mango.FONT_HEADING);
        JPanel quickPanel = new JPanel();
        quickPanel.setLayout(new BoxLayout(quickPanel, 0));
        quickPanel.add(Box.createHorizontalGlue());
        quickPanel.add(quickKey);
        quickPanel.add(Box.createHorizontalGlue());
        this.makeROIEditPopupMenuFirst();
        this.makeROIEditPopupMenuSecond();
        this.roiEditButtonFirst = new MangoSquareButton(MangoStyle.ICON_EDIT_ROI.get(0), false, this.mango);
        this.roiEditButtonFirst.setActionCommand("roiEditButtonToggleFirst");
        this.roiEditButtonFirst.addActionListener(this);
        this.roiEditButtonFirst.setPreferredSize(new Dimension(35, 35));
        this.roiEditButtonFirst.setMinimumSize(this.roiEditButtonFirst.getPreferredSize());
        this.roiEditButtonFirst.setMaximumSize(this.roiEditButtonFirst.getPreferredSize());
        SquareButtonPanel firstPanel = new SquareButtonPanel();
        firstPanel.setLayout(new BoxLayout(firstPanel, 0));
        firstPanel.add(this.roiEditButtonFirst);
        firstPanel.setBackground(Color.WHITE);
        this.roiEditButtonSecond = new MangoSquareButton(MangoStyle.ICON_EDIT_ROI.get(0), false, this.mango);
        this.roiEditButtonSecond.setActionCommand("roiEditButtonToggleSecond");
        this.roiEditButtonSecond.addActionListener(this);
        this.roiEditButtonSecond.setPreferredSize(new Dimension(35, 35));
        this.roiEditButtonSecond.setMinimumSize(this.roiEditButtonSecond.getPreferredSize());
        this.roiEditButtonSecond.setMaximumSize(this.roiEditButtonSecond.getPreferredSize());
        SquareButtonPanel secondPanel = new SquareButtonPanel();
        secondPanel.setLayout(new BoxLayout(secondPanel, 0));
        secondPanel.add(this.roiEditButtonSecond);
        secondPanel.setBackground(Color.WHITE);
        JLabel quickKeyLabel = new JLabel("\u2194");
        quickKeyLabel.setFont(new Font("SansSerif", 1, 24));
        quickKeyLabel.setMinimumSize(quickKeyLabel.getPreferredSize());
        quickKeyLabel.setMaximumSize(quickKeyLabel.getPreferredSize());
        JPanel quickKeyPanelIn = new JPanel();
        quickKeyPanelIn.setLayout(new BoxLayout(quickKeyPanelIn, 0));
        quickKeyPanelIn.add(firstPanel);
        quickKeyPanelIn.add(Box.createHorizontalStrut(6));
        quickKeyPanelIn.add(quickKeyLabel);
        quickKeyPanelIn.add(Box.createHorizontalStrut(6));
        quickKeyPanelIn.add(secondPanel);
        quickKeyPanelIn.setMaximumSize(quickKeyPanelIn.getPreferredSize());
        quickKeyPanelIn.setMinimumSize(quickKeyPanelIn.getPreferredSize());
        JPanel quickKeyPanel = new JPanel();
        quickKeyPanel.setLayout(new BoxLayout(quickKeyPanel, 1));
        quickKeyPanel.add(quickPanel);
        quickKeyPanel.add(Box.createVerticalStrut(8));
        quickKeyPanel.add(quickKeyPanelIn);
        quickKeyPanel.add(Box.createVerticalGlue());
        quickKeyPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        quickKeyPanel.setMaximumSize(quickKeyPanel.getPreferredSize());
        quickKeyPanel.setMinimumSize(quickKeyPanel.getPreferredSize());
        JLabel functionLabel = new JLabel("Function Keys");
        functionLabel.setFont(Mango.FONT_HEADING);
        JPanel functionLabelPanel = new JPanel();
        functionLabelPanel.setLayout(new BoxLayout(functionLabelPanel, 0));
        functionLabelPanel.add(Box.createHorizontalGlue());
        functionLabelPanel.add(functionLabel);
        functionLabelPanel.add(Box.createHorizontalGlue());
        this.makeActionNames();
        this.functionBox = new MangoComboBox<String>((T[])this.allActionNames);
        this.functionBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.functionBox.getPreferredSize().height));
        this.functionBox.setFont(MangoStyle.FONT_SMALL);
        this.functionBox.addActionListener(this);
        this.functionBox.setActionCommand("function box");
        this.functionBox.setPrototypeDisplayValue("                                   ");
        JPanel functionBoxPanel = new JPanel();
        functionBoxPanel.setLayout(new BoxLayout(functionBoxPanel, 0));
        functionBoxPanel.add(this.functionBox);
        this.functionKeyBox = new MangoComboBox<String>((T[])FUNCTION_KEY_NAMES);
        this.functionKeyBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.functionKeyBox.getPreferredSize().height));
        this.functionKeyBox.setFont(MangoStyle.FONT_SMALL);
        this.functionKeyBox.addActionListener(this);
        this.functionKeyBox.setActionCommand("function key box");
        this.functionKeyBox.setPrototypeDisplayValue("                                   ");
        JPanel functionKeyBoxPanel = new JPanel();
        functionKeyBoxPanel.setLayout(new BoxLayout(functionKeyBoxPanel, 0));
        functionKeyBoxPanel.add(this.functionKeyBox);
        this.functionBox.setRenderer(new FunctionBoxRenderer2(this.allActions));
        this.functionKeyBox.setRenderer(new FunctionBoxRenderer(this.allActions));
        JPanel boxPanel = new JPanel();
        boxPanel.setLayout(new BoxLayout(boxPanel, 1));
        boxPanel.add(Box.createVerticalStrut(2));
        boxPanel.add(functionKeyBoxPanel);
        boxPanel.add(Box.createVerticalStrut(4));
        boxPanel.add(functionBoxPanel);
        JPanel functionPanel = new JPanel();
        functionPanel.setLayout(new BoxLayout(functionPanel, 1));
        functionPanel.add(functionLabelPanel);
        functionPanel.add(Box.createVerticalStrut(2));
        functionPanel.add(boxPanel);
        functionPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JLabel scrollwheelLabel = new JLabel("Scroll Wheel");
        scrollwheelLabel.setFont(Mango.FONT_HEADING);
        JPanel scrollwheelLabelPanel = new JPanel();
        scrollwheelLabelPanel.setLayout(new BoxLayout(scrollwheelLabelPanel, 0));
        scrollwheelLabelPanel.add(Box.createHorizontalGlue());
        scrollwheelLabelPanel.add(scrollwheelLabel);
        scrollwheelLabelPanel.add(Box.createHorizontalGlue());
        this.scrollZoomButton = new JRadioButton("Zooms Slice");
        this.scrollZoomButton.setFont(MangoStyle.FONT_REGULAR);
        JPanel zoomButtonPanel = new JPanel();
        zoomButtonPanel.setLayout(new BoxLayout(zoomButtonPanel, 0));
        zoomButtonPanel.add(this.scrollZoomButton);
        zoomButtonPanel.add(Box.createHorizontalGlue());
        this.sliceButton = new JRadioButton("Changes Slice");
        this.sliceButton.setFont(MangoStyle.FONT_REGULAR);
        JPanel sliceButonPanel = new JPanel();
        sliceButonPanel.setLayout(new BoxLayout(sliceButonPanel, 0));
        sliceButonPanel.add(this.sliceButton);
        sliceButonPanel.add(Box.createHorizontalGlue());
        ButtonGroup scrollGroup = new ButtonGroup();
        scrollGroup.add(this.scrollZoomButton);
        scrollGroup.add(this.sliceButton);
        JPanel scrollPanel = new JPanel();
        scrollPanel.setLayout(new BoxLayout(scrollPanel, 1));
        scrollPanel.add(scrollwheelLabelPanel);
        scrollPanel.add(Box.createVerticalStrut(2));
        scrollPanel.add(zoomButtonPanel);
        scrollPanel.add(Box.createVerticalStrut(2));
        scrollPanel.add(sliceButonPanel);
        scrollPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JPanel shortcutsTab = new JPanel(new GridLayout(2, 3));
        shortcutsTab.add(this.makePreferencePanel(quickKeyPanel, INFO_QUICK_KEY));
        shortcutsTab.add(this.makePreferencePanel(functionPanel, INFO_FUNCTION_KEYS));
        shortcutsTab.add(this.makePreferencePanel(scrollPanel, INFO_SCROLL));
        shortcutsTab.add(new JPanel());
        shortcutsTab.add(new JPanel());
        shortcutsTab.add(new JPanel());
        this.tabbedPane.addTab("Shortcuts", shortcutsTab);
        this.infoLabel = new JLabel(INFO_DEFAULT, 0);
        this.infoLabel.setForeground(Color.GRAY);
        this.infoLabel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        JPanel infoLabelPanel = new JPanel();
        infoLabelPanel.setLayout(new BoxLayout(infoLabelPanel, 0));
        infoLabelPanel.add(Box.createHorizontalGlue());
        infoLabelPanel.add(this.infoLabel);
        infoLabelPanel.add(Box.createHorizontalGlue());
        infoLabelPanel.setPreferredSize(new Dimension(infoLabelPanel.getPreferredSize().width, 40));
        infoLabelPanel.setMinimumSize(infoLabelPanel.getPreferredSize());
        infoLabelPanel.setMaximumSize(infoLabelPanel.getPreferredSize());
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.add((Component)infoLabelPanel, "South");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                PreferencesDialog.this.clearSelected(null);
            }
        });
        this.loadPreferences();
    }

    private String getStringObject(String string) {
        if (string == null) {
            return null;
        }
        for (String allActionName : this.allActionNames) {
            if (!string.equals(allActionName)) continue;
            return allActionName;
        }
        return null;
    }

    private final void loadPreferences() {
        if (Mango.isVoxelDisplay()) {
            this.voxelDisplayVoxelButton.setSelected(true);
            this.voxelDisplaySmoothButton.setSelected(false);
        } else {
            this.voxelDisplayVoxelButton.setSelected(false);
            this.voxelDisplaySmoothButton.setSelected(true);
        }
        if (Mango.isRetinaDisplayMode() && Platform.isRetinaCapable()) {
            this.retinaOnButton.setSelected(true);
            this.retinaOffButton.setSelected(false);
        } else {
            this.retinaOnButton.setSelected(false);
            this.retinaOffButton.setSelected(true);
        }
        if (this.mango.isAutoCheck()) {
            this.checkAutoButton.setSelected(true);
            this.checkManualButton.setSelected(false);
        } else {
            this.checkAutoButton.setSelected(false);
            this.checkManualButton.setSelected(true);
        }
        if (this.mango.isListenForFiles()) {
            this.listenOnButton.setSelected(true);
            this.listenOffButton.setSelected(false);
            this.listenPort.setEnabled(true);
            this.listenPortLabel.setEnabled(true);
        } else {
            this.listenOnButton.setSelected(false);
            this.listenOffButton.setSelected(true);
            this.listenPort.setEnabled(false);
            this.listenPortLabel.setEnabled(false);
        }
        this.listenPort.setText(String.valueOf(this.mango.getPort()));
        if (this.mango.isCaptureToDesktop()) {
            this.desktopButton.setSelected(true);
            this.imageButton.setSelected(false);
        } else {
            this.desktopButton.setSelected(false);
            this.imageButton.setSelected(true);
        }
        if (this.mango.isRadiologicalMode()) {
            this.neurologicalButton.setSelected(false);
            this.radiologicalButton.setSelected(true);
        } else {
            this.neurologicalButton.setSelected(true);
            this.radiologicalButton.setSelected(false);
        }
        if (this.mango.isScrollwheelSlices()) {
            this.scrollZoomButton.setSelected(false);
            this.sliceButton.setSelected(true);
        } else {
            this.scrollZoomButton.setSelected(true);
            this.sliceButton.setSelected(false);
        }
        if (this.mango.isScrollwheelDirectionFlip()) {
            this.scrollZoomDefault.setSelected(false);
            this.scrollZoomFlip.setSelected(true);
        } else {
            this.scrollZoomDefault.setSelected(true);
            this.scrollZoomFlip.setSelected(false);
        }
        if (SurfaceViewer.isUseShaders()) {
            this.openGlGood.setSelected(false);
            this.openGlBetter.setSelected(true);
        } else {
            this.openGlGood.setSelected(true);
            this.openGlBetter.setSelected(false);
        }
        if (this.mango.isToolboxCoordinateCurrentSlice()) {
            this.coordinateMouse.setSelected(false);
            this.coordinateCurrent.setSelected(true);
        } else {
            this.coordinateMouse.setSelected(true);
            this.coordinateCurrent.setSelected(false);
        }
        String origin = PreferencesDialog.makeImageIndexOriginString(this.mango.getImageIndexOrigin());
        if (origin.equals(CORNER_DEFAULT)) {
            this.indexDefault.setSelected(true);
        } else {
            this.indexCustom.setSelected(true);
            this.indexBox.setSelectedItem(origin);
        }
        this.overlayBox1.setSelectedItem(Mango.getInstance().getOverlayColorTable1());
        this.overlayBox2.setSelectedItem(Mango.getInstance().getOverlayColorTable2());
        this.overlayBox3.setSelectedItem(Mango.getInstance().getOverlayColorTable3());
        this.roiEditButtonFirst.setIcon(MangoStyle.ICON_EDIT_ROI.get(this.mango.getQuickKeyFirst()));
        this.roiEditButtonSecond.setIcon(MangoStyle.ICON_EDIT_ROI.get(this.mango.getQuickKeySecond()));
        this.updateFunctions();
    }

    private JPanel makePreferencePanel(final JPanel innerPanel, final String infoText) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(innerPanel);
        panel.setBorder(null);
        SwingWidgetUtilities.addMouseListenerToAllComponents((Container)innerPanel, (MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                PreferencesDialog.this.clearSelected(innerPanel);
                SwingWidgetUtilities.colorBackgroundOfAllComponents((Container)innerPanel, (Color)Color.LIGHT_GRAY, (Class[])new Class[]{JTextField.class, MangoSquareButton.class, MangoComboBox.class, SquareButtonPanel.class});
                PreferencesDialog.this.infoLabel.setText(infoText);
                PreferencesDialog.this.infoLabel.setForeground(Color.DARK_GRAY);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                if (!innerPanel.getVisibleRect().contains(me.getPoint())) {
                    SwingWidgetUtilities.colorBackgroundOfAllComponents((Container)innerPanel, null, (Class[])new Class[]{JTextField.class, MangoSquareButton.class, MangoComboBox.class, SquareButtonPanel.class});
                    PreferencesDialog.this.infoLabel.setText(PreferencesDialog.INFO_DEFAULT);
                    PreferencesDialog.this.infoLabel.setForeground(Color.GRAY);
                }
            }
        });
        panel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.allPanels.add(panel);
        return panel;
    }

    private void makeROIEditPopupMenuFirst() {
        final MangoSquareMenu subMenuEdit = new MangoSquareMenu(MangoStyle.ICON_EDIT_ROI.get(1));
        subMenuEdit.setPreferredSize(new Dimension(30, 30));
        subMenuEdit.setBackground(Toolbox.POPUP_MENU_ITEM_COLOR);
        subMenuEdit.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                PreferencesDialog.this.roiEditButtonFirst.setIcon(MangoStyle.ICON_EDIT_ROI.get(1));
                subMenuEdit.getPopupMenu().setVisible(false);
                PreferencesDialog.this.popupROIEditFirst.setVisible(false);
            }
        });
        final MangoSquareMenu subMenuRectangle = new MangoSquareMenu(MangoStyle.ICON_EDIT_ROI.get(7));
        subMenuRectangle.setPreferredSize(new Dimension(30, 30));
        subMenuRectangle.setBackground(Toolbox.POPUP_MENU_ITEM_COLOR);
        subMenuRectangle.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                PreferencesDialog.this.roiEditButtonFirst.setIcon(MangoStyle.ICON_EDIT_ROI.get(7));
                subMenuRectangle.getPopupMenu().setVisible(false);
                PreferencesDialog.this.popupROIEditFirst.setVisible(false);
            }
        });
        final MangoSquareMenu subMenuMagicWand = new MangoSquareMenu(MangoStyle.ICON_EDIT_ROI.get(12));
        subMenuMagicWand.setPreferredSize(new Dimension(30, 30));
        subMenuMagicWand.setBackground(Toolbox.POPUP_MENU_ITEM_COLOR);
        subMenuMagicWand.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                PreferencesDialog.this.roiEditButtonFirst.setIcon(MangoStyle.ICON_EDIT_ROI.get(12));
                subMenuMagicWand.getPopupMenu().setVisible(false);
                PreferencesDialog.this.popupROIEditFirst.setVisible(false);
            }
        });
        this.popupROIEditFirst = new JPopupMenu();
        for (int ctr = 0; ctr < MangoStyle.ICON_EDIT_ROI.size(); ++ctr) {
            MangoSquareMenuItem mi = new MangoSquareMenuItem(MangoStyle.ICON_EDIT_ROI.get(ctr));
            mi.setPreferredSize(new Dimension(30, 30));
            mi.setBackground(Toolbox.POPUP_MENU_ITEM_COLOR);
            mi.setContentAreaFilled(true);
            mi.setActionCommand("roiEditButtonChosenFirst" + ctr);
            mi.addActionListener(this);
            if (ctr == 1) {
                this.popupROIEditFirst.add(subMenuEdit);
            } else if (ctr == 7) {
                this.popupROIEditFirst.add(subMenuRectangle);
            } else if (ctr == 12) {
                this.popupROIEditFirst.add(subMenuMagicWand);
            } else {
                this.popupROIEditFirst.add(mi);
            }
            if (ctr >= 2 && ctr <= 6) {
                subMenuEdit.add(mi);
            } else if (ctr >= 8 && ctr <= 11) {
                subMenuRectangle.add(mi);
            } else if (ctr >= 13) {
                subMenuMagicWand.add(mi);
            }
            this.popupROIEditFirst.addPopupMenuListener(this);
        }
    }

    private void makeROIEditPopupMenuSecond() {
        final MangoSquareMenu subMenuEdit = new MangoSquareMenu(MangoStyle.ICON_EDIT_ROI.get(1));
        subMenuEdit.setPreferredSize(new Dimension(30, 30));
        subMenuEdit.setBackground(Toolbox.POPUP_MENU_ITEM_COLOR);
        subMenuEdit.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                PreferencesDialog.this.roiEditButtonSecond.setIcon(MangoStyle.ICON_EDIT_ROI.get(1));
                subMenuEdit.getPopupMenu().setVisible(false);
                PreferencesDialog.this.popupROIEditSecond.setVisible(false);
            }
        });
        final MangoSquareMenu subMenuRectangle = new MangoSquareMenu(MangoStyle.ICON_EDIT_ROI.get(7));
        subMenuRectangle.setPreferredSize(new Dimension(30, 30));
        subMenuRectangle.setBackground(Toolbox.POPUP_MENU_ITEM_COLOR);
        subMenuRectangle.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                PreferencesDialog.this.roiEditButtonSecond.setIcon(MangoStyle.ICON_EDIT_ROI.get(7));
                subMenuRectangle.getPopupMenu().setVisible(false);
                PreferencesDialog.this.popupROIEditSecond.setVisible(false);
            }
        });
        final MangoSquareMenu subMenuMagicWand = new MangoSquareMenu(MangoStyle.ICON_EDIT_ROI.get(12));
        subMenuMagicWand.setPreferredSize(new Dimension(30, 30));
        subMenuMagicWand.setBackground(Toolbox.POPUP_MENU_ITEM_COLOR);
        subMenuMagicWand.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                PreferencesDialog.this.roiEditButtonSecond.setIcon(MangoStyle.ICON_EDIT_ROI.get(12));
                subMenuMagicWand.getPopupMenu().setVisible(false);
                PreferencesDialog.this.popupROIEditSecond.setVisible(false);
            }
        });
        this.popupROIEditSecond = new JPopupMenu();
        for (int ctr = 0; ctr < MangoStyle.ICON_EDIT_ROI.size(); ++ctr) {
            MangoSquareMenuItem mi = new MangoSquareMenuItem(MangoStyle.ICON_EDIT_ROI.get(ctr));
            mi.setPreferredSize(new Dimension(30, 30));
            mi.setBackground(Toolbox.POPUP_MENU_ITEM_COLOR);
            mi.setContentAreaFilled(true);
            mi.setActionCommand("roiEditButtonChosenSecond" + ctr);
            mi.addActionListener(this);
            if (ctr == 1) {
                this.popupROIEditSecond.add(subMenuEdit);
            } else if (ctr == 7) {
                this.popupROIEditSecond.add(subMenuRectangle);
            } else if (ctr == 12) {
                this.popupROIEditSecond.add(subMenuMagicWand);
            } else {
                this.popupROIEditSecond.add(mi);
            }
            if (ctr >= 2 && ctr <= 6) {
                subMenuEdit.add(mi);
            } else if (ctr >= 8 && ctr <= 11) {
                subMenuRectangle.add(mi);
            } else if (ctr >= 13) {
                subMenuMagicWand.add(mi);
            }
            this.popupROIEditSecond.addPopupMenuListener(this);
        }
    }

    private void makeActionNames() {
        int totalCtr = 0;
        Set<String> treeSet = MangoMenuUtil.getActionSet();
        for (String action : Mango.getFActions()) {
            if (!StringUtils.isNotBlank((CharSequence)action) || action.equals("(Not Assigned)")) continue;
            treeSet.add(action);
        }
        this.allActionNames = new String[treeSet.size() + 1];
        this.allActionNames[0] = "(Not Assigned)";
        totalCtr = 1;
        Iterator<String> it = treeSet.iterator();
        while (it.hasNext()) {
            this.allActionNames[totalCtr++] = it.next();
        }
    }

    private void updateFunctions() {
        this.freezeFunctionBox = true;
        String[] strings = this.mango.getAllFunctionKeyActions();
        for (int ctr = 0; ctr < Mango.getFActions().length; ++ctr) {
            this.allActions[ctr] = strings[ctr];
        }
        this.functionBox.removeAllItems();
        this.makeActionNames();
        for (String allActionName : this.allActionNames) {
            this.functionBox.addItem(allActionName);
        }
        int selectedIndex = this.functionKeyBox.getSelectedIndex();
        String action = this.allActions[selectedIndex];
        String so = this.getStringObject(action);
        if (so == null) {
            this.allActions[selectedIndex] = "(Not Assigned)";
            so = this.getStringObject(this.allActions[selectedIndex]);
        }
        this.functionBox.setSelectedItem(so);
        this.freezeFunctionBox = false;
    }
}

