/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.modal.file;

import edu.uthscsa.ric.mango.dialogs.modal.file.MangoFileFilter;
import edu.uthscsa.ric.mango.platform.Platform;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import javax.swing.JFileChooser;

public final class OpenFileDialog {
    private static boolean open;

    private OpenFileDialog() {
    }

    public static File showOpenFileChooser(Window window, String startDirectory, String[] extensions, String description) {
        if (Platform.MAC) {
            FileDialog fileDialog = null;
            fileDialog = window instanceof Frame ? new FileDialog((Frame)window, "Open File", 0) : (window instanceof Dialog ? new FileDialog((Dialog)window, "Open File", 0) : new FileDialog((Frame)null, "Open File", 0));
            fileDialog.setDirectory(startDirectory);
            fileDialog.setFilenameFilter(new MangoFileFilter(extensions, null));
            open = true;
            fileDialog.setVisible(true);
            open = false;
            String selectedFileString = fileDialog.getFile();
            String selectedDirString = fileDialog.getDirectory();
            if (selectedFileString != null && selectedFileString.length() > 0) {
                return new File(selectedDirString, selectedFileString);
            }
            return null;
        }
        JFileChooser fileChooser = new JFileChooser();
        if (startDirectory != null) {
            fileChooser.setCurrentDirectory(new File(startDirectory));
        }
        if (extensions != null && description != null) {
            fileChooser.addChoosableFileFilter(new MangoFileFilter(extensions, description));
            fileChooser.setFileFilter(fileChooser.getChoosableFileFilters()[fileChooser.getChoosableFileFilters().length - 1]);
        }
        open = true;
        int value = fileChooser.showOpenDialog(null);
        open = false;
        File selectedFile = null;
        if (value == 0) {
            selectedFile = fileChooser.getSelectedFile();
        }
        return selectedFile;
    }

    public static File showOpenFolderChooser(Object frame, String startDirectory) {
        if (Platform.MAC) {
            FileDialog fileDialog = null;
            fileDialog = frame instanceof Frame ? new FileDialog((Frame)frame, "Open Folder", 0) : new FileDialog((Dialog)frame, "Open Folder", 0);
            fileDialog.setDirectory(startDirectory);
            fileDialog.setFilenameFilter(new MangoFileFilter(true));
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
            open = true;
            fileDialog.setVisible(true);
            open = false;
            System.setProperty("apple.awt.fileDialogForDirectories", "false");
            String selectedFileString = fileDialog.getFile();
            String selectedDirString = fileDialog.getDirectory();
            if (selectedFileString != null && selectedFileString.length() > 0) {
                return new File(selectedDirString, selectedFileString);
            }
            return null;
        }
        JFileChooser fileChooser = new JFileChooser();
        if (startDirectory != null) {
            fileChooser.setCurrentDirectory(new File(startDirectory));
        }
        fileChooser.setFileSelectionMode(1);
        open = true;
        int value = fileChooser.showOpenDialog(null);
        open = false;
        File selectedFile = null;
        if (value == 0) {
            selectedFile = fileChooser.getSelectedFile();
        }
        return selectedFile;
    }

    public static boolean isOpen() {
        return open;
    }
}

