/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.modal;

import edu.uthscsa.ric.mango.ImageLoader;
import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.components.MangoPlaceholderTextField;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPaneItem;
import edu.uthscsa.ric.mango.dialogs.modal.PluginManagerDialog;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.utilities.AppLogger;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class URLLoaderDialog
extends JPanel
implements MangoFocusableOptionPaneItem {
    private final JTabbedPane tabbedPane;
    private final JTextField result;
    private JButton cancelButton;
    private final Vector<ImageLoader> loaders = new Vector();
    private static final long serialVersionUID = 1L;
    public static final String MESSAGE = "Enter a URL or make a selection from below...";
    public static final int MODE_IMAGE = 0;
    public static final int MODE_OVERLAY = 1;
    public static final int MODE_ROI = 2;

    public URLLoaderDialog(Mango mango, SliceViewer viewer, int mode, JButton loadButton) {
        this.result = new MangoPlaceholderTextField(MESSAGE, 30);
        this.result.setMinimumSize(this.result.getPreferredSize());
        this.result.setMaximumSize(this.result.getPreferredSize());
        JLabel label = new JLabel("URL: ");
        JPanel directPanel = new JPanel();
        directPanel.setLayout(new BoxLayout(directPanel, 0));
        directPanel.add(label);
        directPanel.add(this.result);
        this.tabbedPane = new JTabbedPane();
        Vector<ImageLoader> allLoaders = mango.getToolBox().getLoaders();
        Enumeration<ImageLoader> en = allLoaders.elements();
        while (en.hasMoreElements()) {
            ImageLoader il = en.nextElement();
            ImageLoader ilNew = null;
            try {
                ilNew = (ImageLoader)il.getClass().newInstance();
                JPanel selectionPanel = null;
                if (mode == 0) {
                    selectionPanel = ilNew.getImageSelectionPanel(loadButton);
                } else if (mode == 1) {
                    selectionPanel = ilNew.getOverlaySelectionPanel(viewer.getLoadedFile().getName(), viewer.getVolume().getImageDimensions(), viewer.getVolume().getVoxelDimensions(), loadButton);
                } else if (mode == 2) {
                    selectionPanel = ilNew.getROISelectionPanel(viewer.getLoadedFile().getName(), viewer.getVolume().getImageDimensions(), viewer.getVolume().getVoxelDimensions(), loadButton);
                }
                if (selectionPanel == null) continue;
                this.tabbedPane.addTab(PluginManagerDialog.getPluginName(ilNew), selectionPanel);
                this.loaders.add(ilNew);
            }
            catch (IllegalAccessException ex) {
                AppLogger.error((Throwable)ex);
            }
            catch (InstantiationException ex) {
                AppLogger.error((Throwable)ex);
            }
        }
        this.setLayout(new BoxLayout(this, 1));
        this.add(directPanel);
        this.add(this.tabbedPane);
    }

    public String getURL() {
        String url = null;
        if (this.hasUserEnteredURL()) {
            url = this.result.getText();
        } else {
            int selectedIndex = this.tabbedPane.getSelectedIndex();
            if (selectedIndex >= 0) {
                ImageLoader selectedLoader = this.loaders.get(selectedIndex);
                url = selectedLoader.getSelectedAbsolutePath();
            }
        }
        return url;
    }

    public boolean isImportingInWorldSpace() {
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        if (selectedIndex >= 0) {
            ImageLoader selectedLoader = this.loaders.get(selectedIndex);
            return selectedLoader.isImportingInWorldSpace();
        }
        return false;
    }

    public boolean isImportingROI() {
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        if (selectedIndex >= 0) {
            ImageLoader selectedLoader = this.loaders.get(selectedIndex);
            return selectedLoader.isImportingROI();
        }
        return false;
    }

    public boolean isParametricOverlay() {
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        if (selectedIndex >= 0) {
            ImageLoader selectedLoader = this.loaders.get(selectedIndex);
            return selectedLoader.isParametricOverlay();
        }
        return false;
    }

    public boolean isPublic() {
        if (this.hasUserEnteredURL()) {
            return true;
        }
        int selectedIndex = this.tabbedPane.getSelectedIndex();
        if (selectedIndex >= 0) {
            ImageLoader selectedLoader = this.loaders.get(selectedIndex);
            return selectedLoader.isPublic();
        }
        return false;
    }

    private boolean hasUserEnteredURL() {
        return this.result.getText().trim().length() > 0 && !this.result.getText().equals(MESSAGE);
    }

    @Override
    public void doFocus() {
        if (this.cancelButton != null) {
            this.cancelButton.requestFocus();
        }
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public void setCancelButton(JButton cancelButton) {
        this.cancelButton = cancelButton;
    }
}

