/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.imagebrowser;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;

public class ImagePreviewData {
    private boolean noData;
    private final BufferedImage image;
    private final byte[] data;
    private final int numBytes;

    protected ImagePreviewData(int width, int height, int numBytes) {
        this.numBytes = numBytes;
        this.image = new BufferedImage(width, height, 10);
        this.data = new byte[width * height * numBytes];
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public byte[] getImageData() {
        return this.data;
    }

    public int getNumBytes() {
        return this.numBytes;
    }

    public byte[] getPreviewData() {
        return ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public boolean isNoData() {
        return this.noData;
    }

    public void setNoData(boolean noData) {
        this.noData = noData;
    }
}

