/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.imagebrowser;

import edu.uthscsa.ric.mango.dialogs.imagebrowser.FileNode;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.FileTreeRenderer;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.ImageFolderListener;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.NodeTransferHandler;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.TreePathComponentComparator;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class ImageFolder
extends JPanel
implements MouseListener,
TreeWillExpandListener {
    private DefaultTreeModel fileTreeModel;
    private File parentDir;
    private Point savedScrollPosition;
    private final ImageFolderListener listener;
    private final JScrollPane scrollPane;
    private final JTree fileTree;
    private final Vector<Object[]> expandedNodes = new Vector();
    private static final long serialVersionUID = 1L;

    protected ImageFolder(File parentDir, ImageFolderListener listener) {
        this.parentDir = parentDir;
        this.listener = listener;
        FileNode rootNode = new FileNode(parentDir);
        this.fileTreeModel = new DefaultTreeModel(rootNode);
        this.fileTree = new JTree(this.fileTreeModel);
        this.fileTree.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.fileTree.setEditable(false);
        this.fileTree.setDragEnabled(true);
        this.fileTree.setTransferHandler(new NodeTransferHandler());
        this.fileTree.setToggleClickCount(0);
        this.fileTree.addMouseListener(this);
        this.fileTree.setCellRenderer(new FileTreeRenderer());
        this.fileTree.addTreeWillExpandListener(this);
        this.fileTree.addTreeSelectionListener((TreeSelectionListener)((Object)listener));
        this.fileTree.setScrollsOnExpand(true);
        this.fileTree.setFocusable(false);
        this.fileTree.getActionMap().remove("selectAll");
        this.fileTree.getActionMap().getParent().remove("selectAll");
        this.fileTreeModel.reload();
        this.fileTree.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    ImageFolder.this.listener.openSelected();
                }
            }

            @Override
            public void keyReleased(KeyEvent ke) {
            }

            @Override
            public void keyTyped(KeyEvent ke) {
            }
        });
        this.scrollPane = new JScrollPane(this.fileTree);
        this.scrollPane.setFocusable(false);
        this.scrollPane.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mwe) {
                ImageFolder.this.savedScrollPosition = null;
            }
        });
        this.scrollPane.getVerticalScrollBar().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                ImageFolder.this.savedScrollPosition = null;
            }
        });
        this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.setLayout(new BorderLayout());
        this.add(this.scrollPane);
        this.loadRootInBackground(rootNode);
    }

    public File getParentDir() {
        return this.parentDir;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int selRow = this.fileTree.getRowForLocation(e.getX(), e.getY());
        TreePath selPath = this.fileTree.getPathForLocation(e.getX(), e.getY());
        if (selRow != -1 && e.getClickCount() == 2) {
            FileNode node = (FileNode)selPath.getLastPathComponent();
            if (node.isDirectory()) {
                this.changeFolder(selPath);
            } else {
                this.listener.openSelected();
            }
        }
    }

    public void setParentDir(File dir) {
        this.parentDir = dir;
        this.fileTreeModel.setRoot(new FileNode(this.parentDir));
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        FileNode lazyNode;
        TreePath path = event.getPath();
        Object lastPathComponent = path.getLastPathComponent();
        if (lastPathComponent instanceof FileNode && !(lazyNode = (FileNode)lastPathComponent).isChildrenLoaded()) {
            this.loadNodeInBackground(path, lazyNode);
            throw new ExpandVetoException(event);
        }
    }

    protected JTree getTree() {
        return this.fileTree;
    }

    protected void refreshFolder() {
        this.storeExpandedState();
        FileNode rootNode = new FileNode(this.parentDir);
        this.fileTreeModel = new DefaultTreeModel(rootNode);
        this.fileTree.setModel(this.fileTreeModel);
        this.loadRootInBackground(rootNode);
    }

    private void changeFolder(TreePath path) {
        FileNode node = (FileNode)path.getLastPathComponent();
        File file = node.getFile();
        if (!file.equals(this.parentDir)) {
            this.listener.updateCurrentFolder(file, false);
        }
    }

    private void expandNode(final TreePath path) {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                ImageFolder.this.fileTree.expandPath(path);
                ImageFolder.this.restoreNextExpandedState();
            }
        });
    }

    private void loadNodeInBackground(final TreePath path, final FileNode lazyNode) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Timer scanningTimer = ImageFolder.this.startScanningTimer(lazyNode);
                    lazyNode.loadImages();
                    scanningTimer.cancel();
                    scanningTimer = null;
                    ImageFolder.this.expandNode(path);
                }
                finally {
                    lazyNode.setScanning(false);
                    ImageFolder.this.reloadNode(lazyNode);
                }
            }
        }, "ImageFolder.loadNodeInBackground() Thread");
        workThread.start();
    }

    private void loadRootInBackground(final FileNode rootNode) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                rootNode.loadImages();
                ImageFolder.this.reloadTree();
            }
        }, "ImageFolder.loadRootInBackground() Thread");
        workThread.start();
    }

    private void reloadNode(final FileNode node) {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                ImageFolder.this.fileTreeModel.nodeChanged(node);
                ImageFolder.this.fileTree.repaint();
            }
        });
    }

    private void reloadTree() {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                ImageFolder.this.fileTreeModel.reload();
                ImageFolder.this.fileTree.repaint();
                ImageFolder.this.restoreNextExpandedState();
            }
        });
    }

    private void restoreNextExpandedState() {
        boolean restored = false;
        Iterator<Object[]> it = this.expandedNodes.iterator();
        if (it.hasNext()) {
            restored = true;
            Object[] paths = it.next();
            TreePath path = null;
            for (Object part : paths) {
                block5: {
                    int row = path == null ? 0 : this.fileTree.getRowForPath(path);
                    try {
                        path = this.fileTree.getNextMatch(part.toString(), row + 1, Position.Bias.Forward);
                    }
                    catch (IllegalArgumentException iae) {
                        if (!AppLogger.isDebugEnabled()) break block5;
                        AppLogger.debug((String)iae.getMessage());
                    }
                }
                if (path == null) break;
            }
            this.fileTree.expandPath(path);
            it.remove();
        }
        if (!restored && this.savedScrollPosition != null) {
            this.scrollPane.getViewport().setViewPosition(this.savedScrollPosition);
            this.savedScrollPosition = null;
        }
    }

    private Timer startScanningTimer(final FileNode node) {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                node.setScanning(true);
                ImageFolder.this.reloadNode(node);
            }
        };
        Timer scanningTimer = new Timer(true);
        scanningTimer.schedule(task, 1000L);
        return scanningTimer;
    }

    private void storeExpandedState() {
        this.expandedNodes.clear();
        Enumeration<TreePath> en = this.fileTree.getExpandedDescendants(new TreePath(this.fileTreeModel.getRoot()));
        while (en.hasMoreElements()) {
            TreePath path = en.nextElement();
            if (path.getPathCount() <= 1) continue;
            this.expandedNodes.add(path.getPath());
        }
        Collections.sort(this.expandedNodes, new TreePathComponentComparator());
        this.savedScrollPosition = this.scrollPane.getViewport().getViewPosition();
    }

    public File[] getExpandedSubFolders() {
        Vector<File> expanded = new Vector<File>();
        Enumeration<TreePath> en = this.fileTree.getExpandedDescendants(new TreePath(this.fileTreeModel.getRoot()));
        while (en.hasMoreElements()) {
            Object[] comps;
            TreePath path = en.nextElement();
            if (path.getPathCount() <= 1) continue;
            StringBuffer sbFile = new StringBuffer(this.parentDir.getParent());
            for (Object comp : comps = path.getPath()) {
                sbFile.append('/');
                sbFile.append(comp.toString().trim());
            }
            expanded.add(new File(sbFile.toString()));
        }
        return expanded.toArray(new File[expanded.size()]);
    }
}

