/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.imagebrowser;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.core.LoadItem;
import edu.uthscsa.ric.mango.core.StringComparator;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.FileNode;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.HeaderInfo;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.ImageFileFilter;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.ImageFolder;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.ImageFolderListener;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.PathLabel;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.PreviewPanel;
import edu.uthscsa.ric.mango.dialogs.imagebrowser.SurfaceInfo;
import edu.uthscsa.ric.mango.dialogs.modal.file.OpenFileDialog;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreePath;

public class ImageBrowser
extends JFrame
implements ActionListener,
ImageFolderListener,
TreeSelectionListener {
    private boolean parentFolderBoxFreeze;
    private final JButton closeFolderButton;
    private final JButton loadImageButton;
    private final JButton refreshFolderButton;
    private final JComboBox<PathLabel> parentFolderBox;
    private final JLabel currentFolderLabel;
    private final JLabel filterDotLabel;
    private final JLabel filterLabel;
    private final JTabbedPane folderTabPanel;
    private final Mango mango;
    private final MangoTextField filterExtText;
    private final MangoTextField filterNameText;
    private final PreviewPanel previewPanel;
    private static final long serialVersionUID = 1L;
    protected static final FileSystemView FILE_SYSTEM_VIEW = FileSystemView.getFileSystemView();
    protected static final ImageFileFilter FILE_FILTER = new ImageFileFilter("*", "*");
    public static final Dimension START_SIZE = new Dimension(550, 500);
    public static final String ACTION_ADD_FOLDER = "Add...";
    public static final String ACTION_CLOSE_FOLDER = "Close";
    public static final String ACTION_FILTER_FILES = "Filter Files";
    public static final String ACTION_LOAD_IMAGE = "Open";
    public static final String ACTION_PARENT_FOLDER_SELECTED = "Parent Folder Selected";
    public static final String ACTION_REFRESH_FOLDER = "Update";
    public static final String TITLE = "Image Browser";
    public static final int MAX_FOLDER_NAME_PREFIX_SIZE = 15;
    public static final int MAX_FOLDER_NAME_SIZE = 25;
    public static final int MAX_FOLDER_NAME_SUFFIX_SIZE = 5;

    public ImageBrowser(Mango mango) {
        this.mango = mango;
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 2, 4));
        this.parentFolderBox = new JComboBox();
        this.parentFolderBox.setActionCommand(ACTION_PARENT_FOLDER_SELECTED);
        this.parentFolderBox.addActionListener(this);
        this.refreshFolderButton = new JButton(ACTION_REFRESH_FOLDER);
        this.refreshFolderButton.addActionListener(this);
        JButton addFolderButton = new JButton(ACTION_ADD_FOLDER);
        addFolderButton.addActionListener(this);
        this.closeFolderButton = new JButton(ACTION_CLOSE_FOLDER);
        this.closeFolderButton.addActionListener(this);
        this.loadImageButton = new JButton(ACTION_LOAD_IMAGE);
        this.loadImageButton.addActionListener(this);
        buttonPanel.add(this.refreshFolderButton);
        buttonPanel.add(Box.createHorizontalStrut(2));
        buttonPanel.add(this.closeFolderButton);
        buttonPanel.add(Box.createHorizontalStrut(2));
        buttonPanel.add(addFolderButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.parentFolderBox);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.loadImageButton);
        this.folderTabPanel = new JTabbedPane();
        this.folderTabPanel.setPreferredSize(START_SIZE);
        this.folderTabPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                ImageBrowser.this.selectFolder(ImageBrowser.this.getSelectedFolder(), true);
            }
        });
        this.previewPanel = new PreviewPanel();
        this.currentFolderLabel = new JLabel();
        JPanel currentFolderPanel = new JPanel();
        currentFolderPanel.setLayout(new BoxLayout(currentFolderPanel, 0));
        currentFolderPanel.add(this.currentFolderLabel);
        currentFolderPanel.add(Box.createHorizontalGlue());
        this.currentFolderLabel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.currentFolderLabel.setMinimumSize(new Dimension(0, 0));
        JPanel currentFolderPanelY = new JPanel();
        currentFolderPanelY.setLayout(new BoxLayout(currentFolderPanelY, 1));
        currentFolderPanelY.add(Box.createVerticalGlue());
        currentFolderPanelY.add(currentFolderPanel);
        this.filterLabel = new JLabel("File Filter:");
        this.filterDotLabel = new JLabel(".");
        this.filterNameText = new MangoTextField("*", 6);
        this.filterNameText.setActionCommand(ACTION_FILTER_FILES);
        this.filterNameText.addActionListener(this);
        this.filterNameText.setMaximumSize(this.filterNameText.getPreferredSize());
        this.filterNameText.setMinimumSize(this.filterNameText.getPreferredSize());
        this.filterExtText = new MangoTextField("*", 2);
        this.filterExtText.setActionCommand(ACTION_FILTER_FILES);
        this.filterExtText.addActionListener(this);
        this.filterExtText.setMaximumSize(this.filterExtText.getPreferredSize());
        this.filterExtText.setMinimumSize(this.filterExtText.getPreferredSize());
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new BoxLayout(filterPanel, 0));
        filterPanel.add(Box.createHorizontalGlue());
        filterPanel.add(this.filterLabel);
        filterPanel.add(Box.createHorizontalStrut(6));
        filterPanel.add(this.filterNameText);
        filterPanel.add(this.filterDotLabel);
        filterPanel.add(this.filterExtText);
        filterPanel.add(Box.createHorizontalStrut(6));
        filterPanel.setMinimumSize(filterPanel.getPreferredSize());
        filterPanel.setMaximumSize(filterPanel.getPreferredSize());
        JPanel filterPanelY = new JPanel();
        filterPanelY.setLayout(new BoxLayout(filterPanelY, 1));
        filterPanelY.add(Box.createVerticalGlue());
        filterPanelY.add(filterPanel);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.add(currentFolderPanelY);
        bottomPanel.add(filterPanelY);
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 6, 6));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)buttonPanel, "North");
        mainPanel.add((Component)this.folderTabPanel, "Center");
        mainPanel.add((Component)this.previewPanel, "East");
        mainPanel.add((Component)bottomPanel, "South");
        this.getContentPane().add((Component)mainPanel, "Center");
        this.setTitle(TITLE);
        this.setIconImage(MangoStyle.ICON_APP.getImage());
        this.pack();
        this.setLocation(DisplayUtils.getCenterDialogLocation(Mango.getInstance().getToolBox(), this.getSize()));
        this.setDefaultCloseOperation(1);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals(ACTION_ADD_FOLDER)) {
            this.addFolder(this.selectFolder());
        } else if (command.equals(ACTION_PARENT_FOLDER_SELECTED)) {
            PathLabel pathLabel;
            File pathLabelDir;
            if (!this.parentFolderBoxFreeze && (pathLabelDir = (pathLabel = (PathLabel)this.parentFolderBox.getSelectedItem()).getFile()) != null) {
                this.updateCurrentFolder(pathLabelDir, false);
            }
        } else if (command.equals(ACTION_REFRESH_FOLDER)) {
            ImageFolder folder = this.getSelectedFolder();
            folder.refreshFolder();
            this.previewPanel.clearPreview();
        } else if (command.equals(ACTION_CLOSE_FOLDER)) {
            this.closeCurrentFolder();
        } else if (command.equals(ACTION_FILTER_FILES)) {
            String filterExt;
            String filterName = this.filterNameText.getText();
            if (filterName.length() == 0) {
                this.filterNameText.setText("*");
                filterName = this.filterNameText.getText();
            }
            if ((filterExt = this.filterExtText.getText()).length() == 0) {
                this.filterExtText.setText("*");
                filterExt = this.filterExtText.getText();
            }
            FILE_FILTER.setFilter(filterName, filterExt);
            this.updateCurrentFolder(null, false);
        } else if (command.equals(ACTION_LOAD_IMAGE)) {
            this.openSelected();
        }
    }

    public boolean addFolder() {
        return this.addFolder(this.getDefaultFolder());
    }

    public boolean addFolder(File dir) {
        boolean success = false;
        if (dir != null && dir.exists()) {
            ImageFolder imageFolder = new ImageFolder(dir, this);
            this.folderTabPanel.addTab(this.makeNiceFolderName(FILE_SYSTEM_VIEW.getSystemDisplayName(dir)), imageFolder);
            this.selectFolder(imageFolder, true);
            success = true;
        }
        this.updateEnabledItems();
        return success;
    }

    public File[] getAllFolders() {
        int count = this.folderTabPanel.getTabCount();
        File[] files = new File[count];
        for (int ctr = 0; ctr < count; ++ctr) {
            files[ctr] = ((ImageFolder)this.folderTabPanel.getComponentAt(ctr)).getParentDir();
        }
        return files;
    }

    @Override
    public void openSelected() {
        TreeSet<Object> loadSet = new TreeSet<Object>(new StringComparator());
        ImageFolder folder = this.getSelectedFolder();
        TreePath[] selectedPaths = folder.getTree().getSelectionPaths();
        if (selectedPaths != null) {
            for (TreePath selectedPath : selectedPaths) {
                FileNode node = (FileNode)selectedPath.getLastPathComponent();
                if (node.getHeaderInfo() != null) {
                    LoadItem li = new LoadItem(node.getFile());
                    loadSet.add(li);
                    continue;
                }
                folder.getTree().expandPath(selectedPath);
            }
        }
        if (loadSet.size() > 0) {
            this.mango.addToLoadSet(loadSet);
        }
    }

    public void toggleVisible() {
        this.setVisible(!Mango.getInstance().getImageBrowser().isVisible());
    }

    @Override
    public void updateCurrentFolder(final File dir, final boolean doBlur) {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                ImageFolder folder = ImageBrowser.this.getSelectedFolder();
                if (dir != null) {
                    folder.setParentDir(dir);
                }
                folder.refreshFolder();
                ImageBrowser.this.updateParentFolderBox();
                ImageBrowser.this.currentFolderLabel.setText(folder.getParentDir().toString());
                ImageBrowser.this.folderTabPanel.setTitleAt(ImageBrowser.this.folderTabPanel.indexOfComponent(folder), ImageBrowser.this.makeNiceFolderName(FILE_SYSTEM_VIEW.getSystemDisplayName(folder.getParentDir())));
                if (doBlur) {
                    ImageBrowser.this.doBlur();
                }
            }
        });
    }

    public void updateImageFolder(final File file, final boolean requestFocus) {
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                if (file != null) {
                    File parentFolder = file.getParentFile();
                    int count = ImageBrowser.this.folderTabPanel.getTabCount();
                    int deepestIndex = -1;
                    ImageFolder deepest = null;
                    block0: for (int ctr = 0; ctr < count; ++ctr) {
                        int index;
                        File[] expandedFolders;
                        ImageFolder folder = (ImageFolder)ImageBrowser.this.folderTabPanel.getComponentAt(ctr);
                        File parentDir = folder.getParentDir();
                        for (File dir : expandedFolders = folder.getExpandedSubFolders()) {
                            if (!dir.equals(parentFolder)) continue;
                            deepest = folder;
                            break block0;
                        }
                        if (!FileUtilities.containsFile((File)parentDir, (File)file) || (index = FileUtilities.getPathComponents((File)parentDir).length) <= deepestIndex) continue;
                        deepestIndex = index;
                        deepest = folder;
                    }
                    if (deepest != null) {
                        ImageBrowser.this.selectFolder(deepest, requestFocus);
                        deepest.refreshFolder();
                        ImageBrowser.this.updateParentFolderBox();
                        ImageBrowser.this.currentFolderLabel.setText(deepest.getParentDir().toString());
                        ImageBrowser.this.folderTabPanel.setTitleAt(ImageBrowser.this.folderTabPanel.indexOfComponent(deepest), ImageBrowser.this.makeNiceFolderName(FILE_SYSTEM_VIEW.getSystemDisplayName(deepest.getParentDir())));
                    }
                    ImageBrowser.this.doBlur();
                } else {
                    ImageFolder folder = ImageBrowser.this.getSelectedFolder();
                    folder.refreshFolder();
                    ImageBrowser.this.previewPanel.clearPreview();
                }
            }
        });
    }

    @Override
    public void valueChanged(TreeSelectionEvent tse) {
        FileNode node = (FileNode)this.getSelectedFolder().getTree().getLastSelectedPathComponent();
        if (node != null) {
            File file = node.getFile();
            HeaderInfo header = node.getHeaderInfo();
            SurfaceInfo surface = node.getSurfaceInfo();
            if (header != null) {
                this.previewPanel.updatePreview(node, file, header);
            } else if (surface != null) {
                this.previewPanel.updatePreview(node, file, surface);
            } else {
                this.previewPanel.clearPreview();
            }
            this.currentFolderLabel.setText(file.toString());
        }
    }

    private void closeCurrentFolder() {
        this.folderTabPanel.remove(this.getSelectedFolder());
        this.previewPanel.clearPreview();
    }

    private void doBlur() {
        JFrame currentViewerFrame = Mango.getInstance().getCurrentViewerFrame();
        if (currentViewerFrame != null) {
            currentViewerFrame.requestFocus();
        }
    }

    private File getDefaultFolder() {
        return new File(Platform.getHomeDirectory());
    }

    private ImageFolder getSelectedFolder() {
        Component comp = this.folderTabPanel.getSelectedComponent();
        if (comp != null) {
            return (ImageFolder)comp;
        }
        return null;
    }

    private String makeNiceFolderName(String str) {
        if (str.length() > 25) {
            String prefix = str.substring(0, 15);
            String suffix = str.substring(str.length() - 5);
            return prefix + "..." + suffix;
        }
        return str;
    }

    private File selectFolder() {
        String directory = this.mango.getLoadFileDirectory();
        File selectedFile = OpenFileDialog.showOpenFolderChooser(Mango.getInstance().getToolBox(), directory);
        return selectedFile;
    }

    private void selectFolder(ImageFolder imageFolder, boolean requestFocus) {
        if (imageFolder != null) {
            this.folderTabPanel.setSelectedComponent(imageFolder);
            this.currentFolderLabel.setText(imageFolder.getParentDir().toString());
            imageFolder.getTree().setFocusable(true);
            if (requestFocus) {
                imageFolder.getTree().requestFocus();
            }
            this.updateParentFolderBox();
        }
        this.updateEnabledItems();
    }

    private void updateEnabledItems() {
        ImageFolder folder = this.getSelectedFolder();
        if (folder == null) {
            this.currentFolderLabel.setText("");
            this.parentFolderBox.setEnabled(false);
            this.refreshFolderButton.setEnabled(false);
            this.closeFolderButton.setEnabled(false);
            this.loadImageButton.setEnabled(false);
            this.filterNameText.setEnabled(false);
            this.filterExtText.setEnabled(false);
            this.filterLabel.setEnabled(false);
            this.filterDotLabel.setEnabled(false);
        } else {
            this.parentFolderBox.setEnabled(true);
            this.refreshFolderButton.setEnabled(true);
            this.closeFolderButton.setEnabled(true);
            this.loadImageButton.setEnabled(true);
            this.filterNameText.setEnabled(true);
            this.filterExtText.setEnabled(true);
            this.filterLabel.setEnabled(true);
            this.filterDotLabel.setEnabled(true);
        }
        this.updateParentFolderBox();
    }

    private void updateParentFolderBox() {
        this.parentFolderBoxFreeze = true;
        this.parentFolderBox.removeAllItems();
        this.parentFolderBox.addItem(new PathLabel());
        ImageFolder imageFolder = this.getSelectedFolder();
        if (imageFolder != null) {
            File file = imageFolder.getParentDir();
            while (file.getParentFile() != null) {
                file = file.getParentFile();
                this.parentFolderBox.addItem(new PathLabel(file, FILE_SYSTEM_VIEW.getSystemDisplayName(file)));
            }
        }
        this.parentFolderBoxFreeze = false;
    }
}

