/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.imagebrowser;

import edu.uthscsa.ric.volume.ImageDescription;
import edu.uthscsa.ric.volume.ImageDimensions;
import edu.uthscsa.ric.volume.ImageType;
import edu.uthscsa.ric.volume.VoxelDimensions;
import java.io.File;
import java.net.URI;

public class HeaderInfo {
    private File headerFile;
    private File imageFile;
    private ImageDescription imageDes;
    private ImageDimensions imageDims;
    private ImageType imageType;
    private String headerTypeDes = "";
    private String imageName;
    private String orientation;
    private String otherInfo = "";
    private URI[] multiFiles;
    private VoxelDimensions voxelDims;
    private boolean error;
    private boolean roi;
    private float[] previewImage;
    private int[] multiOffsets;

    public File getHeaderFile() {
        return this.headerFile;
    }

    public String getHeaderTypeDes() {
        return this.headerTypeDes;
    }

    public ImageDescription getImageDes() {
        return this.imageDes;
    }

    public ImageDimensions getImageDims() {
        return this.imageDims;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public String getImageName() {
        return this.imageName;
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    public URI[] getMultiFiles() {
        return this.multiFiles;
    }

    public int[] getMultiOffsets() {
        return this.multiOffsets;
    }

    public String getOrientation() {
        if (this.orientation == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(this.orientation.substring(0, 3));
        boolean colOrientationFlip = false;
        boolean rowOrientationFlip = false;
        boolean sliceOrientationFlip = false;
        if (this.voxelDims.getColSize(false) < 0.0) {
            colOrientationFlip = true;
        }
        if (this.voxelDims.getRowSize(false) < 0.0) {
            rowOrientationFlip = true;
        }
        if (this.voxelDims.getSliceThickness(false) < 0.0) {
            sliceOrientationFlip = true;
        }
        if (colOrientationFlip) {
            if (this.orientation.charAt(3) == '-') {
                sb.append('+');
            } else {
                sb.append('-');
            }
        } else {
            sb.append(this.orientation.charAt(3));
        }
        if (rowOrientationFlip) {
            if (this.orientation.charAt(4) == '-') {
                sb.append('+');
            } else {
                sb.append('-');
            }
        } else {
            sb.append(this.orientation.charAt(4));
        }
        if (sliceOrientationFlip) {
            if (this.orientation.charAt(5) == '-') {
                sb.append('+');
            } else {
                sb.append('-');
            }
        } else {
            sb.append(this.orientation.charAt(5));
        }
        return sb.toString();
    }

    public String getOtherInfo() {
        return this.otherInfo;
    }

    public float[] getPreviewImage() {
        return this.previewImage;
    }

    public VoxelDimensions getVoxelDims() {
        return this.voxelDims;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isRoi() {
        return this.roi;
    }

    public boolean isUsingPreviewCompatibleCompression() {
        return this.imageType.getCompressionType() == 1;
    }

    public boolean isUsingCompression() {
        return this.imageType.getCompressionType() != 0;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public void setHeaderFile(File headerFile) {
        this.headerFile = headerFile;
    }

    public void setHeaderTypeDes(String headerTypeDes) {
        this.headerTypeDes = headerTypeDes;
    }

    public void setImageDes(ImageDescription imageDes) {
        this.imageDes = imageDes;
    }

    public void setImageDims(ImageDimensions imageDims) {
        this.imageDims = imageDims;
    }

    public void setImageFile(File imageFile) {
        this.imageFile = imageFile;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public void setImageType(ImageType imageType) {
        this.imageType = imageType;
    }

    public void setMultiFiles(File[] multiFiles) {
        URI[] uris = new URI[multiFiles.length];
        for (int ctr = 0; ctr < multiFiles.length; ++ctr) {
            uris[ctr] = multiFiles[ctr].toURI();
        }
        this.multiFiles = uris;
    }

    public void setMultiFiles(URI[] multiFiles) {
        this.multiFiles = multiFiles;
    }

    public void setMultiOffsets(int[] multiOffsets) {
        this.multiOffsets = multiOffsets;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public void setOtherInfo(String otherInfo) {
        this.otherInfo = otherInfo;
    }

    public void setPreviewImage(float[] previewImage) {
        this.previewImage = previewImage;
    }

    public void setRoi(boolean roi) {
        this.roi = roi;
    }

    public void setVoxelDims(VoxelDimensions voxelDims) {
        this.voxelDims = voxelDims;
    }

    public String toString() {
        return this.getImageName();
    }
}

