/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.console;

import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.StringUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class MemoryMonitorPanel
extends JPanel
implements MouseListener {
    private double percentage;
    private double used;
    private final String name;
    private final boolean direct;
    private final long maxBytes;
    private static final long serialVersionUID = 1L;
    public static final Dimension SIZE = new Dimension(50, 16);
    public static final String DIRECT_NAME = "Direct";
    public static final String JAVA_NAME = "Java";
    public static final int BORDER_INSET = 2;

    protected MemoryMonitorPanel(boolean isDirect) {
        this.direct = isDirect;
        this.name = isDirect ? DIRECT_NAME : JAVA_NAME;
        this.maxBytes = isDirect ? Platform.getMaxDirectMemory() : Runtime.getRuntime().maxMemory();
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.addMouseListener(this);
        this.setToolTipText(this.name + " Memory (click for more info)");
    }

    @Override
    public Dimension getMaximumSize() {
        return SIZE;
    }

    @Override
    public Dimension getMinimumSize() {
        return SIZE;
    }

    public double getPercentage() {
        return this.percentage;
    }

    @Override
    public Dimension getPreferredSize() {
        return SIZE;
    }

    public double getUsed() {
        return this.used;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.measure();
        this.setBorder(null);
        if (this.used > 0.0) {
            long reservedBytes = (long)((double)this.maxBytes * this.percentage);
            long usedBytes = (long)((double)this.maxBytes * this.used);
            long freeBytes = reservedBytes - usedBytes;
            AppLogger.info((String)(this.name + " Memory Usage: " + StringUtilities.makeNiceFileSizeString((long)reservedBytes) + " (" + StringUtilities.makeNiceFileSizeString((long)freeBytes) + " free) of " + StringUtilities.makeNiceFileSizeString((long)this.maxBytes)));
        } else {
            AppLogger.info((String)(this.name + " Memory Usage: " + StringUtilities.makeNiceFileSizeString((long)((int)((double)this.maxBytes * this.percentage))) + " of " + StringUtilities.makeNiceFileSizeString((long)this.maxBytes)));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setBorder(BorderFactory.createRaisedBevelBorder());
    }

    @Override
    public void paintComponent(Graphics g) {
        g.clearRect(0, 0, MemoryMonitorPanel.SIZE.width - 1, MemoryMonitorPanel.SIZE.height - 1);
        if (this.percentage < 0.5) {
            g.setColor(Color.GREEN);
        } else if (this.percentage < 0.9) {
            g.setColor(Color.YELLOW);
        } else {
            g.setColor(Color.RED);
        }
        g.fillRect(2, 2, (int)Math.round(this.percentage * (double)(MemoryMonitorPanel.SIZE.width - 2)), MemoryMonitorPanel.SIZE.height - 2);
        if (this.used > 0.0) {
            g.setColor(Color.BLUE);
            g.fillRect(2, 2, (int)Math.round(this.used * (double)(MemoryMonitorPanel.SIZE.width - 2)), MemoryMonitorPanel.SIZE.height - 2);
        }
    }

    public void setPercentage(double percentage) {
        this.percentage = percentage;
    }

    public void setUsed(double used) {
        this.used = used;
    }

    protected void measure() {
        if (this.direct) {
            this.percentage = (double)Platform.getUsedDirectMemory() / (double)Platform.getMaxDirectMemory();
        } else {
            this.percentage = (double)Runtime.getRuntime().totalMemory() / (double)Runtime.getRuntime().maxMemory();
            this.used = (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / (double)Runtime.getRuntime().maxMemory();
        }
    }
}

