/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.console;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import edu.uthscsa.ric.mango.dialogs.console.MemoryMonitorPanel;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.ConsoleLogger;
import edu.uthscsa.ric.utilities.DesktopUtilities;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class Console
extends JFrame
implements ActionListener,
ConsoleLogger,
ComponentListener {
    private Timer timer;
    private final JTextArea textArea = new JTextArea();
    private final MemoryMonitorPanel directMemoryPanel;
    private final MemoryMonitorPanel javaMemoryPanel;
    private static Console instance;
    private static final Dimension START_SIZE;
    private static final int SCAN_PERIOD = 2500;
    private static final long serialVersionUID = 1L;

    public static Console createConsole() {
        instance = new Console();
        return instance;
    }

    private Console() {
        this.textArea.setForeground(Color.WHITE);
        this.textArea.setBackground(Color.BLACK);
        this.textArea.setFont(new Font("SansSerif", 0, 12));
        this.textArea.setLineWrap(true);
        this.textArea.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.textArea.setEditable(false);
        JScrollPane scroller = new JScrollPane(this.textArea);
        JButton clearButton = new JButton("Clear");
        clearButton.setActionCommand("Clear");
        clearButton.addActionListener(this);
        clearButton.setFocusable(false);
        JButton copyButton = new JButton("Copy");
        copyButton.setActionCommand("Copy");
        copyButton.addActionListener(this);
        copyButton.setFocusable(false);
        JButton logsButton = new JButton("Show Logs");
        logsButton.setActionCommand("Show");
        logsButton.addActionListener(this);
        logsButton.setFocusable(false);
        this.javaMemoryPanel = new MemoryMonitorPanel(false);
        this.directMemoryPanel = new MemoryMonitorPanel(true);
        boolean canMeasureDirect = Platform.getUsedDirectMemory() != -1L;
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(copyButton);
        buttonPanel.add(clearButton);
        buttonPanel.add(logsButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(new JLabel("Memory:"));
        buttonPanel.add(Box.createHorizontalStrut(8));
        buttonPanel.add(this.javaMemoryPanel);
        if (canMeasureDirect) {
            buttonPanel.add(Box.createHorizontalStrut(8));
            buttonPanel.add(this.directMemoryPanel);
        } else {
            AppLogger.warn((String)"Cannot measure direct memory!  Memory usage meter represent only Java memory.");
        }
        buttonPanel.add(Box.createHorizontalStrut(8));
        this.getContentPane().add((Component)scroller, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.validate();
        this.setTitle("Console");
        this.setSize(START_SIZE);
        this.setIconImage(MangoStyle.ICON_APP.getImage());
        this.addComponentListener(this);
        this.setBackground(Color.LIGHT_GRAY);
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("Copy")) {
            StringSelection clipboardString = new StringSelection(this.textArea.getText());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(clipboardString, null);
        } else if (ae.getActionCommand().equals("Clear")) {
            this.textArea.setText("");
        } else if (ae.getActionCommand().equals("Show")) {
            DesktopUtilities.revealAndSelect((File)AppLogger.getLogFile());
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.stopMemoryMonitor();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.startMemoryMonitor();
    }

    @Override
    public Dimension getMinimumSize() {
        return START_SIZE;
    }

    public void println(String string) {
        this.textArea.append(string + "\n");
    }

    public void printPlatformInfo() {
        Mango mango = Mango.getInstance();
        AppLogger.info((String)("Mango: " + mango.getVersion() + "-b" + mango.getBuildNumber() + " (" + (Platform.MODE_64_BIT ? "64-bit" : "32-bit") + ") " + (Platform.VANILLA ? "[Vanilla]" : "")));
        AppLogger.info((String)("Java: " + Platform.JAVA_VERSION + " (" + (Platform.JAVA64BIT_DETECTED ? "64-bit" : "32-bit") + ") " + Platform.JAVA_VENDOR + " [" + Platform.getJavaHome() + "]"));
        AppLogger.info((String)("OS: " + Platform.OS + " " + Platform.VERSION));
        AppLogger.info((String)("Platform: " + Platform.getArchOS()));
        AppLogger.info((String)"");
    }

    private void startMemoryMonitor() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Console.this.javaMemoryPanel.measure();
                        Console.this.javaMemoryPanel.repaint();
                        Console.this.directMemoryPanel.measure();
                        Console.this.directMemoryPanel.repaint();
                    }
                });
            }
        };
        this.timer = new Timer(true);
        this.timer.schedule(task, 0L, 2500L);
    }

    private void stopMemoryMonitor() {
        this.timer.cancel();
        this.timer = null;
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    static {
        START_SIZE = new Dimension(600, 200);
    }
}

