/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.dialogs.cine;

import edu.uthscsa.ric.mango.ProgressMeter;
import edu.uthscsa.ric.mango.components.MangoTextField;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPane;
import edu.uthscsa.ric.mango.dialogs.cine.VideoCaptureListener;
import edu.uthscsa.ric.mango.dialogs.cine.VideoCaptureManager;
import edu.uthscsa.ric.mango.dialogs.modal.file.SaveFileDialog;
import edu.uthscsa.ric.mango.dialogs.script.Recordable;
import edu.uthscsa.ric.mango.dialogs.script.ScriptUtils;
import edu.uthscsa.ric.mango.viewerslice.SliceViewer;
import edu.uthscsa.ric.utilities.AppLogger;
import edu.uthscsa.ric.utilities.CollectionUtilities;
import edu.uthscsa.ric.utilities.DesktopUtilities;
import edu.uthscsa.ric.utilities.FileUtilities;
import edu.uthscsa.ric.utilities.JVMUtilities;
import edu.uthscsa.ric.utilities.SwingWidgetUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.avi.AVIWriter;
import org.monte.media.math.Rational;
import org.monte.media.quicktime.QuickTimeWriter;

public abstract class AbstractCine
extends JFrame
implements ActionListener,
VideoCaptureListener {
    private File videoFile;
    private Format videoFormat;
    private JButton playFileButton;
    private JButton showFileButton;
    private JComboBox<String> formatsBox;
    private JComboBox<String> fpsBox;
    private JComboBox<String> qualityBox;
    private JRadioButton autoButton;
    private JRadioButton recorderButton;
    private JTextField videoFileText;
    private Timer buttonAnimateTimer;
    private int recordingIndex;
    private int videoFps;
    private boolean silentRecording;
    private static final long serialVersionUID = 1L;
    protected JButton recordButton;
    protected JLabel autoSlicesLabel;
    protected JLabel infoLabel;
    protected JLabel recorderLabel;
    protected VideoCaptureManager videoCaptureManager;
    protected final SliceViewer viewer;
    public static final String EXT_AVI = ".avi";
    public static final String EXT_MOV = ".mov";
    public static final Integer RECOMMENDED_FPS = 30;
    public static final List<Boolean> COMPRESSABLE = CollectionUtilities.immutable((Boolean[])new Boolean[]{true, false, false, true, false, false});
    public static final List<Float> QUALITY = CollectionUtilities.immutable((Float[])new Float[]{Float.valueOf(1.0f), Float.valueOf(0.75f), Float.valueOf(0.5f)});
    public static final List<String> DIR_LABELS = CollectionUtilities.immutable((String[])new String[]{"axial", "coronal", "sagittal"});
    public static final List<String> EXTENSIONS = CollectionUtilities.immutable((String[])new String[]{".avi", ".avi", ".avi", ".mov", ".mov", ".mov"});
    public static final List<String> FORMATS = CollectionUtilities.immutable((String[])new String[]{"MJPG", "png ", "DIB ", "jpeg", "png ", "rle ", "raw "});
    public static final List<String> OPTION_FORMATS = CollectionUtilities.immutable((String[])new String[]{"AVI (MJPG)", "AVI (PNG)", "AVI (Raw)", "MOV (JPG)", "MOV (PNG)", "MOV (Raw)"});
    public static final List<Integer> FPS = CollectionUtilities.immutable((Integer[])new Integer[]{30, 25, 20, 15, 10, 5});
    public static final List<String> OPTION_FPS = CollectionUtilities.immutable((String[])new String[]{"30", "25", "20", "15", "10", "5"});
    public static final List<String> OPTION_QUALITY = CollectionUtilities.immutable((String[])new String[]{"Full", "75%", "50%"});
    public static final List<String> RECORD_ANIMATION_FRAME = CollectionUtilities.immutable((String[])new String[]{"|", "/", "-", "\\"});
    public static final String ACTION_PLAY = "ACTION_PLAY";
    public static final String ACTION_RECORD = "ACTION_RECORD";
    public static final String ACTION_SELECT_FILE = "ACTION_SELECT_FILE";
    public static final String ACTION_SHOW = "ACTION_SHOW";
    public static final String NAME = "Create Video";
    public static final int DEFAULT_BIT_DEPTH = 24;
    public static final int MAX_RECOMMENDED_FRAMES = 1200;
    public static final int PADDING = 8;

    public AbstractCine(SliceViewer viewer, VideoCaptureManager videoCaptureManager) {
        this(viewer, videoCaptureManager, false);
    }

    public AbstractCine(SliceViewer viewer, VideoCaptureManager videoCaptureManager, boolean silent) {
        this.viewer = viewer;
        this.videoCaptureManager = videoCaptureManager;
        if (!silent) {
            this.createUI();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals(ACTION_SELECT_FILE)) {
            this.editSaveFile();
            this.updateEnabled();
        } else if (command.equals(ACTION_RECORD)) {
            if (new File(this.videoFileText.getText()).exists()) {
                MangoFocusableOptionPane jopf = new MangoFocusableOptionPane(this, (Object)"<html>This file already exists and will be overwritten.</html>", "Warning: File Exists", 2, null, 2, (Object[])new String[]{"Continue", "Cancel"}, (Object)"Cancel");
                jopf.show();
                String returnValue = jopf.getReturnOption();
                if (returnValue.equals("Cancel")) {
                    return;
                }
            }
            if (this.buttonAnimateTimer != null) {
                this.stop();
            } else if (this.autoButton.isSelected()) {
                this.recordFlyThrough();
            } else {
                this.recordFree();
            }
        } else if (command.equals(ACTION_PLAY)) {
            this.play();
        } else if (command.equals(ACTION_SHOW)) {
            this.showFile();
        } else {
            this.updateEnabled();
            this.formatChanged();
            this.updateLabels();
        }
    }

    public abstract void animate();

    public abstract double getFrameRateAdjuster(boolean var1);

    public abstract void updateLabels();

    @Override
    public void videoCaptureEnded() {
        this.stop();
    }

    protected String getContainerAndCodec() {
        return FORMATS.get(this.formatsBox.getSelectedIndex());
    }

    protected int getFps() {
        String fpsStr = this.fpsBox.getSelectedItem().toString();
        return Integer.parseInt(fpsStr);
    }

    protected float getQuality() {
        return QUALITY.get(this.qualityBox.getSelectedIndex()).floatValue();
    }

    protected void setVideoCaptureManager(VideoCaptureManager videoCaptureManager) {
        this.videoCaptureManager = videoCaptureManager;
    }

    protected void stop() {
        Vector<BufferedImage> frames = this.videoCaptureManager.endVideoCapture();
        this.stop(frames);
    }

    protected void stop(Vector<BufferedImage> frames) {
        this.getRecordable().recordAction("captureVideoStop");
        this.stopRecordButtonAnimation();
        this.updateEnabled();
        this.formatChanged();
        this.viewer.setNavigationDisabled(false);
        this.processVideoCaptureFrames(frames);
    }

    protected void storeRecordingParameters() {
        this.videoFps = this.getFps();
        this.videoFormat = new Format(new Object[]{FormatKeys.EncodingKey, this.getContainerAndCodec(), VideoFormatKeys.DepthKey, 24, VideoFormatKeys.QualityKey, Float.valueOf(this.getQuality()), FormatKeys.FrameRateKey, new Rational(Math.round((double)this.videoFps * this.getFrameRateAdjuster(this.autoButton.isSelected())), 1L)});
        this.videoFile = new File(this.videoFileText.getText());
    }

    public void startSilentFreeRecording(int fps, int quality, int format, File file, boolean animate) {
        this.silentRecording = true;
        this.videoFps = fps;
        this.videoFormat = new Format(new Object[]{FormatKeys.EncodingKey, FORMATS.get(format), VideoFormatKeys.DepthKey, 24, VideoFormatKeys.QualityKey, QUALITY.get(quality), FormatKeys.FrameRateKey, new Rational(Math.round((double)this.videoFps * this.getFrameRateAdjuster(animate)), 1L)});
        this.videoFile = file;
        if (animate) {
            this.animateSilently();
        } else {
            this.videoCaptureManager.startVideoCapture(this.videoFps, this);
        }
    }

    public abstract void animateSilently();

    public void stopSilently(Vector<BufferedImage> frames) {
        this.doProcessVideoCaptureFrames(frames);
    }

    public void stopSilentRecording() {
        this.doProcessVideoCaptureFrames(this.videoCaptureManager.endVideoCapture());
    }

    public boolean isSilent() {
        return this.silentRecording;
    }

    private void createUI() {
        JLabel formatsLabel = new JLabel("Format: ");
        this.formatsBox = new JComboBox<String>(CollectionUtilities.array(OPTION_FORMATS));
        this.formatsBox.addActionListener(this);
        JLabel qualityLabel = new JLabel("Quality: ");
        this.qualityBox = new JComboBox<String>(CollectionUtilities.array(OPTION_QUALITY));
        JLabel fpsLabel = new JLabel("FPS: ");
        this.fpsBox = new JComboBox<String>(CollectionUtilities.array(OPTION_FPS));
        JPanel formatPanel = new JPanel();
        formatPanel.setLayout(new BoxLayout(formatPanel, 0));
        formatPanel.add(formatsLabel);
        formatPanel.add(this.formatsBox);
        formatPanel.add(Box.createHorizontalStrut(8));
        formatPanel.add(qualityLabel);
        formatPanel.add(this.qualityBox);
        formatPanel.add(Box.createHorizontalStrut(8));
        formatPanel.add(fpsLabel);
        formatPanel.add(this.fpsBox);
        KeyAdapter kl = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                AbstractCine.this.updateEnabled();
            }
        };
        this.videoFileText = new MangoTextField("", 25, kl, false, true);
        this.videoFileText.setMinimumSize(this.videoFileText.getPreferredSize());
        this.videoFileText.setMaximumSize(this.videoFileText.getPreferredSize());
        JButton videoFileSelectButton = new JButton("Select...");
        videoFileSelectButton.setActionCommand(ACTION_SELECT_FILE);
        videoFileSelectButton.addActionListener(this);
        this.videoFileText.setText(this.makeVideoFile().toString());
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BoxLayout(filePanel, 0));
        filePanel.add(new JLabel("File: "));
        filePanel.add(this.videoFileText);
        filePanel.add(videoFileSelectButton);
        this.autoButton = new JRadioButton();
        JLabel autoLabel = new JLabel("Animate ");
        autoLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                AbstractCine.this.autoButton.doClick();
            }
        });
        this.autoButton.addActionListener(this);
        this.autoSlicesLabel = new JLabel();
        this.autoSlicesLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                AbstractCine.this.autoButton.doClick();
            }
        });
        JPanel autoPanel = new JPanel();
        autoPanel.setLayout(new BoxLayout(autoPanel, 0));
        autoPanel.add(this.autoButton);
        autoPanel.add(autoLabel);
        autoPanel.add(this.autoSlicesLabel);
        autoPanel.add(Box.createHorizontalStrut(16));
        autoPanel.add(Box.createHorizontalGlue());
        this.recorderButton = new JRadioButton();
        this.recorderLabel = new JLabel();
        this.recorderLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                AbstractCine.this.recorderButton.doClick();
            }
        });
        this.recorderButton.addActionListener(this);
        JPanel recorderPanel = new JPanel();
        recorderPanel.setLayout(new BoxLayout(recorderPanel, 0));
        recorderPanel.add(this.recorderButton);
        recorderPanel.add(this.recorderLabel);
        recorderPanel.add(Box.createHorizontalGlue());
        ButtonGroup group = new ButtonGroup();
        group.add(this.autoButton);
        group.add(this.recorderButton);
        this.autoButton.setSelected(true);
        this.playFileButton = new JButton("Play Video");
        this.playFileButton.setActionCommand(ACTION_PLAY);
        this.playFileButton.addActionListener(this);
        this.showFileButton = new JButton("Show File");
        this.showFileButton.setActionCommand(ACTION_SHOW);
        this.showFileButton.addActionListener(this);
        this.recordButton = new JButton("Record");
        this.recordButton.setActionCommand(ACTION_RECORD);
        this.recordButton.addActionListener(this);
        this.recordButton.setPreferredSize(new Dimension(100, this.recordButton.getPreferredSize().height));
        this.recordButton.setMinimumSize(this.recordButton.getPreferredSize());
        this.recordButton.setMaximumSize(this.recordButton.getPreferredSize());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(this.playFileButton);
        buttonPanel.add(this.showFileButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.recordButton);
        this.infoLabel = new JLabel("", 0);
        this.infoLabel.setForeground(Color.GRAY);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 0));
        infoPanel.add(this.infoLabel);
        this.updateLabels();
        this.updateEnabled();
        this.formatChanged();
        this.fpsBox.setSelectedItem(String.valueOf(RECOMMENDED_FPS));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        mainPanel.add(formatPanel);
        mainPanel.add(Box.createVerticalStrut(8));
        mainPanel.add(autoPanel);
        mainPanel.add(recorderPanel);
        mainPanel.add(Box.createVerticalStrut(8));
        mainPanel.add(filePanel);
        mainPanel.add(Box.createVerticalStrut(8));
        mainPanel.add(buttonPanel);
        mainPanel.add(Box.createVerticalStrut(8));
        mainPanel.add(infoPanel);
        mainPanel.add(Box.createVerticalStrut(8));
        this.getContentPane().add((Component)mainPanel, "Center");
        this.setTitle("Create Video: " + this.viewer.getImageTitle());
        this.viewer.associatePluginWindow(NAME, this);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocation(this.viewer.findGoodPluginWindowLocation(this.getSize()));
        this.setResizable(false);
        this.setVisible(true);
        videoFileSelectButton.requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcessVideoCaptureFrames(Vector<BufferedImage> frames) {
        if (frames == null || frames.size() == 0) {
            return;
        }
        AVIWriter videoWriter = null;
        if (!this.silentRecording) {
            SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractCine.this.recordButton.setEnabled(false);
                    AbstractCine.this.recordButton.setText("Processing");
                }
            });
        }
        ProgressMeter progressBar = this.viewer.makeProgressMeter();
        progressBar.setDescription("Processing Video");
        progressBar.start(0, 0, frames.size());
        try {
            if (this.videoFile.getName().endsWith(EXT_AVI)) {
                videoWriter = new AVIWriter(this.videoFile);
            } else if (this.videoFile.getName().endsWith(EXT_MOV)) {
                videoWriter = new QuickTimeWriter(this.videoFile);
            } else {
                throw new UnsupportedOperationException("Only AVI and MOV containers are accepted.");
            }
            Dimension frameSize = this.videoCaptureManager.getVideoFrameDimensions();
            this.videoFormat = this.videoFormat.prepend(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.WidthKey, frameSize.width, VideoFormatKeys.HeightKey, frameSize.height});
            videoWriter.addTrack(this.videoFormat);
            videoWriter.setPalette(0, frames.get(0).getColorModel());
            Iterator<BufferedImage> it = frames.iterator();
            while (it.hasNext()) {
                videoWriter.write(0, it.next(), 1L);
                progressBar.setValue(progressBar.getCurrent() + 1);
            }
        }
        catch (IOException ex) {
            AppLogger.error((Throwable)ex);
        }
        catch (UnsupportedOperationException ex) {
            AppLogger.error((Throwable)ex);
        }
        finally {
            try {
                if (videoWriter != null) {
                    videoWriter.close();
                }
            }
            catch (IOException ex) {
                AppLogger.error((Throwable)ex);
            }
            progressBar.setValue(progressBar.getMax());
        }
        this.videoFormat = null;
        this.videoFile = null;
        frames.clear();
        JVMUtilities.clearGarbage();
        if (!this.silentRecording) {
            SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractCine.this.updateEnabled();
                    AbstractCine.this.recordButton.setEnabled(true);
                    AbstractCine.this.recordButton.setText("Record");
                }
            });
        }
    }

    private void editSaveFile() {
        File videoFile = new File(this.videoFileText.getText());
        File saveFile = SaveFileDialog.showSaveFileChooser(this, videoFile.getParent(), videoFile.getName());
        if (saveFile != null) {
            this.videoFileText.setText(saveFile.toString());
        }
        this.updateEnabled();
        this.formatChanged();
    }

    private void formatChanged() {
        boolean compressable = COMPRESSABLE.get(this.formatsBox.getSelectedIndex());
        if (!compressable) {
            this.qualityBox.setSelectedIndex(0);
        }
        this.qualityBox.setEnabled(compressable);
        String file = this.videoFileText.getText();
        if (file.lastIndexOf(46) != -1) {
            file = file.substring(0, file.lastIndexOf(46));
            file = file + EXTENSIONS.get(this.formatsBox.getSelectedIndex());
            this.videoFileText.setText(file);
        }
    }

    private File makeVideoFile() {
        String filename = this.viewer.getImageTitle() + EXTENSIONS.get(this.formatsBox.getSelectedIndex());
        File imageDir = this.viewer.getLoadedFile().getParentFile();
        File file = new File(this.viewer.getMango().getCapturableLocation(imageDir), filename);
        return FileUtilities.findUniqueFilename((File)file);
    }

    private void play() {
        DesktopUtilities.openFile((File)new File(this.videoFileText.getText()));
    }

    private void processVideoCaptureFrames(final Vector<BufferedImage> frames) {
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                AbstractCine.this.doProcessVideoCaptureFrames(frames);
            }
        });
        workThread.start();
    }

    protected void recordFlyThrough() {
        this.getRecordable().recordAction("captureVideoStart", new String[]{this.viewer.getScriptObjectName() + ".makeFilename(\"" + EXTENSIONS.get(this.formatsBox.getSelectedIndex()) + "\")", String.valueOf(this.formatsBox.getSelectedIndex()), String.valueOf(this.qualityBox.getSelectedIndex()), this.fpsBox.getSelectedItem().toString(), ScriptUtils.convertBoolean(true)}, true);
        this.animate();
    }

    public abstract Recordable getRecordable();

    private void recordFree() {
        this.getRecordable().recordAction("captureVideoStart", new String[]{this.viewer.getScriptObjectName() + ".makeFilename(\"" + EXTENSIONS.get(this.formatsBox.getSelectedIndex()) + "\")", String.valueOf(this.formatsBox.getSelectedIndex()), String.valueOf(this.qualityBox.getSelectedIndex()), this.fpsBox.getSelectedItem().toString(), ScriptUtils.convertBoolean(false)}, true);
        this.getRecordable().recordAction("pauseScriptForUserInput");
        this.storeRecordingParameters();
        this.videoCaptureManager.startVideoCapture(this.videoFps, this);
        this.startRecordButtonAnimation();
    }

    private void showFile() {
        DesktopUtilities.revealAndSelect((File)new File(this.videoFileText.getText()));
    }

    private void startRecordButtonAnimation() {
        this.stopRecordButtonAnimation();
        TimerTask buttonAnimateTask = new TimerTask(){

            @Override
            public void run() {
                SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AbstractCine.this.recordButton.setText("Stop " + RECORD_ANIMATION_FRAME.get(AbstractCine.this.recordingIndex));
                        AbstractCine.this.recordingIndex++;
                        AbstractCine.this.recordingIndex = AbstractCine.this.recordingIndex % RECORD_ANIMATION_FRAME.size();
                    }
                });
            }
        };
        this.buttonAnimateTimer = new Timer();
        this.buttonAnimateTimer.schedule(buttonAnimateTask, 0L, 500L);
    }

    private void stopRecordButtonAnimation() {
        if (this.buttonAnimateTimer != null) {
            this.buttonAnimateTimer.cancel();
            this.buttonAnimateTimer = null;
        }
        SwingWidgetUtilities.invokeLaterSafely((Runnable)new Runnable(){

            @Override
            public void run() {
                if (AbstractCine.this.recordButton != null) {
                    AbstractCine.this.recordButton.setText("Record");
                }
            }
        });
    }

    private void updateEnabled() {
        if (!this.silentRecording) {
            File videoFile = new File(this.videoFileText.getText());
            this.playFileButton.setEnabled(videoFile.exists());
            this.showFileButton.setEnabled(videoFile.exists());
        }
    }

    public boolean isRecording() {
        return this.buttonAnimateTimer != null;
    }
}

