/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.core;

import edu.uthscsa.ric.utilities.AppLogger;
import java.util.StringTokenizer;

public class Version {
    public int[] versionNums;
    public static final int VERSION_COMPONENTS = 3;

    public Version(String versionString) {
        if (versionString != null) {
            StringTokenizer tokenizer = new StringTokenizer(versionString, ".");
            this.versionNums = new int[3];
            int index = 0;
            while (tokenizer.hasMoreTokens() && index < 3) {
                String token = tokenizer.nextToken();
                int val = 0;
                try {
                    val = Math.abs(Integer.parseInt(token));
                }
                catch (NumberFormatException ex) {
                    AppLogger.info((Throwable)ex);
                }
                this.versionNums[index++] = val;
            }
        }
    }

    public boolean isGreaterThanOrEqualTo(Version ver) {
        if (this.versionNums != null && ver.versionNums != null) {
            for (int ctr = 0; ctr < 3; ++ctr) {
                if (this.versionNums[ctr] > ver.versionNums[ctr]) {
                    return true;
                }
                if (this.versionNums[ctr] >= ver.versionNums[ctr]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isLessThan(Version ver) {
        if (this.versionNums != null && ver.versionNums != null) {
            for (int ctr = 0; ctr < 3; ++ctr) {
                if (this.versionNums[ctr] < ver.versionNums[ctr]) {
                    return true;
                }
                if (this.versionNums[ctr] > ver.versionNums[ctr]) break;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.versionNums != null) {
            for (int ctr = 0; ctr < 3; ++ctr) {
                if (this.versionNums[ctr] == 0 && ctr == 2) continue;
                if (ctr != 0) {
                    sb.append('.');
                }
                sb.append(this.versionNums[ctr]);
            }
        } else {
            sb.append('0');
        }
        return sb.toString();
    }
}

