/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.components.multithumbslider;

import edu.uthscsa.ric.mango.components.multithumbslider.BasicMThumbSliderUI;
import edu.uthscsa.ric.mango.components.multithumbslider.MThumbSlider;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicSliderUI;

public class MThumbSliderAdditionalUI {
    private MThumbSlider mSlider;
    private Rectangle[] thumbRects;
    private int thumbNum;
    private final BasicSliderUI ui;
    private static Rectangle unionRect = new Rectangle();
    private transient boolean isDragging;
    protected ChangeHandler changeHandler;
    protected TrackListener trackListener;
    public static final int Y_OFFSET = 5;

    protected MThumbSliderAdditionalUI(BasicSliderUI ui) {
        this.ui = ui;
    }

    public int getThumbNum() {
        return this.thumbNum;
    }

    public Rectangle[] getThumbRects() {
        return this.thumbRects;
    }

    public Rectangle getTrackRect() {
        return ((BasicMThumbSliderUI)this.ui).getTrackRect();
    }

    protected void calculateThumbsLocation() {
        for (int i = 0; i < this.thumbNum; ++i) {
            if (this.mSlider.getSnapToTicks()) {
                int tickSpacing = this.mSlider.getMinorTickSpacing();
                if (tickSpacing == 0) {
                    tickSpacing = this.mSlider.getMajorTickSpacing();
                }
                if (tickSpacing != 0) {
                    int sliderValue;
                    int snappedValue = sliderValue = this.mSlider.getValueAt(i);
                    int min = this.mSlider.getMinimum();
                    if ((sliderValue - min) % tickSpacing != 0) {
                        float temp = (float)(sliderValue - min) / (float)tickSpacing;
                        int whichTick = Math.round(temp);
                        snappedValue = min + whichTick * tickSpacing;
                        this.mSlider.setValueAt(snappedValue, i);
                    }
                }
            }
            Rectangle trackRect = this.getTrackRect();
            if (this.mSlider.getOrientation() == 0) {
                int value = this.mSlider.getValueAt(i);
                int valuePosition = ((BasicMThumbSliderUI)this.ui).getxPositionForValue(value);
                this.thumbRects[i].x = valuePosition - this.thumbRects[i].width / 2;
                this.thumbRects[i].y = trackRect.y + 5;
                continue;
            }
            int valuePosition = ((BasicMThumbSliderUI)this.ui).getyPositionForValue(this.mSlider.getValueAt(i));
            this.thumbRects[i].x = trackRect.x;
            this.thumbRects[i].y = valuePosition - this.thumbRects[i].height / 2;
        }
    }

    protected void calculateThumbsSize() {
        Dimension size = ((BasicMThumbSliderUI)this.ui).getThumbSizePublic();
        for (int i = 0; i < this.thumbNum; ++i) {
            this.thumbRects[i].setSize(size.width, size.height);
        }
    }

    protected void installUI(JComponent c) {
        this.mSlider = (MThumbSlider)c;
        this.thumbNum = this.mSlider.getThumbNum();
        this.thumbRects = new Rectangle[this.thumbNum];
        for (int i = 0; i < this.thumbNum; ++i) {
            this.thumbRects[i] = new Rectangle();
        }
        this.isDragging = false;
        this.trackListener = new TrackListener(this.mSlider);
        this.changeHandler = new ChangeHandler();
    }

    protected void uninstallUI(JComponent c) {
        this.thumbRects = null;
        this.trackListener = null;
        this.changeHandler = null;
    }

    private void setThumbLocationAt(int x, int y, int index) {
        Rectangle rect = this.thumbRects[index];
        unionRect.setBounds(rect);
        rect.setLocation(x, y);
        SwingUtilities.computeUnion(rect.x, rect.y, rect.width, rect.height, unionRect);
        this.mSlider.repaint(MThumbSliderAdditionalUI.unionRect.x, MThumbSliderAdditionalUI.unionRect.y, MThumbSliderAdditionalUI.unionRect.width, MThumbSliderAdditionalUI.unionRect.height);
    }

    public class TrackListener
    extends MouseInputAdapter {
        protected int adjustingThumbIndex;
        protected Rectangle adjustingThumbRect;
        protected int clickCount;
        protected transient int currentMouseX;
        protected transient int currentMouseY;
        protected transient int offset;
        protected MThumbSlider slider;
        protected Rectangle trackRect;

        TrackListener(MThumbSlider slider) {
            this.slider = slider;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.slider.isEnabled()) {
                return;
            }
            if (!(this.slider.isEnabled() && MThumbSliderAdditionalUI.this.isDragging && this.slider.getValueIsAdjusting() && this.adjustingThumbRect != null)) {
                return;
            }
            int thumbMiddle = 0;
            int diff = 0;
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            Rectangle rect = MThumbSliderAdditionalUI.this.thumbRects[this.adjustingThumbIndex];
            this.trackRect = MThumbSliderAdditionalUI.this.getTrackRect();
            int sliderOrientation = this.slider.getOrientation();
            if (sliderOrientation == 1) {
                int halfThumbHeight = rect.height / 2;
                int thumbTop = e.getY() - this.offset;
                int trackTop = this.trackRect.y;
                int trackBottom = this.trackRect.y + (this.trackRect.height - 1);
                thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                MThumbSliderAdditionalUI.this.setThumbLocationAt(rect.x, thumbTop, this.adjustingThumbIndex);
                thumbMiddle = thumbTop + halfThumbHeight;
                MThumbSliderAdditionalUI.this.mSlider.setValueAt(MThumbSliderAdditionalUI.this.ui.valueForYPosition(thumbMiddle), this.adjustingThumbIndex);
            } else if (sliderOrientation == 0) {
                boolean specialClick;
                int halfThumbWidth = rect.width / 2;
                int thumbLeft = e.getX() - this.offset;
                int trackLeft = this.trackRect.x;
                int trackRight = this.trackRect.x + (this.trackRect.width - 1);
                thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                MThumbSliderAdditionalUI.this.setThumbLocationAt(thumbLeft, rect.y, this.adjustingThumbIndex);
                thumbMiddle = thumbLeft + halfThumbWidth;
                MThumbSliderAdditionalUI.this.mSlider.setValueAt(MThumbSliderAdditionalUI.this.ui.valueForXPosition(thumbMiddle), this.adjustingThumbIndex);
                boolean bl = specialClick = this.clickCount > 1 || e.getModifiersEx() == 1088;
                if (this.adjustingThumbIndex == 1 || !specialClick) {
                    if (this.adjustingThumbIndex == 0 && MThumbSliderAdditionalUI.this.mSlider.getValueAt(0) > MThumbSliderAdditionalUI.this.mSlider.getValueAt(2)) {
                        MThumbSliderAdditionalUI.this.setThumbLocationAt(thumbLeft, rect.y, 2);
                        MThumbSliderAdditionalUI.this.setThumbLocationAt(thumbLeft, rect.y, 1);
                        MThumbSliderAdditionalUI.this.mSlider.setValueAt(MThumbSliderAdditionalUI.this.ui.valueForXPosition(thumbMiddle), 2);
                        MThumbSliderAdditionalUI.this.mSlider.setValueAt(MThumbSliderAdditionalUI.this.ui.valueForXPosition(thumbMiddle), 1);
                    } else if (this.adjustingThumbIndex == 2 && MThumbSliderAdditionalUI.this.mSlider.getValueAt(0) > MThumbSliderAdditionalUI.this.mSlider.getValueAt(2)) {
                        MThumbSliderAdditionalUI.this.setThumbLocationAt(thumbLeft, rect.y, 0);
                        MThumbSliderAdditionalUI.this.setThumbLocationAt(thumbLeft, rect.y, 1);
                        MThumbSliderAdditionalUI.this.mSlider.setValueAt(MThumbSliderAdditionalUI.this.ui.valueForXPosition(thumbMiddle), 0);
                        MThumbSliderAdditionalUI.this.mSlider.setValueAt(MThumbSliderAdditionalUI.this.ui.valueForXPosition(thumbMiddle), 1);
                    } else if (this.adjustingThumbIndex == 1) {
                        diff = (((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[1].x - ((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[0].x + (((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[2].x - ((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[1].x)) / 2;
                        int thumbLeftLeft = ((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[1].x - diff;
                        int thumbLeftRight = ((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[1].x + diff;
                        thumbLeftLeft = Math.max(thumbLeftLeft, trackLeft - halfThumbWidth);
                        thumbLeftRight = Math.min(thumbLeftRight, trackRight - halfThumbWidth);
                        MThumbSliderAdditionalUI.this.setThumbLocationAt(thumbLeftLeft, rect.y, 0);
                        MThumbSliderAdditionalUI.this.setThumbLocationAt(thumbLeftRight, rect.y, 2);
                        MThumbSliderAdditionalUI.this.mSlider.setValueAt(MThumbSliderAdditionalUI.this.ui.valueForXPosition(thumbLeftLeft + halfThumbWidth), 0);
                        MThumbSliderAdditionalUI.this.mSlider.setValueAt(MThumbSliderAdditionalUI.this.ui.valueForXPosition(thumbLeftRight + halfThumbWidth), 2);
                    }
                    diff = (((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[2].x - ((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[0].x) / 2;
                    MThumbSliderAdditionalUI.this.setThumbLocationAt(((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[0].x + diff, rect.y, 1);
                    MThumbSliderAdditionalUI.this.mSlider.setValueAt(MThumbSliderAdditionalUI.this.ui.valueForXPosition(((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[1].x + halfThumbWidth), 1);
                } else if (specialClick) {
                    if (this.adjustingThumbIndex == 0) {
                        diff = Math.max(0, ((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[1].x - ((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[0].x);
                        diff = Math.min(diff, trackRight - halfThumbWidth - ((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[1].x);
                        MThumbSliderAdditionalUI.this.setThumbLocationAt(((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[1].x - diff, rect.y, 0);
                        MThumbSliderAdditionalUI.this.setThumbLocationAt(((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[1].x + diff, rect.y, 2);
                        MThumbSliderAdditionalUI.this.mSlider.setValueAt(MThumbSliderAdditionalUI.this.ui.valueForXPosition(((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[1].x - diff + halfThumbWidth), 0);
                        MThumbSliderAdditionalUI.this.mSlider.setValueAt(MThumbSliderAdditionalUI.this.ui.valueForXPosition(((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[1].x + diff + halfThumbWidth), 2);
                    } else if (this.adjustingThumbIndex == 2) {
                        diff = Math.max(0, ((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[2].x - ((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[1].x);
                        diff = Math.min(diff, ((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[1].x - (trackLeft - halfThumbWidth));
                        MThumbSliderAdditionalUI.this.setThumbLocationAt(((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[1].x - diff, rect.y, 0);
                        MThumbSliderAdditionalUI.this.setThumbLocationAt(((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[1].x + diff, rect.y, 2);
                        MThumbSliderAdditionalUI.this.mSlider.setValueAt(MThumbSliderAdditionalUI.this.ui.valueForXPosition(((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[1].x - diff + halfThumbWidth), 0);
                        MThumbSliderAdditionalUI.this.mSlider.setValueAt(MThumbSliderAdditionalUI.this.ui.valueForXPosition(((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).thumbRects[1].x + diff + halfThumbWidth), 2);
                    }
                }
                ((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).mSlider.toolBox.updateLUTInfo();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.slider.isEnabled()) {
                return;
            }
            if (!this.slider.isEnabled()) {
                return;
            }
            this.clickCount = e.getClickCount();
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            this.slider.requestFocus();
            for (int i = 0; i < MThumbSliderAdditionalUI.this.thumbNum; ++i) {
                Rectangle rect = MThumbSliderAdditionalUI.this.thumbRects[i];
                if (!rect.contains(this.currentMouseX, this.currentMouseY)) continue;
                int sliderOrientation = this.slider.getOrientation();
                if (sliderOrientation == 1) {
                    this.offset = this.currentMouseY - rect.y;
                } else if (sliderOrientation == 0) {
                    this.offset = this.currentMouseX - rect.x;
                }
                MThumbSliderAdditionalUI.this.isDragging = true;
                this.slider.setValueIsAdjusting(true);
                this.adjustingThumbRect = rect;
                this.adjustingThumbIndex = i;
            }
            if (this.adjustingThumbIndex == 1 && (e.getModifiersEx() == 1088 || this.clickCount == 2)) {
                MThumbSliderAdditionalUI.this.mSlider.setValueAt(MThumbSliderAdditionalUI.this.mSlider.getMinimum(), 0);
                MThumbSliderAdditionalUI.this.mSlider.setValueAt(MThumbSliderAdditionalUI.this.mSlider.getMaximum() / 2, 1);
                MThumbSliderAdditionalUI.this.mSlider.setValueAt(MThumbSliderAdditionalUI.this.mSlider.getMaximum(), 2);
                ((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).mSlider.toolBox.updateTextFieldValues();
                MThumbSliderAdditionalUI.this.mSlider.updateUI();
            }
            if (this.adjustingThumbIndex == 1 && (e.getModifiersEx() == 1216 || this.clickCount == 3)) {
                ((MThumbSliderAdditionalUI)MThumbSliderAdditionalUI.this).mSlider.toolBox.resetSliderValues();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this.slider.isEnabled()) {
                return;
            }
            if (!this.slider.isEnabled()) {
                return;
            }
            this.offset = 0;
            MThumbSliderAdditionalUI.this.isDragging = false;
            MThumbSliderAdditionalUI.this.mSlider.setValueIsAdjusting(false);
            MThumbSliderAdditionalUI.this.mSlider.repaint();
        }

        public boolean shouldScroll(int direction) {
            return false;
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            if (!MThumbSliderAdditionalUI.this.isDragging) {
                MThumbSliderAdditionalUI.this.calculateThumbsLocation();
                MThumbSliderAdditionalUI.this.mSlider.repaint();
            }
        }
    }
}

