/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.components.multithumbslider;

import edu.uthscsa.ric.mango.components.multithumbslider.BasicMThumbSliderUI;
import edu.uthscsa.ric.mango.components.multithumbslider.MThumbSliderUser;
import java.awt.Color;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JSlider;

public final class MThumbSlider
extends JSlider {
    private static final String UI_CLASS_ID = "MThumbSliderUI";
    private static final long serialVersionUID = 1L;
    BoundedRangeModel[] sliderModels;
    Color trackFillColor;
    Color[] fillColors;
    Icon[] thumbRenderers;
    MThumbSliderUser toolBox;
    int thumbNum;

    public MThumbSlider(int n, int[] mins, int[] maxs, int[] startingVals, MThumbSliderUser toolBox) {
        this.createThumbs(n, mins, maxs, startingVals);
        this.toolBox = toolBox;
        this.updateUI();
    }

    @Override
    public int getMaximum() {
        return this.getModelAt(0).getMaximum();
    }

    @Override
    public int getMinimum() {
        return this.getModelAt(0).getMinimum();
    }

    public int getThumbNum() {
        return this.thumbNum;
    }

    public Color getTrackFillColor() {
        return this.trackFillColor;
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    public int getValueAt(int index) {
        return this.getModelAt(index).getValue();
    }

    public void setEnabled(boolean bool, boolean paintThumb) {
        this.setEnabled(bool);
        ((BasicMThumbSliderUI)this.getUI()).setEnabled(paintThumb);
    }

    public void setTrackFillColor(Color color) {
        this.trackFillColor = color;
    }

    public void setValueAt(int n, int index) {
        this.getModelAt(index).setValue(n);
    }

    public void updateThumbLocations() {
        ((BasicMThumbSliderUI)this.getUI()).getAdditionalUI().calculateThumbsLocation();
    }

    @Override
    public void updateUI() {
        this.updateLabelUIs();
    }

    private void createThumbs(int n, int[] mins, int[] maxs, int[] startingVals) {
        this.thumbNum = n;
        this.sliderModels = new BoundedRangeModel[n];
        this.thumbRenderers = new Icon[n];
        this.fillColors = new Color[n];
        for (int i = 0; i < n; ++i) {
            this.sliderModels[i] = new DefaultBoundedRangeModel(startingVals[i], 0, mins[i], maxs[i]);
            this.thumbRenderers[i] = null;
            this.fillColors[i] = null;
        }
    }

    private BoundedRangeModel getModelAt(int index) {
        return this.sliderModels[index];
    }

    public void setRGB(boolean rgb) {
        ((BasicMThumbSliderUI)this.getUI()).setRgb(rgb);
    }
}

