/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.components.multithumbslider;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.components.multithumbslider.MThumbSliderAdditionalUI;
import edu.uthscsa.ric.utilities.AppLogger;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicSliderUI;

public class BasicMThumbSliderUI
extends BasicSliderUI {
    private BufferedImage arrowSelectorImage;
    private BufferedImage arrowSelectorNotFocusedImage;
    private BufferedImage lutImageFiltered;
    private MThumbSliderAdditionalUI additonalUi;
    private MouseInputAdapter mThumbTrackListener;
    private boolean enabled = true;
    private boolean rgb;
    private final Rectangle zeroRect = new Rectangle();
    public static final String LOGICAL_STR = "Logical";
    public static final String RGB_STR = "RGB";

    public BasicMThumbSliderUI() {
        super(null);
    }

    public BasicMThumbSliderUI(BufferedImage lutImage) {
        super(null);
        this.lutImageFiltered = lutImage;
        try {
            this.arrowSelectorImage = ImageIO.read(Mango.class.getResourceAsStream("images/arrow.gif"));
        }
        catch (IOException ex) {
            AppLogger.warn((Throwable)ex);
        }
        try {
            this.arrowSelectorNotFocusedImage = ImageIO.read(Mango.class.getResourceAsStream("images/arrow_not_focused.gif"));
        }
        catch (IOException ex) {
            AppLogger.warn((Throwable)ex);
        }
    }

    private BasicMThumbSliderUI(JSlider b) {
        super(b);
    }

    public MThumbSliderAdditionalUI getAdditionalUI() {
        return this.additonalUi;
    }

    public void recalculateIfInsetsChangedPublic() {
        super.recalculateIfInsetsChanged();
    }

    public Dimension getThumbSizePublic() {
        return super.getThumbSize();
    }

    public Rectangle getTrackRect() {
        return this.trackRect;
    }

    @Override
    public void installUI(JComponent c) {
        this.additonalUi = new MThumbSliderAdditionalUI(this);
        this.additonalUi.installUI(c);
        this.mThumbTrackListener = this.createMThumbTrackListener();
        super.installUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Rectangle clip = g.getClipBounds();
        this.thumbRect = this.zeroRect;
        super.paint(g, c);
        int thumbNum = this.additonalUi.getThumbNum();
        Rectangle[] thumbRects = this.additonalUi.getThumbRects();
        for (int i = thumbNum - 1; 0 <= i; --i) {
            if (!clip.intersects(thumbRects[i])) continue;
            this.thumbRect = thumbRects[i];
            this.paintThumb(g);
        }
    }

    @Override
    public void paintThumb(Graphics g) {
        if (this.enabled && (this.thumbRect.x != 0 || this.thumbRect.y != 0)) {
            Graphics2D g2d = (Graphics2D)g;
            if (this.slider.isEnabled()) {
                g2d.drawImage(this.arrowSelectorImage, null, this.thumbRect.x - 1, this.thumbRect.y);
            } else {
                g2d.drawImage(this.arrowSelectorNotFocusedImage, null, this.thumbRect.x - 1, this.thumbRect.y);
            }
        }
    }

    @Override
    public void paintTrack(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform transform = new AffineTransform((double)this.trackRect.width / (double)this.lutImageFiltered.getWidth(), 0.0, 0.0, 1.0, (double)this.trackRect.x, (double)this.trackRect.y);
        g2d.setColor(Color.GRAY);
        g2d.drawRect(this.trackRect.x - 1, this.trackRect.y - 1, this.trackRect.width + 1, 11);
        g2d.drawImage(this.lutImageFiltered, transform, null);
        if (!this.enabled) {
            g2d.setColor(Color.BLACK);
            g2d.setFont(new Font("Arial", 1, 16));
            TextLayout textLayout = new TextLayout(LOGICAL_STR, g2d.getFont(), g2d.getFontRenderContext());
            int textLayoutWidth = (int)textLayout.getBounds().getWidth();
            int locX = this.trackRect.x + this.trackRect.width / 2 - textLayoutWidth / 2;
            g2d.drawString(LOGICAL_STR, locX, this.trackRect.y + 15);
        }
    }

    @Override
    public void scrollByBlock(int direction) {
    }

    @Override
    public void scrollByUnit(int direction) {
    }

    public void setEnabled(boolean bool) {
        this.enabled = bool;
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.additonalUi.uninstallUI(c);
        this.additonalUi = null;
        this.mThumbTrackListener = null;
    }

    public int getxPositionForValue(int value) {
        return super.xPositionForValue(value);
    }

    public int getyPositionForValue(int value) {
        return super.yPositionForValue(value);
    }

    @Override
    protected void calculateGeometry() {
        super.calculateGeometry();
        this.additonalUi.calculateThumbsSize();
        this.additonalUi.calculateThumbsLocation();
    }

    @Override
    protected void calculateThumbLocation() {
    }

    @Override
    protected ChangeListener createChangeListener(JSlider slider) {
        return this.additonalUi.changeHandler;
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return null;
    }

    @Override
    protected void installListeners(JSlider slider) {
        slider.addMouseListener(this.mThumbTrackListener);
        slider.addMouseMotionListener(this.mThumbTrackListener);
        slider.addFocusListener(this.focusListener);
        slider.addComponentListener(this.componentListener);
        slider.addPropertyChangeListener(this.propertyChangeListener);
        slider.getModel().addChangeListener(this.changeListener);
    }

    @Override
    protected void uninstallListeners(JSlider slider) {
        slider.removeMouseListener(this.mThumbTrackListener);
        slider.removeMouseMotionListener(this.mThumbTrackListener);
        slider.removeFocusListener(this.focusListener);
        slider.removeComponentListener(this.componentListener);
        slider.removePropertyChangeListener(this.propertyChangeListener);
        slider.getModel().removeChangeListener(this.changeListener);
    }

    private MouseInputAdapter createMThumbTrackListener() {
        return this.additonalUi.trackListener;
    }

    public boolean isRgb() {
        return this.rgb;
    }

    public void setRgb(boolean rgb) {
        this.rgb = rgb;
    }
}

