/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.components.menus;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.UIManager;

public final class MangoSquareMenuItem
extends JMenuItem {
    private Color currentColor;
    private Color fillColor;
    private Image image;
    private int iconHeight;
    private int iconWidth;
    private static final Color ARMED = ((Color)UIManager.getDefaults().get("Menu.background")).darker();
    private static final Color BACKGROUND = (Color)UIManager.getDefaults().get("Menu.background");
    private static final int DEFAULT_ICON_SIZE = 24;
    private static final long serialVersionUID = 1L;

    public MangoSquareMenuItem(Color fillColor) {
        this();
        this.fillColor = fillColor;
    }

    public MangoSquareMenuItem(ImageIcon icon) {
        this();
        this.setIcon(icon);
    }

    protected MangoSquareMenuItem() {
        super("");
        this.setMargin(new Insets(0, 0, 0, 0));
        this.currentColor = BACKGROUND;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                MangoSquareMenuItem.this.currentColor = ARMED;
                MangoSquareMenuItem.this.getParent().repaint();
            }

            @Override
            public void mouseExited(MouseEvent me) {
                MangoSquareMenuItem.this.currentColor = BACKGROUND;
                MangoSquareMenuItem.this.getParent().repaint();
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                MangoSquareMenuItem.this.currentColor = BACKGROUND;
                MangoSquareMenuItem.this.getParent().repaint();
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.currentColor);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (this.image != null) {
            g.drawImage(this.image, (this.getSize().width - this.iconWidth) / 2, (this.getSize().height - this.iconHeight) / 2, null);
        } else if (this.fillColor != null) {
            g.setColor(this.fillColor);
            g.fillRect((this.getSize().width - 24) / 2, (this.getSize().height - 24) / 2, 24, 24);
        }
    }

    public void setIcon(ImageIcon icon) {
        if (icon != null) {
            this.image = icon.getImage();
            this.iconWidth = icon.getIconWidth();
            this.iconHeight = icon.getIconHeight();
        }
    }
}

