/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.components.menus;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.components.menus.MangoMenuUtil;
import java.awt.Font;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;

public class MangoMenuItem
extends JMenuItem {
    private final String label;
    private final boolean hideInApplet;
    private final int fontSize;
    private boolean italic;
    private static final long serialVersionUID = 1L;

    public MangoMenuItem(AbstractAction aa, String label, int fontSize, boolean hideInApplet) {
        this(aa, label, false, fontSize, hideInApplet);
    }

    public MangoMenuItem(String string, String label, int fontSize, boolean hideInApplet) {
        super(string);
        this.fontSize = fontSize;
        this.hideInApplet = hideInApplet;
        this.label = label;
        this.createUI();
    }

    public MangoMenuItem(AbstractAction aa, String label, boolean italic, int fontSize, boolean hideInApplet) {
        super(aa);
        this.fontSize = fontSize;
        this.hideInApplet = hideInApplet;
        this.italic = italic;
        this.label = label;
        this.createUI();
    }

    private void createUI() {
        MangoMenuUtil.addAction(this.label);
        this.setName(this.label);
        this.setFont(new Font("SansSerif", this.italic ? 2 : 0, this.fontSize));
        this.setVisible(!this.hideInApplet || !Mango.getInstance().isApplet());
    }

    public void setItalic(boolean italic) {
        if (italic) {
            this.setFont(new Font("SansSerif", 2, this.fontSize));
        } else {
            this.setFont(new Font("SansSerif", 0, this.fontSize));
        }
    }

    @Override
    public void setAction(Action aa) {
        boolean enabled = this.isEnabled();
        super.setAction(aa);
        this.setEnabled(enabled);
    }
}

