/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.components.focusableoptionpane;

import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPaneItem;
import edu.uthscsa.ric.mango.components.focusableoptionpane.MangoFocusableOptionPaneUser;
import edu.uthscsa.ric.mango.platform.DisplayUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class MangoFocusableOptionPane {
    private Frame parent;
    private Frame tempFrame;
    private JOptionPane jop;
    private MangoFocusableOptionPaneItem focusableItem;
    private MangoFocusableOptionPaneUser user;
    private String returnOption;
    private final JDialog jd;

    public MangoFocusableOptionPane(Frame aParent, Object dialog, String title, int messageType) {
        this(aParent, dialog, title, messageType, null, 2, null, null);
    }

    public MangoFocusableOptionPane(Frame aParent, Object dialog, String title, int messageType, Icon icon) {
        this(aParent, dialog, title, messageType, icon, 2, null, null);
    }

    public MangoFocusableOptionPane(Frame aParent, Object dialog, String title, int messageType, Icon icon, int optionType) {
        this(aParent, dialog, title, messageType, icon, optionType, null, null);
    }

    public MangoFocusableOptionPane(Frame aParent, Object dialog, String title, int messageType, Icon icon, int optionType, Object[] options, Object defaultOption) {
        this.parent = aParent;
        this.jd = new JDialog(this.parent, title, true);
        this.buildDialog(dialog, messageType, icon, optionType, options, defaultOption);
    }

    public MangoFocusableOptionPane(MangoFocusableOptionPaneUser aUser, Object dialog, String title, int messageType) {
        this(aUser, dialog, title, messageType, null, 2, null, null);
    }

    public MangoFocusableOptionPane(MangoFocusableOptionPaneUser aUser, Object dialog, String title, int messageType, Icon icon, int optionType, Object[] options, Object defaultOption) {
        this.user = aUser;
        this.tempFrame = new Frame();
        this.jd = new JDialog(this.tempFrame, title, true);
        this.buildDialog(dialog, messageType, icon, optionType, options, defaultOption);
    }

    public MangoFocusableOptionPaneItem getFocusableItem() {
        return this.focusableItem;
    }

    public JDialog getJDialog() {
        return this.jd;
    }

    public JOptionPane getJOptionPane() {
        return this.jop;
    }

    public String getReturnOption() {
        return this.returnOption;
    }

    public void repack() {
        this.jd.pack();
    }

    public void setFocusableItem(MangoFocusableOptionPaneItem focusableItem) {
        this.focusableItem = focusableItem;
    }

    public void setInitialValue(Object val) {
        if (this.jop != null) {
            this.jop.setInitialValue(val);
        }
    }

    public void setOptions(Object[] options) {
        if (this.jop != null) {
            this.jop.setOptions(options);
        }
    }

    public void setReturnOption(String returnOption) {
        this.returnOption = returnOption;
    }

    public int show() {
        return this.show(false, false);
    }

    public int show(boolean screenCenter) {
        return this.show(screenCenter, false);
    }

    public int show(boolean screenCenter, boolean below) {
        this.showAndCenter(screenCenter, below);
        this.jd.setResizable(false);
        if (this.focusableItem != null) {
            this.focusableItem.doFocus();
        }
        this.jd.setAlwaysOnTop(true);
        this.jd.setVisible(true);
        this.jd.toFront();
        Object ob = this.jop.getValue();
        if (ob instanceof Integer) {
            return (Integer)ob;
        }
        this.returnOption = ob.toString();
        return 2;
    }

    public void showAndCenter() {
        this.showAndCenter(false, false);
    }

    private void buildDialog(Object dialog, int messageType, Icon icon, int optionType, Object[] options, Object defaultOption) {
        this.jop = new JOptionPane(dialog, messageType, optionType, icon, options, defaultOption);
        this.jop.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.jd.setContentPane(this.jop);
        this.jd.setDefaultCloseOperation(2);
        this.jd.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
            }
        });
        this.jop.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (MangoFocusableOptionPane.this.jd.isVisible() && e.getSource() == MangoFocusableOptionPane.this.jop && prop.equals("value")) {
                    MangoFocusableOptionPane.this.jd.setVisible(false);
                    MangoFocusableOptionPane.this.jd.dispose();
                    if (MangoFocusableOptionPane.this.tempFrame != null) {
                        MangoFocusableOptionPane.this.tempFrame.dispose();
                        MangoFocusableOptionPane.this.tempFrame = null;
                        MangoFocusableOptionPane.this.user.updateFocusState();
                    }
                }
            }
        });
    }

    private void showAndCenter(boolean screenCenter, boolean below) {
        this.jd.pack();
        Dimension jdDim = this.jd.getSize();
        if (screenCenter) {
            this.jd.setLocation(DisplayUtils.getCenterDialogLocation(this.parent, jdDim));
        } else if (this.parent != null) {
            if (below) {
                this.jd.setLocation(DisplayUtils.getNonOccludingDialogLocationRelative(this.parent, jdDim));
            } else {
                this.jd.setLocation(DisplayUtils.getCenterDialogLocationRelative(this.parent, jdDim));
            }
        } else if (this.user != null) {
            if (this.user instanceof Component) {
                this.jd.setLocation(DisplayUtils.getCenterDialogLocationRelative((Component)((Object)this.user), jdDim));
            } else {
                this.jd.setLocation(DisplayUtils.getCenterDialogLocationRelative(this.user.getBounds(), jdDim));
            }
        } else {
            this.jd.setLocation(DisplayUtils.getCenterDialogLocation(this.parent, jdDim));
        }
    }
}

