/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.components.colorpicker;

import edu.uthscsa.ric.mango.components.MangoColorButton;
import edu.uthscsa.ric.mango.components.MangoColorIconPanel;
import edu.uthscsa.ric.mango.components.MangoColorSelectedListener;
import edu.uthscsa.ric.mango.components.colorpicker.MangoColorPickerListener;
import edu.uthscsa.ric.mango.components.colorpicker.MangoColorPickerPopupManager;
import edu.uthscsa.ric.mango.platform.Platform;
import edu.uthscsa.ric.roi.ColorManager;
import edu.uthscsa.ric.roi.ROIColor;
import edu.uthscsa.ric.roi.ROIDefaultLabels;
import edu.uthscsa.ric.volume.LabelManager;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class MangoColorPicker
extends JPanel
implements MouseListener {
    private JLabel editLabels;
    private JLabel moreColorsLabels;
    private JLabel roiInspectorLabel;
    private final LabelManager labelManager;
    private final MangoColorPickerListener listener;
    private final MangoColorSelectedListener colorSelectionListener;
    private final ColorManager colorManager;
    private final boolean showOptions;
    private final boolean showUnused;
    private final int numColors;
    private static AWTEventListener awtEventListener;
    private static MangoColorPickerPopupManager popupManager;
    private static final long serialVersionUID = 1L;
    public static final Color ARMED;
    public static final Color BACKGROUND;
    public static final int COLORS_16 = 16;
    public static final int COLORS_16_COLS = 8;
    public static final int COLORS_16_ROWS = 2;
    public static final int COLORS_32 = 32;
    public static final int COLORS_32_COLS = 8;
    public static final int COLORS_32_ROWS = 4;
    public static final int COLORS_64 = 64;
    public static final int COLORS_64_COLS = 8;
    public static final int COLORS_64_ROWS = 8;
    public static final int COLORS_8 = 8;
    public static final int COLORS_8_COLS = 8;
    public static final int COLORS_8_ROWS = 1;
    public static final int FONT_SIZE = 11;
    public static final int PADDING = 4;

    private static void registerPopup() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        long eventMask = 16L;
        if (!Platform.isSandboxed()) {
            awtEventListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent e) {
                    MouseEvent me;
                    if (!(e.getSource() instanceof MangoColorButton) && e instanceof MouseEvent && (me = (MouseEvent)e).getID() == 500) {
                        popupManager.closeColorPickerPopup();
                        MangoColorPicker.unregisterPopup();
                    }
                }
            };
            tk.addAWTEventListener(awtEventListener, 16L);
        }
    }

    private static synchronized void setPopupManager(MangoColorPickerPopupManager popupManager) {
        MangoColorPicker.popupManager = popupManager;
        MangoColorPicker.registerPopup();
    }

    private static void unregisterPopup() {
        if (!Platform.isSandboxed()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.removeAWTEventListener(awtEventListener);
            awtEventListener = null;
        }
    }

    public MangoColorPicker(ColorManager colorManager, MangoColorPickerListener listener, MangoColorPickerPopupManager popupManager, LabelManager labelManager, int numColors) {
        this.colorManager = colorManager;
        this.listener = listener;
        this.colorSelectionListener = listener;
        this.labelManager = labelManager;
        this.numColors = numColors;
        if (numColors != 8 && numColors != 16 && numColors != 32 && numColors != 64) {
            throw new IllegalArgumentException();
        }
        this.showUnused = true;
        this.showOptions = true;
        MangoColorPicker.setPopupManager(popupManager);
        this.createUI();
    }

    public MangoColorPicker(ColorManager colorManager, MangoColorSelectedListener listener, LabelManager labelManager, int numColors, boolean showUnused) {
        this.colorManager = colorManager;
        this.listener = null;
        this.colorSelectionListener = listener;
        this.labelManager = labelManager;
        this.numColors = numColors;
        if (numColors != 8 && numColors != 16 && numColors != 32 && numColors != 64) {
            throw new IllegalArgumentException();
        }
        this.showUnused = showUnused;
        this.showOptions = false;
        this.createUI();
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        JLabel label = (JLabel)me.getSource();
        if (label == this.editLabels) {
            this.listener.editColorLabels();
        } else if (label == this.moreColorsLabels) {
            this.listener.addMoreColors();
        } else if (label == this.roiInspectorLabel) {
            this.listener.openInspector();
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
        ((JLabel)me.getSource()).setBackground(ARMED);
        ((JLabel)me.getSource()).setForeground(Color.WHITE);
    }

    @Override
    public void mouseExited(MouseEvent me) {
        ((JLabel)me.getSource()).setBackground(BACKGROUND);
        ((JLabel)me.getSource()).setForeground(Color.BLACK);
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    private void createUI() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel colorPickerPanel = new JPanel();
        int cols = 0;
        int rows = 0;
        if (this.numColors == 8) {
            rows = 1;
            cols = 8;
        } else if (this.numColors == 16) {
            rows = 2;
            cols = 8;
        } else if (this.numColors == 32) {
            rows = 4;
            cols = 8;
        } else if (this.numColors == 64) {
            rows = 8;
            cols = 8;
        }
        colorPickerPanel.setLayout(new GridLayout(rows, cols, 4, 4));
        Vector<ROIColor> colorSet = ROIColor.getColorsDisplayOrder(this.numColors / 8);
        for (int ctrR = 0; ctrR < rows; ++ctrR) {
            for (int ctrC = 0; ctrC < cols; ++ctrC) {
                int color = ctrR * cols + ctrC;
                ROIColor roiColor = colorSet.get(color);
                MangoColorIconPanel colorPanel = new MangoColorIconPanel(this.colorManager, this.colorSelectionListener, roiColor, this.labelManager.getLabel(roiColor.getIndex(), ROIDefaultLabels.getDefaultLabelDisplayOrder(color, this.numColors)), this.showUnused);
                colorPanel.setUseButtonBorder(true);
                colorPanel.setEnabled(this.colorManager.isUsed(roiColor.getIndex()) || this.showUnused);
                colorPickerPanel.add(colorPanel);
            }
        }
        mainPanel.add(colorPickerPanel);
        if (this.showOptions) {
            mainPanel.add(Box.createVerticalStrut(4));
            this.editLabels = new JLabel("<html><center>Edit color labels...</center></html>", 0);
            this.editLabels.setFont(new Font("SansSerif", 0, 11));
            this.editLabels.addMouseListener(this);
            this.editLabels.setOpaque(true);
            JPanel editLabelsPanel = new JPanel();
            editLabelsPanel.setLayout(new BoxLayout(editLabelsPanel, 0));
            editLabelsPanel.add(this.editLabels);
            mainPanel.add(editLabelsPanel);
            this.moreColorsLabels = new JLabel("<html><center>Add more colors...</center></html>", 0);
            this.moreColorsLabels.setFont(new Font("SansSerif", 0, 11));
            this.moreColorsLabels.addMouseListener(this);
            this.moreColorsLabels.setOpaque(true);
            JPanel moreLabelsPanel = new JPanel();
            moreLabelsPanel.setLayout(new BoxLayout(moreLabelsPanel, 0));
            moreLabelsPanel.add(this.moreColorsLabels);
            if (this.numColors < 64) {
                mainPanel.add(moreLabelsPanel);
            }
            this.roiInspectorLabel = new JLabel("<html><center>Find and select ROIs...</center></html>", 0);
            this.roiInspectorLabel.setFont(new Font("SansSerif", 0, 11));
            this.roiInspectorLabel.addMouseListener(this);
            this.roiInspectorLabel.setOpaque(true);
            JPanel roiInspectorPanel = new JPanel();
            roiInspectorPanel.setLayout(new BoxLayout(roiInspectorPanel, 0));
            roiInspectorPanel.add(this.roiInspectorLabel);
            mainPanel.add(roiInspectorPanel);
        }
        mainPanel.setBackground(BACKGROUND);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setLayout(new BoxLayout(this, 1));
        this.add(mainPanel);
        if (!Platform.MAC) {
            this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        }
    }

    static {
        ARMED = (Color)UIManager.getDefaults().get("Menu.selectionBackground");
        BACKGROUND = (Color)UIManager.getDefaults().get("Menu.background");
    }
}

