/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.components;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public class MangoTextField
extends JTextField {
    private int code;
    private boolean fireActionWhenFocusLost;
    private boolean ignoreCaretOnSelect;
    private static final long serialVersionUID = 1L;

    public MangoTextField(String string) {
        super(string);
        this.createUI();
    }

    public MangoTextField(String string, int size) {
        super(string, size);
        this.createUI();
    }

    public MangoTextField(String string, int size, KeyListener keyListener, boolean fireActionWhenFocusLost) {
        super(string, size);
        if (keyListener != null) {
            this.addKeyListener(keyListener);
        }
        this.fireActionWhenFocusLost = fireActionWhenFocusLost;
        this.createUI();
    }

    public MangoTextField(String string, int size, KeyListener keyListener, boolean fireActionWhenFocusLost, boolean ignoreCaretOnSelect) {
        this(string, size, keyListener, fireActionWhenFocusLost);
        this.ignoreCaretOnSelect = ignoreCaretOnSelect;
    }

    public MangoTextField(String string, KeyListener keyListener, boolean fireActionWhenFocusLost, boolean ignoreCaretOnSelect) {
        super(string);
        if (keyListener != null) {
            this.addKeyListener(keyListener);
        }
        this.fireActionWhenFocusLost = fireActionWhenFocusLost;
        this.ignoreCaretOnSelect = ignoreCaretOnSelect;
        this.createUI();
    }

    private void createUI() {
        super.setFocusable(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
                if (MangoTextField.this.ignoreCaretOnSelect) {
                    MangoTextField.this.selectAll();
                } else {
                    MangoTextField.this.setCaretPosition(MangoTextField.this.getDocument().getLength());
                    MangoTextField.this.moveCaretPosition(0);
                }
            }

            @Override
            public void focusLost(FocusEvent fe) {
                if (MangoTextField.this.fireActionWhenFocusLost) {
                    MangoTextField.this.fireActionPerformed();
                }
            }
        });
    }

    public boolean isFireActionWhenFocusLost() {
        return this.fireActionWhenFocusLost;
    }

    public void setFireActionWhenFocusLost(boolean fireActionWhenFocusLost) {
        this.fireActionWhenFocusLost = fireActionWhenFocusLost;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }
}

