/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.components;

import edu.uthscsa.ric.mango.Mango;
import edu.uthscsa.ric.mango.MangoStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;

public class MangoSquareButton
extends JButton {
    private Mango mango;
    private boolean bringToFront;
    private static final Border BORDER_NORMAL = BorderFactory.createEtchedBorder();
    private static final Border BORDER_PRESSED = BorderFactory.createLoweredBevelBorder();
    private static final Dimension SIZE = new Dimension(35, 35);
    private static final int DEFAULT_ICON_SIZE = 24;
    private static final long serialVersionUID = 1L;

    public MangoSquareButton() {
        this.createUI();
    }

    public MangoSquareButton(final Color color, boolean toFront, Mango me) {
        this(new Icon(){

            @Override
            public int getIconHeight() {
                return 24;
            }

            @Override
            public int getIconWidth() {
                return 24;
            }

            @Override
            public void paintIcon(Component comp, Graphics g, int arg2, int arg3) {
                g.setColor(color);
                g.fillRect((SIZE.width - 24) / 2, (SIZE.height - 24) / 2, 24, 24);
            }
        }, toFront, me);
    }

    public MangoSquareButton(Icon icon, boolean toFront, Mango me) {
        super(icon);
        this.mango = me;
        this.bringToFront = toFront;
        this.createUI();
    }

    public MangoSquareButton(Icon icon, Mango me) {
        this(icon, true, me);
    }

    public MangoSquareButton(Mango me) {
        this((Icon)null, false, me);
    }

    public void setIcon(final Color color) {
        Icon icon = new Icon(){

            @Override
            public int getIconHeight() {
                return 24;
            }

            @Override
            public int getIconWidth() {
                return 24;
            }

            @Override
            public void paintIcon(Component comp, Graphics g, int arg2, int arg3) {
                g.setColor(color);
                g.fillRect((SIZE.width - 24) / 2, (SIZE.height - 24) / 2, 24, 24);
            }
        };
        super.setIcon(icon);
    }

    private void createUI() {
        this.setBorder(BORDER_NORMAL);
        this.setPreferredSize(SIZE);
        this.setMinimumSize(SIZE);
        this.setMaximumSize(SIZE);
        this.setRolloverEnabled(true);
        this.setPressedIcon(MangoStyle.ICON_ROI_BLANK);
        this.setContentAreaFilled(false);
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent me) {
                MangoSquareButton.this.setBorder(BORDER_NORMAL);
            }

            @Override
            public void mousePressed(MouseEvent me) {
                if (MangoSquareButton.this.isEnabled()) {
                    MangoSquareButton.this.setBorder(BORDER_PRESSED);
                }
                if (MangoSquareButton.this.bringToFront && MangoSquareButton.this.mango != null && MangoSquareButton.this.mango.getCurrentViewerFrame() != null) {
                    MangoSquareButton.this.mango.getCurrentViewerFrame().toFront();
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                MangoSquareButton.this.setBorder(BORDER_NORMAL);
            }
        });
    }
}

