/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.components;

import edu.uthscsa.ric.mango.components.MangoTextField;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import org.apache.commons.lang3.StringUtils;

public final class MangoPlaceholderTextField
extends MangoTextField {
    private String placeholderText;
    public static final Color PLACEHOLDER_COLOR = Color.LIGHT_GRAY;
    public static final Color TEXT_COLOR = Color.BLACK;
    private static final long serialVersionUID = 1L;

    public MangoPlaceholderTextField(String placeholderText) {
        super("");
        this.placeholderText = placeholderText;
        this.createUI();
    }

    public MangoPlaceholderTextField(String placeholderText, int size) {
        super("", size);
        this.placeholderText = placeholderText;
        this.createUI();
    }

    private void createUI() {
        this.fillPlaceholder();
        super.setFocusable(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
                if (MangoPlaceholderTextField.super.getText().equals(MangoPlaceholderTextField.this.placeholderText)) {
                    MangoPlaceholderTextField.this.removePlaceholder();
                }
            }

            @Override
            public void focusLost(FocusEvent fe) {
                if (StringUtils.isBlank((CharSequence)MangoPlaceholderTextField.super.getText())) {
                    MangoPlaceholderTextField.this.fillPlaceholder();
                }
            }
        });
    }

    private void fillPlaceholder() {
        this.setForeground(PLACEHOLDER_COLOR);
        super.setText(this.placeholderText);
    }

    private void removePlaceholder() {
        this.setForeground(TEXT_COLOR);
        super.setText("");
    }

    @Override
    public String getText() {
        String string = super.getText();
        if (string.equals(this.placeholderText)) {
            return "";
        }
        return string;
    }

    public String getPlaceholderText() {
        return this.placeholderText;
    }

    public void setPlaceholderText(String placeholderText) {
        this.placeholderText = placeholderText;
        if (StringUtils.isBlank((CharSequence)this.getText())) {
            this.fillPlaceholder();
        }
    }

    @Override
    public void setText(String text) {
        if (StringUtils.isNotBlank((CharSequence)text)) {
            this.removePlaceholder();
            super.setText(text);
        } else {
            super.setText(text);
            this.fillPlaceholder();
        }
    }
}

