/*
 * Decompiled with CFR 0.152.
 */
package edu.uthscsa.ric.mango.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class MangoMultiComboBox<T>
extends JComboBox<T>
implements ActionListener {
    private final Map<Object, Boolean> map = new HashMap<Object, Boolean>();
    private static final long serialVersionUID = 1L;

    public MangoMultiComboBox() {
        this.setRenderer(new CheckComboRenderer());
        this.addActionListener(this);
    }

    @Override
    public void addItem(T obj) {
        this.map.put(obj, Boolean.FALSE);
        super.addItem(obj);
    }

    private int getNumSelected() {
        int count = 0;
        int numItems = this.getItemCount();
        for (int ctr = 0; ctr < numItems; ++ctr) {
            Object obj = this.getItemAt(ctr);
            if (!this.map.get(obj).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    private String getFirstSelected() {
        int numItems = this.getItemCount();
        for (int ctr = 0; ctr < numItems; ++ctr) {
            Object obj = this.getItemAt(ctr);
            if (!this.map.get(obj).booleanValue()) continue;
            return obj.toString();
        }
        return "";
    }

    public List<Object> getAllSelected() {
        int numItems = this.getItemCount();
        ArrayList<Object> stores = new ArrayList<Object>();
        for (int ctr = 0; ctr < numItems; ++ctr) {
            Object obj = this.getItemAt(ctr);
            if (!this.map.get(obj).booleanValue()) continue;
            stores.add(obj);
        }
        return stores;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object obj;
        JComboBox cb = (JComboBox)ae.getSource();
        this.map.put(obj, this.map.get(obj = cb.getSelectedItem()) == false);
        this.repaint();
    }

    class CheckComboRenderer<E>
    implements ListCellRenderer<T> {
        JCheckBox checkBox = new JCheckBox();

        @Override
        public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index == -1) {
                int numSelected = MangoMultiComboBox.this.getNumSelected();
                String label = null;
                label = numSelected == 0 ? "<html><i>Nothing selected</i></html>" : (numSelected == 1 ? MangoMultiComboBox.this.getFirstSelected() : (numSelected == 2 ? "<html><i>Two items selected</i></html>" : (numSelected == 3 ? "<html><i>Three items selected</i></html>" : "<html><i>Multiple items selected</i></html>")));
                return new JLabel(label);
            }
            this.checkBox.setText(value.toString());
            this.checkBox.setSelected((Boolean)MangoMultiComboBox.this.map.get(value));
            this.checkBox.setBackground(isSelected ? Color.lightGray : Color.white);
            this.checkBox.setForeground(isSelected ? Color.white : Color.black);
            return this.checkBox;
        }
    }
}

